/**
	Album Cover Grabber - Grabs album covers automatically off the internet
	Copyright (C) 2002  Kevin M Schmidt

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.allmusic.pages;

import java.net.*;
import java.util.*;

import org.apache.regexp.*;
import com.bluedragontavern.albumgrabber.*;
import com.bluedragontavern.albumgrabber.util.*;

public class MultipleArtistsPage
{
	private String html = null;
	private Vector artistNames = new Vector();
	private Vector artistUrls = new Vector();

	/**
	 * Constructor
	 */
	public MultipleArtistsPage(String html)
		throws Exception
	{
		this.html = html;

		/*
		<tr class="visible" id="trlink" onclick="z('11:oz5tk6kx9kr0')"><td class="sorted-cell"><div class="bar" style="width:56px;">&nbsp;</div></td><TD class="cell">&nbsp;</TD><TD class="cell" style="width:190px;word-wrap:break-word;"><a href="/cg/amg.dll?p=amg&sql=11:cln8b594tsqa">King</a></TD><TD class="cell" style="width:254px;word-wrap:break-word;">Rock</TD><TD class="cell">80s</td></tr>

		  <div class="expand"></div>

		<tr class="visible" id="trlink" onclick="z('11:87220rjay48c')"><td class="sorted-cell"><div class="bar" style="width:56px;">&nbsp;</div></td><TD class="cell">&nbsp;</TD><TD class="cell" style="width:190px;word-wrap:break-word;"><a href="/cg/amg.dll?p=amg&sql=11:hd2gtq0zmu46">The King</a></TD><TD class="cell" style="width:254px;word-wrap:break-word;">Rock</TD><TD class="cell">90s</td></tr>

		  <div class="expand"></div>
		 */

		//Build a map of artist/artistUrl
		RE hits = new RE("<tr .*?><td .*?</td><TD .*?</TD><TD .*?<a href=\"(.*?)\">(.*?)</a></TD><TD .*?</TD><TD .*?</td></tr>");

		//Get a list of all the hits
		int index = 0;

		while (hits.match(html, index))
		{
			artistUrls.add(hits.getParen(1));
			artistNames.add(hits.getParen(2));

			index = hits.getParenEnd(2);

			if (Constants.DEBUG)
			{
				System.out.println("MultipleArtistsPage:artistName = " +
										 artistNames.lastElement());
				System.out.println("MultipleArtistsPage:artistUrl = " +
										 artistUrls.lastElement());
			}
		}
	}

	/**
	 * Process multiple artists listing page
	 * @param album DOCUMENT ME!
	 * @param html DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public Artist getArtist(Artist artist)
		throws Exception
	{
		//If no hits found, just return
		if (artistNames.size() == 0)
		{
			return artist;
		}

		//Now we have to decide which is the CORRECT artist!
		Vector indexScores = CompareStrings.findBestMatchingOrder(artistNames,
			artist.getSearchArtistName());
		Iterator iter = indexScores.iterator();

		while (iter.hasNext())
		{
			int bestMatch = ( (IndexScore) iter.next()).getIndex();
			Artist bestMatchArtist = new Artist(artist.getArtistDir());
			bestMatchArtist.setFoundArtistName( (String) artistNames.elementAt(
				bestMatch));
			bestMatchArtist.setArtistUrl( (String) artistUrls.elementAt(bestMatch));

			//Get the URL to the artist page
			URL url = new URL("http://www.allmusic.com" +
									bestMatchArtist.getArtistUrl());
			html = NetUtil.doGet(url, null);

			ArtistPage artistPage = new ArtistPage(html);
			bestMatchArtist = artistPage.getArtist(bestMatchArtist);

			if (bestMatchArtist.isFound())
			{
				return bestMatchArtist;
			}
		}

		//No artist found :v(
		return artist;
	}

	/**
	 * Process multiple artists listing page
	 * @param album DOCUMENT ME!
	 * @param html DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public Album getAlbum(Album album)
		throws Exception
	{
		//If no hits found, just return
		if (artistNames.size() == 0)
		{
			return album;
		}

		//Now we have to decide which is the CORRECT artist!
		Vector indexScores = CompareStrings.findBestMatchingOrder(artistNames,
			album.getSearchArtistName());
		Iterator iter = indexScores.iterator();

		while (iter.hasNext())
		{
			int bestMatch = ( (IndexScore) iter.next()).getIndex();
			Album bestMatchAlbum = new Album(album.getAlbumDir());
			bestMatchAlbum.setFoundArtistName( (String) artistNames.elementAt(
				bestMatch));
			bestMatchAlbum.setArtistUrl( (String) artistUrls.elementAt(bestMatch));

			//Get the URL to the artist page
			URL url = new URL("http://www.allmusic.com" +
									bestMatchAlbum.getArtistUrl());
			html = NetUtil.doGet(url, null);

			ArtistPage artistPage = new ArtistPage(html);
			bestMatchAlbum = artistPage.getDiscography().getAlbum(bestMatchAlbum);

			if (bestMatchAlbum.isFound())
			{
				return bestMatchAlbum;
			}
		}

		//No album found :v(
		return album;
	}
}
