/**
	  Album Cover Grabber - Grabs album covers automatically off the internet
	  Copyright (C) 2002  Kevin M Schmidt

	  This program is free software; you can redistribute it and/or modify
	  it under the terms of the GNU General Public License as published by
	  the Free Software Foundation; either version 2 of the License, or
	  (at your option) any later version.

	  This program is distributed in the hope that it will be useful,
	  but WITHOUT ANY WARRANTY; without even the implied warranty of
	  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	  GNU General Public License for more details.

	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.google;

import java.net.*;
import java.util.*;

import org.apache.regexp.*;
import com.bluedragontavern.albumgrabber.*;
import com.bluedragontavern.albumgrabber.util.*;

public class ImageSearch
{
	/**
	 * Get the thumbnails for this search
	 */
	public static Vector getThumbnails(String searchTerm, int startNum)
		throws Exception
	{
		System.out.println("Searching for... " + searchTerm);

		Vector thumbnails = new Vector();
		String uriSearchTerm = URLEncoder.encode(searchTerm, "UTF-8");
		URL url;

		if (startNum == 0)
		{
			url = new URL("http://images.google.com/images?q=" + uriSearchTerm +
							  "&ie=ISO-8859-1&hl=en&btnG=Google+Search");
		}
		else
		{
			url = new URL("http://images.google.com/images?q=" + uriSearchTerm +
							  "&svnum=10&hl=en&lr=&ie=UTF-8&start=" + startNum +
							  "&sa=N");
		}

		String html = NetUtil.doGet(url, null);
		RE hits = new RE("<td.*?imgurl=(.*?)&imgrefurl=.*?<img src=(.*?) .*?<font size=-1>(.*?)<br>.*?</td>");
		int index = 0;

		while (hits.match(html, index))
		{
			try
			{
				Thumbnail thumb = new Thumbnail(hits.getParen(1),
														  "http://images.google.com" +
														  hits.getParen(2), hits.getParen(3));
				thumbnails.add(thumb);

				if (Constants.DEBUG)
				{
					System.out.println("Google:ImageSearch:fullImageUrl = " +
											 thumb.getFullImageUrl());
					System.out.println("Google:ImageSearch:thumbnailUrl = " +
											 thumb.getThumbnailUrl());
					System.out.println("Google:ImageSearch:sizeDescription = " +
											 thumb.getSizeDescription());
				}
			}
			catch (Exception ex)
			{
				//Skip any thumbnails where the image bytes are not found
			}

			index = hits.getParenEnd(3);
		}

		return thumbnails;
	}

	/**
	 * Test main
	 */
	public static void main(String[] argv)
	{
		try
		{
			Vector thumbs = getThumbnails("Wierd Al Yankovic", 0);
			Iterator iter = thumbs.iterator();

			while (iter.hasNext())
			{
				System.out.println( (Thumbnail) iter.next());
			}
		}
		catch (Exception ex)
		{
			System.out.println(ex);
		}
	}
}