/**
	  Album Cover Grabber - Grabs album covers automatically off the internet
	  Copyright (C) 2002  Kevin M Schmidt

	  This program is free software; you can redistribute it and/or modify
	  it under the terms of the GNU General Public License as published by
	  the Free Software Foundation; either version 2 of the License, or
	  (at your option) any later version.

	  This program is distributed in the hope that it will be useful,
	  but WITHOUT ANY WARRANTY; without even the implied warranty of
	  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	  GNU General Public License for more details.

	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.gui;

import java.io.*;
import java.util.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import com.bluedragontavern.albumgrabber.util.*;

public class Mp3RootChooser
	extends Observable implements ActionListener
{
	private static Mp3RootChooser instance = null;
	private JCheckBox albumCheckBox = null;
	private JCheckBox artistCheckBox = null;
	private JCheckBox cropArtistCheckBox = null;
	private JTextField mp3RootTextField = null;
	private JCheckBox proxyCheckBox = null;
	private JLabel proxyHostLabel = null;
	private JTextField proxyHostField = null;
	private JLabel proxyPortLabel = null;
	private JTextField proxyPortField = null;
	private JLabel usernameLabel = null;
	private JTextField usernameField = null;
	private JLabel passwordLabel = null;
	private JPasswordField passwordField = null;
	private JButton goButton = null;
	private JFrame frame = null;
	private JRadioButton albumGoogleRadioButton = null;
	private JRadioButton albumAllmusicRadioButton = null;
	private JRadioButton artistGoogleRadioButton = null;
	private JRadioButton artistAllmusicRadioButton = null;
	public final static String COMMAND_GO = "Go";
	public final static String COMMAND_BROWSE = "Browse";
	public final static String COMMAND_PROXYCHECK = "ProxyCheck";
	public final static String COMMAND_ALBUMCHECK = "AlbumCheck";
	public final static String COMMAND_ARTISTCHECK = "ArtistCheck";
	public final static String COMMAND_ALBUMGOOGLERADIO = "AlbumGoogleRadio";
	public final static String COMMAND_ALBUMALLMUSICRADIO = "AlbumAllMusicRadio";
	public final static String COMMAND_ARTISTGOOGLERADIO = "ArtistGoogleRadio";
	public final static String COMMAND_ARTISTALLMUSICRADIO =
		"ArtistAllMusicRadio";

	/**
	 * Singleton get method
	 */
	public synchronized static Mp3RootChooser getInstance()
	{
		if (instance == null)
		{
			instance = new Mp3RootChooser();
		}

		return instance;
	}

	/**
	 * Creates a new Mp3RootChooser object.
	 */
	private Mp3RootChooser()
	{
		frame = new JFrame();
		frame.setTitle("Album Cover Grabber - by Kevin Schmidt");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocation(300, 200);

		//Construct the main panel and add to the frame
		JPanel mainPanel = new JPanel(new BorderLayout());
		frame.getContentPane().add(mainPanel);

		//Construct the center box
		Box centerBox = Box.createVerticalBox();

		//Construct the MP3 root row
		Box mp3RootRow = Box.createHorizontalBox();
		centerBox.add(mp3RootRow);

		JLabel mp3RootLabel = new JLabel("MP3 Root");
		mp3RootRow.add(mp3RootLabel);
		mp3RootTextField = new JTextField(30);
		mp3RootRow.add(mp3RootTextField);

		JButton browseButton = new JButton("Browse");
		browseButton.setActionCommand(COMMAND_BROWSE);
		browseButton.addActionListener(this);
		mp3RootRow.add(browseButton);

		Box optionsRow = Box.createHorizontalBox();
		centerBox.add(optionsRow);

		JPanel albumOptionsPanel = new JPanel();
		albumOptionsPanel.setBorder(BorderFactory.createEtchedBorder(
			EtchedBorder.LOWERED));

		Box albumOptionsBox = Box.createVerticalBox();
		albumOptionsPanel.add(albumOptionsBox);
		albumCheckBox = new JCheckBox("Download Album Covers");
		albumCheckBox.setSelected(true);
		albumCheckBox.addActionListener(this);
		albumCheckBox.setActionCommand(COMMAND_ALBUMCHECK);
		albumOptionsBox.add(albumCheckBox);

		ButtonGroup albumButtonGroup = new ButtonGroup();
		albumGoogleRadioButton = new JRadioButton("Download from Google");
		albumGoogleRadioButton.addActionListener(this);
		albumGoogleRadioButton.setActionCommand(COMMAND_ALBUMGOOGLERADIO);
		albumGoogleRadioButton.setSelected(true);
		albumButtonGroup.add(albumGoogleRadioButton);
		albumOptionsBox.add(albumGoogleRadioButton);
		albumAllmusicRadioButton = new JRadioButton("Download from AllMusic");
		albumAllmusicRadioButton.addActionListener(this);
		albumAllmusicRadioButton.setActionCommand(COMMAND_ALBUMALLMUSICRADIO);
		albumButtonGroup.add(albumAllmusicRadioButton);
		albumOptionsBox.add(albumAllmusicRadioButton);
		optionsRow.add(albumOptionsPanel);

		JPanel artistOptionsPanel = new JPanel();
		artistOptionsPanel.setBorder(BorderFactory.createEtchedBorder(
			EtchedBorder.LOWERED));

		Box artistOptionsBox = Box.createVerticalBox();
		artistOptionsPanel.add(artistOptionsBox);
		artistCheckBox = new JCheckBox("Download Artist Pictures");
		artistCheckBox.setSelected(true);
		artistCheckBox.addActionListener(this);
		artistCheckBox.setActionCommand(COMMAND_ARTISTCHECK);
		artistOptionsBox.add(artistCheckBox);

		ButtonGroup artistButtonGroup = new ButtonGroup();
		artistGoogleRadioButton = new JRadioButton("Download from Google");
		artistGoogleRadioButton.addActionListener(this);
		artistGoogleRadioButton.setActionCommand(COMMAND_ARTISTGOOGLERADIO);
		artistGoogleRadioButton.setSelected(true);
		artistButtonGroup.add(artistGoogleRadioButton);
		artistOptionsBox.add(artistGoogleRadioButton);
		artistAllmusicRadioButton = new JRadioButton("Download from AllMusic");
		artistAllmusicRadioButton.addActionListener(this);
		artistAllmusicRadioButton.setActionCommand(COMMAND_ARTISTALLMUSICRADIO);
		artistButtonGroup.add(artistAllmusicRadioButton);
		artistOptionsBox.add(artistAllmusicRadioButton);
		cropArtistCheckBox = new JCheckBox("Crop AllMusic Pictures");
		cropArtistCheckBox.setSelected(true);
		artistOptionsBox.add(cropArtistCheckBox);
		optionsRow.add(artistOptionsPanel);

		//Create the proxy options
		Box proxyRow = Box.createHorizontalBox();
		centerBox.add(proxyRow);
		proxyCheckBox = new JCheckBox("Proxy");
		proxyCheckBox.setActionCommand(COMMAND_PROXYCHECK);
		proxyCheckBox.addActionListener(this);
		proxyRow.add(proxyCheckBox);

		Box proxyHostRow = Box.createHorizontalBox();
		centerBox.add(proxyHostRow);
		proxyHostLabel = new JLabel("Proxy Host");
		proxyHostRow.add(proxyHostLabel);
		proxyHostField = new JTextField(20);
		proxyHostRow.add(proxyHostField);

		Box proxyPortRow = Box.createHorizontalBox();
		centerBox.add(proxyPortRow);
		proxyPortLabel = new JLabel("Proxy Port");
		proxyPortRow.add(proxyPortLabel);
		proxyPortField = new JTextField(20);
		proxyPortRow.add(proxyPortField);

		Box usernameRow = Box.createHorizontalBox();
		centerBox.add(usernameRow);
		usernameLabel = new JLabel("Username");
		usernameRow.add(usernameLabel);
		usernameField = new JTextField(20);
		usernameRow.add(usernameField);

		Box passwordRow = Box.createHorizontalBox();
		centerBox.add(passwordRow);
		passwordLabel = new JLabel("Password");
		passwordRow.add(passwordLabel);
		passwordField = new JPasswordField(20);
		passwordRow.add(passwordField);

		//Add the center panel to the main panel
		mainPanel.add(centerBox, BorderLayout.CENTER);

		//Construct the button panel
		JPanel buttonPanel = new JPanel();
		goButton = new JButton("Go");
		goButton.setActionCommand(COMMAND_GO);
		goButton.addActionListener(this);
		buttonPanel.add(goButton);

		//Add the button panel to the main panel
		mainPanel.add(buttonPanel, BorderLayout.SOUTH);
	}

	/**
	 * Load setttings and display the frame
	 */
	public void loadFrame()
		throws Exception
	{
		loadSettings();
		setArtistOptionsVisibility();
		frame.pack();
		frame.setVisible(true);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param e DOCUMENT ME!
	 */
	public void actionPerformed(ActionEvent e)
	{
		String command = e.getActionCommand();

		if (command.equals(COMMAND_GO))
		{
			//Check to make sure the mp3root exists
			File mp3root = new File(mp3RootTextField.getText());

			if (mp3root.exists() == false)
			{
				JOptionPane.showMessageDialog(null,
														mp3RootTextField.getText() +
														" does not exist!", "Error",
														JOptionPane.ERROR_MESSAGE);
			}
			else
			{
				try
				{
					//Make mp3 root choose frame invisible
					frame.setVisible(false);

					//If a proxy host was entered, set everything, else turn proxy stuff off
					Properties systemProps = System.getProperties();
					String proxyHost = proxyHostField.getText();
					String proxyPort = proxyPortField.getText();
					if (proxyHostField.getText().equals("") == false)
					{
						systemProps.setProperty("proxySet", "true");
						systemProps.setProperty("firewallSet", "true"); //MicroSoft VM

						systemProps.setProperty("proxyHost", proxyHost);
						systemProps.setProperty("https.proxyHost", proxyHost);
						systemProps.setProperty("firewallHost", proxyHost); //MicroSoft VM
						systemProps.setProperty("http.proxyHost", proxyHost); //MicroSoft VM

						systemProps.setProperty("proxyPort", proxyPort);
						systemProps.setProperty("https.proxyPort", proxyPort);
						systemProps.setProperty("firewallPort", proxyPort); //MicroSoft VM
						systemProps.setProperty("http.proxyPort", proxyPort); //MicroSoft VM

						String authentication = "Basic " +
							Base64.encodeBytes( (usernameField.getText() + ":" +
														passwordField.getPassword()).getBytes());
						systemProps.put("authentication", authentication);
					}
					else
					{
						systemProps.setProperty("proxySet", "false");
						systemProps.setProperty("firewallSet", "false"); //MicroSoft VM

						systemProps.setProperty("proxyHost", "");
						systemProps.setProperty("https.proxyHost", "");
						systemProps.setProperty("firewallHost", ""); //MicroSoft VM
						systemProps.setProperty("http.proxyHost", ""); //MicroSoft VM

						systemProps.setProperty("proxyPort", "");
						systemProps.setProperty("https.proxyPort", "");
						systemProps.setProperty("firewallPort", ""); //MicroSoft VM
						systemProps.setProperty("http.proxyPort", ""); //MicroSoft VM

						systemProps.put("authentication", "");
					}

					saveSettings();
				}
				catch (Exception ex)
				{
					System.out.println("Exception: " + ex);
				}
			}

			//Notify observers that the go button has been pushed
			setChanged();
			notifyObservers();
		}
		else if (command.equals(COMMAND_BROWSE))
		{
			//Browse for the root mp3 dir
			JFileChooser chooser = new JFileChooser();
			chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			chooser.setMultiSelectionEnabled(false);

			int returnVal = chooser.showOpenDialog(frame);

			if (returnVal == JFileChooser.APPROVE_OPTION)
			{
				mp3RootTextField.setText(chooser.getSelectedFile().getPath());
			}
		}
		else if (command.equals(COMMAND_PROXYCHECK))
		{
			if (proxyCheckBox.isSelected())
			{
				enableProxy(true);
				frame.repaint();
			}
			else
			{
				enableProxy(false);
				frame.repaint();
			}
		}
		else if (command.equals(COMMAND_ALBUMGOOGLERADIO))
		{
			setArtistOptionsVisibility();
		}
		else if (command.equals(COMMAND_ALBUMALLMUSICRADIO))
		{
			setArtistOptionsVisibility();
		}
		else if (command.equals(COMMAND_ARTISTGOOGLERADIO))
		{
			setArtistOptionsVisibility();
		}
		else if (command.equals(COMMAND_ARTISTALLMUSICRADIO))
		{
			setArtistOptionsVisibility();
		}
		else if (command.equals(COMMAND_ALBUMCHECK))
		{
			setArtistOptionsVisibility();
		}
		else if (command.equals(COMMAND_ARTISTCHECK))
		{
			setArtistOptionsVisibility();
		}
	}

	private void setArtistOptionsVisibility()
	{
		//To start out, make them all invisible
		albumGoogleRadioButton.setVisible(false);
		albumAllmusicRadioButton.setVisible(false);
		artistGoogleRadioButton.setVisible(false);
		artistAllmusicRadioButton.setVisible(false);
		cropArtistCheckBox.setVisible(false);

		if (albumCheckBox.isSelected())
		{
			albumGoogleRadioButton.setVisible(true);
			albumAllmusicRadioButton.setVisible(true);
		}

		if (artistCheckBox.isSelected())
		{
			artistGoogleRadioButton.setVisible(true);
			artistAllmusicRadioButton.setVisible(true);
		}

		if (artistAllmusicRadioButton.isSelected())
		{
			cropArtistCheckBox.setVisible(true);
		}

		frame.pack();
		frame.repaint();
	}

	/**
	 * Enable/Disable the proxy settings
	 */
	private void enableProxy(boolean flag)
	{
		proxyHostLabel.setEnabled(flag);
		proxyHostField.setEnabled(flag);
		proxyPortLabel.setEnabled(flag);
		proxyPortField.setEnabled(flag);
		usernameLabel.setEnabled(flag);
		usernameField.setEnabled(flag);
		passwordLabel.setEnabled(flag);
		passwordField.setEnabled(flag);
	}

	/**
	 * Save the users settings
	 */
	private void saveSettings()
		throws Exception
	{
		Properties props = new Properties();

		if (albumCheckBox.isSelected())
		{
			props.setProperty("albumCheckBox", "true");
		}
		else
		{
			props.setProperty("albumCheckBox", "false");
		}

		if (artistCheckBox.isSelected())
		{
			props.setProperty("artistCheckBox", "true");
		}
		else
		{
			props.setProperty("artistCheckBox", "false");
		}

		if (cropArtistCheckBox.isSelected())
		{
			props.setProperty("cropArtistCheckBox", "true");
		}
		else
		{
			props.setProperty("cropArtistCheckBox", "false");
		}

		if (albumGoogleRadioButton.isSelected())
		{
			props.setProperty("albumGoogleRadioButton", "true");
		}
		else
		{
			props.setProperty("albumGoogleRadioButton", "false");
		}

		if (albumAllmusicRadioButton.isSelected())
		{
			props.setProperty("albumAllmusicRadioButton", "true");
		}
		else
		{
			props.setProperty("albumAllmusicRadioButton", "false");
		}

		if (artistGoogleRadioButton.isSelected())
		{
			props.setProperty("artistGoogleRadioButton", "true");
		}
		else
		{
			props.setProperty("artistGoogleRadioButton", "false");
		}

		if (artistAllmusicRadioButton.isSelected())
		{
			props.setProperty("artistAllmusicRadioButton", "true");
		}
		else
		{
			props.setProperty("artistAllmusicRadioButton", "false");
		}

		props.setProperty("mp3RootTextField", mp3RootTextField.getText());

		if (proxyCheckBox.isSelected())
		{
			props.setProperty("proxyCheckBox", "true");
		}
		else
		{
			props.setProperty("proxyCheckBox", "false");
		}

		props.setProperty("proxyHostField", proxyHostField.getText());
		props.setProperty("proxyPortField", proxyPortField.getText());
		props.setProperty("usernameField", usernameField.getText());
		props.setProperty("passwordField", new String(passwordField.getPassword()));

		FileOutputStream fos = new FileOutputStream("settings.ini");
		props.store(fos, "User Settings");
	}

	/**
	 * Load the users settings
	 */
	private void loadSettings()
		throws Exception
	{
		Properties props = new Properties();
		FileInputStream fis = null;

		try
		{
			fis = new FileInputStream("settings.ini");
		}
		catch (FileNotFoundException ex)
		{
			//Its ok if the settings file doesnt exist
		}

		if (fis != null)
		{
			props.load(fis);
			mp3RootTextField.setText( (String) props.get("mp3RootTextField"));

			if ( ( (String) props.get("proxyCheckBox")).equals("true"))
			{
				proxyCheckBox.setSelected(true);
				enableProxy(true);
			}
			else
			{
				proxyCheckBox.setSelected(false);
				enableProxy(false);
			}

			if (props.get("albumCheckBox") != null &&
				 ( (String) props.get("albumCheckBox")).equals("true"))
			{
				albumCheckBox.setSelected(true);
			}
			else
			{
				albumCheckBox.setSelected(false);
			}

			if (props.get("artistCheckBox") != null &&
				 ( (String) props.get("artistCheckBox")).equals("true"))
			{
				artistCheckBox.setSelected(true);
			}
			else
			{
				artistCheckBox.setSelected(false);
			}

			if (props.get("cropArtistCheckBox") != null &&
				 ( (String) props.get("cropArtistCheckBox")).equals("true"))
			{
				cropArtistCheckBox.setSelected(true);
			}
			else
			{
				cropArtistCheckBox.setSelected(false);
			}

			if (props.get("artistGoogleRadioButton") != null &&
				 ( (String) props.get("artistGoogleRadioButton")).equals("true"))
			{
				artistGoogleRadioButton.setSelected(true);
			}
			else
			{
				artistGoogleRadioButton.setSelected(false);
			}

			if (props.get("artistAllmusicRadioButton") != null &&
				 ( (String) props.get("artistAllmusicRadioButton")).equals("true"))
			{
				artistAllmusicRadioButton.setSelected(true);
			}
			else
			{
				artistAllmusicRadioButton.setSelected(false);
			}

			proxyHostField.setText( (String) props.get("proxyHostField"));
			proxyPortField.setText( (String) props.get("proxyPortField"));
			usernameField.setText( (String) props.get("usernameField"));
			passwordField.setText( (String) props.get("passwordField"));
		}
	}

	/**
	 * Returns the MP3 root
	 */
	public String getMp3Root()
	{
		return mp3RootTextField.getText();
	}

	/**
	 * Check if the option search for artist pics is selected
	 */
	public boolean isArtistSelected()
	{
		return artistCheckBox.isSelected();
	}

	/**
	 * Check if the option search for album pics is selected
	 */
	public boolean isAlbumSelected()
	{
		return albumCheckBox.isSelected();
	}

	/**
	 * Check if the option to crop the artist pics is selected
	 */
	public boolean isCropArtistSelected()
	{
		return cropArtistCheckBox.isSelected();
	}

	/**
	 * Check if the option to search google for album pics
	 */
	public boolean isGoogeAlbumSearch()
	{
		return albumGoogleRadioButton.isSelected();
	}

	/**
	 * Check if the option to search allmusic for album pics
	 */
	public boolean isAllMusicAlbumSearch()
	{
		return albumAllmusicRadioButton.isSelected();
	}

	/**
	 * Check if the option to search google for artists pics
	 */
	public boolean isGoogeArtistSearch()
	{
		return artistGoogleRadioButton.isSelected();
	}

	/**
	 * Check if the option to search allmusic for artists pics
	 */
	public boolean isAllMusicArtistSearch()
	{
		return artistAllmusicRadioButton.isSelected();
	}

	/**
	 * Add an action lister to the go button
	 */
	public void addGoButtonObserver(Observer observer)
	{
		addObserver(observer);
	}
}