package dks.src.borderEditor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;

import dks.src.utils.editor.CAbstractEditor;

/**
 * This class implement an editor for the l2fprod PropertySheetTable to modify the properties of the border <br> date : 3 sept. 07
 * @author   DarK Sidious
 */
public class JdksBorderEditorPane extends CAbstractEditor {

	private static final long serialVersionUID = 893718135620280152L;

	/**
	 * The name of the color property
	 */
	public static final String PROPERTY_COLOR_NAME = "propertyColor";

	/**
	 * The name of the width property
	 */
	public static final String PROPERTY_WIDTH_NAME = "propertyWidth";

	/**
	 * The name of the visible property
	 */
	public static final String PROPERTY_VISIBLE_NAME = "propertyVisible";

	protected CBorder _borderEditor;
	protected transient PropertyChange _propertyChangeListener;

	/**
	 * @param border the border to use
	 */
	public JdksBorderEditorPane(CBorder border) {
		_borderEditor = border;
		_propertyChangeListener = new PropertyChange();
		init();
	}

	protected void init() {
		addPropertySheetChangeListener(_propertyChangeListener);
		reloadModel();
	}

	/**
	 * @param border the border to use
	 */
	public void setBorderEditor(CBorder border) {
		_borderEditor = border;
	}

	/**
	 * @return the border to use
	 */
	public CBorder getBorderEditor() {
		return _borderEditor;
	}

	/**
	 * Reload the PropertySheetTable with the properties of the border
	 */
	public void reloadModel() {
		setProperties(new DefaultProperty[0]);
		final Property visibleProperty = createProperty("Visible", "Visibilit de la bordure du texte", Boolean.class, _borderEditor.isVisible(), PROPERTY_VISIBLE_NAME);
		addProperty(visibleProperty);
		final Property colorProperty = createProperty("Couleur", "Couleur de la bordure du texte", Color.class, _borderEditor.getColor(), PROPERTY_COLOR_NAME);
		addProperty(colorProperty);
		final Property widthProperty = createProperty("Largeur", "Largeur de la bordure du texte", Integer.class, _borderEditor.getWidth(), PROPERTY_WIDTH_NAME);
		addProperty(widthProperty);
	}

	/**
	 * Change the border width the modified property
	 * @param property the property which has changed
	 */
	protected void change(Property property) {
		final String name = property.getName();
		if (PROPERTY_COLOR_NAME.equals(name)) {
			_borderEditor.setColor((Color) property.getValue());
		} else if (PROPERTY_WIDTH_NAME.equals(name)) {
			_borderEditor.setWidth((Integer) property.getValue());
		} else if (PROPERTY_VISIBLE_NAME.equals(name)) {
			_borderEditor.setVisible((Boolean) property.getValue());
		}
		for (PropertyChangeListener listener : _listeners) {
			if (!(listener instanceof PropertyChange)) {
				listener.propertyChange(new PropertyChangeEvent(property, property.getName(), property.getValue(), property.getValue()));
			}
		}
	}

	protected class PropertyChange implements PropertyChangeListener {
		public void propertyChange(PropertyChangeEvent arg0) {
			if (arg0.getSource() instanceof Property) {
				change((Property) arg0.getSource());
			}
		}
	}

	public String toString() {
		return "dks.src.borderEditor.JdksBorderEditorPane[border=" + _borderEditor + "]";
	}

	protected Object readResolve() throws ObjectStreamException {
		_propertyChangeListener = new PropertyChange();
		return this;
	}
}
