package dks.src.test.gradientEditor;

import junit.framework.TestCase;

import org.jdom.Element;
import org.jdom.JDOMException;

import dks.src.gradientEditor.CGradient;

public class TestCGradient extends TestCase {

	private static final int ORIG_ANGLE = 1;
	private static final int TEST_ANGLE = 2;
	
	private static final boolean ORIG_RADIAL = true;
	private static final boolean TEST_RADIAL = false;

	public void testCGradientIntBoolean() {
		CGradient gradient = new CGradient(ORIG_ANGLE, ORIG_RADIAL);
		assertNotNull("Le constructeur n'a pas construit l'objet", gradient);
		assertEquals("Le constructeur n'a pas initialiser l'angle", gradient.getAngle(), ORIG_ANGLE);
		assertEquals("Le constructeur n'a pas initialiser le radial", gradient.isRadial(), ORIG_RADIAL);
	}

	public void testSetAngle() {
		CGradient gradient = new CGradient(ORIG_ANGLE, ORIG_RADIAL);
		gradient.setAngle(TEST_ANGLE);
		assertEquals("La modification de l'angle n'est pas effective", gradient.getAngle(), TEST_ANGLE);
	}

	public void testSetRadial() {
		CGradient gradient = new CGradient(ORIG_ANGLE, ORIG_RADIAL);
		gradient.setRadial(TEST_RADIAL);
		assertEquals("La modification du radial n'est pas effective", gradient.isRadial(), TEST_RADIAL);
	}

	public void testXMLload() {
		CGradient gradient = new CGradient(ORIG_ANGLE, ORIG_RADIAL);
		Element root = new Element("parent");
		gradient.XMLsave(root);
		CGradient test = new CGradient(TEST_ANGLE, TEST_RADIAL);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas modifi le radial", test.isRadial(), ORIG_RADIAL);
		assertEquals("Le chargement par XML n'a pas modifi l'angle", test.getAngle(), ORIG_ANGLE);
	}

}
