package dks.src.test.texture;

import java.awt.Color;
import java.awt.image.BufferedImage;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;

import org.jdom.Element;
import org.jdom.JDOMException;

import dks.src.gradientEditor.CGradient;
import dks.src.textureEditor.CLayer;
import dks.src.textureEditor.ETypeLayer;

/**
 * @author   DKS
 */
public class TestCLayer extends TestCase {
	
	private static final Color ORIG_COLOR = new Color(1, 2, 3, 4);
	private static final Color TEST_COLOR = new Color(5, 6, 7, 8);
	
	private static final BufferedImage ORIG_IMAGE = new BufferedImage(100, 200, BufferedImage.TYPE_4BYTE_ABGR);
	private static final BufferedImage TEST_IMAGE = new BufferedImage(200, 300, BufferedImage.TYPE_4BYTE_ABGR);
	
	private static final ETypeLayer ORIG_TYPE_LAYER = ETypeLayer.ColoredLayer;
	private static final ETypeLayer TEST_TYPE_LAYER = ETypeLayer.GradientLayer;
	
	private static final CGradient ORIG_GRADIENT = new CGradient(10, true);
	private static final CGradient TEST_GRADIENT = new CGradient(20, false);
	
	private static final String TEST_IMAGE_FILENAME = "test";
	
	public void testCLayerColor() {
		CLayer layer = new CLayer(ORIG_COLOR);
		assertNotNull("Le constructeur n'a pas construit l'objet", layer);
		assertEquals("Le constructeur n'a pas initialis la couleur", layer.getColor(), ORIG_COLOR);
	}

	public void testCLayerBufferedImage() {
		CLayer layer = new CLayer(ORIG_IMAGE);
		assertNotNull("Le constructeur n'a pas construit l'objet", layer);
		assertEquals("Le constructeur n'a pas initialis l'image", layer.getImage(), ORIG_IMAGE);
	}

	public void testCLayerCGradient() {
		CLayer layer = new CLayer(ORIG_GRADIENT);
		assertNotNull("Le constructeur n'a pas construit l'objet", layer);
		assertEquals("Le constructeur n'a pas initialis le dgrad", layer.getGradient(), ORIG_GRADIENT);
	}

	public void testAddChangeListener() {
		CLayer layer = new CLayer(ORIG_COLOR);
		layer.addChangeListener(new Change());
		layer.setColor(ORIG_COLOR);
		layer.setImage(ORIG_IMAGE);
		layer.setGradient(ORIG_GRADIENT);
		layer.setType(ORIG_TYPE_LAYER);
		_changed = false;
		layer.setColor(ORIG_COLOR);
		assertFalse("L'vnement change a t dclench alors que la mme couleur a t attribue", _changed);
		layer.setColor(TEST_COLOR);
		assertTrue("L'vnement change n'a pas t dclench alors que la couleur a t modifie", _changed);
		_changed = false;
		layer.setImage(ORIG_IMAGE);
		assertFalse("L'vnement change a t dclench alors que la mme image a t attribue", _changed);
		layer.setImage(TEST_IMAGE);
		assertTrue("L'vnement change n'a pas t dclench alors que l'image a t modifie", _changed);
		_changed = false;
		layer.setGradient(ORIG_GRADIENT);
		assertFalse("L'vnement change a t dclench alors que le mme dgrad a t attribu", _changed);
		layer.setGradient(TEST_GRADIENT);
		assertTrue("L'vnement change n'a pas t dclench alors que le dgrad a t modifi", _changed);
		_changed = false;
		layer.setType(ORIG_TYPE_LAYER);
		assertFalse("L'vnement change a t dclench alors que le mme type de layer a t attribu", _changed);
		layer.setType(TEST_TYPE_LAYER);
		assertTrue("L'vnement change n'a pas t dclench alors que le type de layer a t modifi", _changed);
	}

	public void testSetColor() {
		CLayer layer = new CLayer(ORIG_COLOR);
		layer.setColor(TEST_COLOR);
		assertEquals("La modification de la couleur n'est pas effective", layer.getColor(), TEST_COLOR);
	}

	public void testSetGradient() {
		CLayer layer = new CLayer(ORIG_GRADIENT);
		layer.setGradient(TEST_GRADIENT);
		assertEquals("La modification du dgrad n'est pas effective", layer.getGradient(), TEST_GRADIENT);
	}

	public void testSetImage() {
		CLayer layer = new CLayer(ORIG_IMAGE);
		layer.setImage(TEST_IMAGE);
		assertEquals("La modification de l'image n'est pas effective", layer.getImage(), TEST_IMAGE);
	}

	public void testSetType() {
		CLayer layer = new CLayer(ORIG_COLOR);
		layer.setType(TEST_TYPE_LAYER);
		assertEquals("La modification du type de layer n'est pas effective", layer.getType(), TEST_TYPE_LAYER);
	}

	public void testXMLload() {
		CLayer layer = new CLayer(ORIG_COLOR);
		Element root = new Element("parent");
		layer.XMLsave(root);
		CLayer test = new CLayer(TEST_COLOR);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas initialis la couleur", test.getColor(), ORIG_COLOR);
		layer = new CLayer(ORIG_GRADIENT);
		root = new Element("parent");
		layer.XMLsave(root);
		test = new CLayer(TEST_COLOR);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas initialis le dgrad", test.getGradient(), ORIG_GRADIENT);
	}

	public void testSetImageFileName() {
		CLayer layer = new CLayer(ORIG_COLOR);
		layer.setImageFileName(TEST_IMAGE_FILENAME);
		assertEquals("La modification du nom de fichier n'est pas effective", layer.getImageFileName(), TEST_IMAGE_FILENAME);
	}

	private boolean _changed = false;
	
	private class Change implements ChangeListener {
		public void stateChanged(ChangeEvent arg0) {
			_changed = true;
		}
	}
}
