/**
 * @author DarK Sidious
 * @version 1.0.0
 */
package dks.src.utils.listener;

import java.util.LinkedList;
import java.util.List;


/**
 * This class is an adaptor for the listeners : facilitate the development of a class which implements a listener
 * <br>
 * date : 2 dc. 07
 * @author DarK Sidious
 */
public class CListenerDelegate<T> implements Listenable<T> {
	protected transient List<T> _listeners;

	/**
	 * @see dks.src.utils.listener.Listenable#addChangeListener(javax.swing.event.ChangeListener)
	 * @param listener
	 */
	public void addListener(T listener) {
		if (_listeners == null) {
			_listeners = new LinkedList<T>();
		}
		_listeners.add(listener);
	}

	/**
	 * @see dks.src.utils.listener.Listenable#removeChangeListener(javax.swing.event.ChangeListener)
	 * @param listener
	 */
	public void removeListener(T listener) {
		if (_listeners != null) {
			_listeners.remove(listener);
			if (_listeners.size() <= 0) {
				_listeners = null;
			}
		}
	}
}
