package dks.src.warpEditor;

import java.io.ObjectStreamException;
import java.io.Serializable;

import javax.swing.event.ChangeListener;

import org.jdom.Element;

import dks.src.utils.XML.XMLWritable;
import dks.src.utils.listener.CChangeListenerDelegate;
import dks.src.utils.listener.Changeable;

/**
 * This class implements a point which can be saved in a XML format <br> date : 5 sept. 07
 * @author   DarK Sidious
 */
public class CPoint implements XMLWritable, Serializable, Changeable  {

	private static final long serialVersionUID = -6316913408179402407L;

	protected static final String XML_TRANSFORMATION_X_PROPERTY = "transformationX";
	protected static final String XML_TRANSFORMATION_Y_PROPERTY = "transformationY";

	protected int _transformationX = 0;
	protected int _transformationY = 0;

	protected transient CChangeListenerDelegate _changeListenerDelegate;

	public CPoint() {
		_changeListenerDelegate = new CChangeListenerDelegate();
	}

	public CPoint(int transformationX, int transformationY) {
		this();
		_transformationX = transformationX;
		_transformationY = transformationY;
	}

	/**
	 * @return the transformation in the X Axis
	 */
	public int getTransformationX() {
		return _transformationX;
	}

	/**
	 * @param transformationX the transformation in the X axis
	 */
	public void setTransformationX(int transformationX) {
		if (_transformationX != transformationX) {
			_transformationX = transformationX;
			_changeListenerDelegate.notifyChanged();
		}
	}

	/**
	 * @return the transformation in the Y axis
	 */
	public int getTransformationY() {
		return _transformationY;
	}

	/**
	 * @param transformationY the transformation in the Y axis
	 */
	public void setTransformationY(int transformationY) {
		if (_transformationY != transformationY) {
			_transformationY = transformationY;
			_changeListenerDelegate.notifyChanged();
		}
	}

	/**
	 * @see dks.src.utils.XML.XMLWritable#XMLload(org.jdom.Element)
	 * @param root the XML DOM Element used to load the point properties
	 */
	public void XMLload(Element root) {
		_transformationX = Integer.parseInt(root.getAttributeValue(XML_TRANSFORMATION_X_PROPERTY));
		_transformationY = Integer.parseInt(root.getAttributeValue(XML_TRANSFORMATION_Y_PROPERTY));
	}

	/**
	 * @see dks.src.utils.XML.XMLWritable#XMLsave(org.jdom.Element)
	 * @param root the XML DOM Element used to save the point properties
	 */
	public void XMLsave(Element root) {
		root.setAttribute(XML_TRANSFORMATION_X_PROPERTY, Integer.valueOf(_transformationX).toString());
		root.setAttribute(XML_TRANSFORMATION_Y_PROPERTY, Integer.valueOf(_transformationY).toString());
	}

	/**
	 * @param listener The listener to add which is invoked when the position of the point change
	 * @see dks.src.utils.listener.CListenerDelegate#addListener(java.lang.Object)
	 */
	public void addChangeListener(ChangeListener listener) {
		_changeListenerDelegate.addListener(listener);
	}

	/**
	 * @param listener The listener to remove
	 * @see dks.src.utils.listener.CListenerDelegate#removeListener(java.lang.Object)
	 */
	public void removeChangeListener(ChangeListener listener) {
		_changeListenerDelegate.removeListener(listener);
	}

	/**
	 * @see java.lang.Object#hashCode()
	 * @return the hashcode of the object
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + _transformationX;
		result = PRIME * result + _transformationY;
		return result;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 * @param obj the object to compare
	 * @return the equality of the object
	 */
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof CPoint)) {
			return false;
		}
		if (!getClass().equals(obj.getClass())) {
			return false;
		}
		final CPoint other = (CPoint) obj;
		if (_transformationX != other._transformationX) {
			return false;
		}
		if (_transformationY != other._transformationY) {
			return false;
		}
		return true;
	}

	public String toString() {
		return "dks.src.warpEditor.CPoint[transformationX=" + _transformationX + ",transformationY=" + _transformationY + "]";
	}

	protected Object readResolve() throws ObjectStreamException {
		_changeListenerDelegate = new CChangeListenerDelegate();
		return this;
	}
}
