/**
 * @author DarK Sidious
 * @version 1.0.0
 */
package dks.src.wordart;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;

import dks.src.utils.editor.CAbstractEditor;

/**
 * This class implements a TableSheetProperty editor for editing the wordart properties <br> date : 13 sept. 07
 * @author   DarK Sidious
 */
public class JdksWordArtEditorPane extends CAbstractEditor {

	private static final long serialVersionUID = 5503994465489982678L;

	public static final String TEXT_PROPERTY_NAME = "TextProperty";
	public static final String FONT_PROPERTY_NAME = "FontProperty";
	public static final String BACKGROUND_PROPERTY_NAME = "BackgroundProperty";
	public static final String BACKGROUND_COLOR_PROPERTY_NAME = "BackgroundColorProperty";
	public static final String BACKGROUND_OPACITY_PROPERTY_NAME = "BackgroundOpacityProperty";
	public static final String DIMENSION_PROPERTY_NAME = "DimensionProperty";
	public static final String DIMENSION_WIDTH_PROPERTY_NAME = "DimensionWidthProperty";
	public static final String DIMENSION_HEIGHT_PROPERTY_NAME = "DimensionHeightProperty";
	public static final String DIMENSION_STRETCH_PROPERTY_NAME = "DimensionStretchProperty";
	public static final String TOTALSIZE_PROPERTY_NAME = "TotalSizeProperty";
	public static final String TOTALSIZE_WIDTH_PROPERTY_NAME = "TotalSizeWidthProperty";
	public static final String TOTALSIZE_HEIGHT_PROPERTY_NAME = "TotalSizeHeightProperty";
	public static final String AUTOSIZEFONT_PROPERTY_NAME = "AutoSizeFontProperty";

	public static final String TEXT_PROPERTY_TITLE = "Texte";
	public static final String TEXT_PROPERTY_DESCRIPTION = "Texte du wordart";
	public static final String FONT_PROPERTY_TITLE = "Police";
	public static final String FONT_PROPERTY_DESCRIPTION = "Police du wordart";
	public static final String BACKGROUND_PROPERTY_TITLE = "Fond";
	public static final String BACKGROUND_PROPERTY_DESCRIPTION = "Fond du wordArt";
	public static final String BACKGROUND_COLOR_PROPERTY_TITLE = "Couleur";
	public static final String BACKGROUND_COLOR_PROPERTY_DESCRIPTION = "Couleur de fond du wordArt";
	public static final String BACKGROUND_OPACITY_PROPERTY_TITLE = "Opacit";
	public static final String BACKGROUND_OPACITY_PROPERTY_DESCRIPTION = "Opacit du fond du wordArt";
	public static final String DIMENSION_PROPERTY_TITLE = "Dimension";
	public static final String DIMENSION_PROPERTY_DESCRIPTION = "Dimension du wordart";
	public static final String DIMENSION_WIDTH_PROPERTY_TITLE = "Largeur";
	public static final String DIMENSION_WIDTH_PROPERTY_DESCRIPTION = "Largeur du wordart";
	public static final String DIMENSION_HEIGHT_PROPERTY_TITLE = "Hauteur";
	public static final String DIMENSION_HEIGHT_PROPERTY_DESCRIPTION = "Hauteur du wordart";
	public static final String DIMENSION_STRETCH_PROPERTY_TITLE = "Etirement";
	public static final String DIMENSION_STRETCH_PROPERTY_DESCRIPTION = "Etirement du wordart selon la dimension de celui-ci (attention, perte de qualit !)";
	public static final String TOTALSIZE_PROPERTY_TITLE = "Taille de l'image";
	public static final String TOTALSIZE_PROPERTY_DESCRIPTION = "Taille de l'image finale";
	public static final String TOTALSIZE_WIDTH_PROPERTY_TITLE = "Largeur de la taille de l'image finale";
	public static final String TOTALSIZE_WIDTH_PROPERTY_DESCRIPTION = "Largeur de la taille de l'image finale";
	public static final String TOTALSIZE_HEIGHT_PROPERTY_TITLE = "Hauteur";
	public static final String TOTALSIZE_HEIGHT_PROPERTY_DESCRIPTION = "Hauteur de la taille de l'image finale";
	public static final String AUTOSIZEFONT_PROPERTY_TITLE = "Taille de police automatique";
	public static final String AUTOSIZEFONT_PROPERTY_DESCRIPTION = "La taille de la police est redimensionne automatiquement selon la dimension du wordart (bonne alternative  l'tirement du wordart : garantit une qualit optimale selon la taille choisie)";

	protected CWordArt _wordArtEditor;
	protected transient PropertyChange _propertyChangeListener;

	public JdksWordArtEditorPane(CWordArt wordArt) {
		_wordArtEditor = wordArt;
		_propertyChangeListener = new PropertyChange();
		init();
	}

	protected final void init() {
		addPropertySheetChangeListener(_propertyChangeListener);
		reloadModel();
	}

	/**
	 * @param wordArtEditor
	 *            the shadow to use
	 */
	public void setEditor(CWordArt wordArtEditor) {
		_wordArtEditor = wordArtEditor;
	}

	/**
	 * Reload the properties of the table with the properties of the shadow
	 */
	public void reloadModel() {
		setProperties(new DefaultProperty[0]);

		final DefaultProperty sizeProperty = (DefaultProperty) createProperty(TEXT_PROPERTY_TITLE, TEXT_PROPERTY_DESCRIPTION, String.class, _wordArtEditor.getText(), TEXT_PROPERTY_NAME);
		addProperty(sizeProperty);

		final DefaultProperty fontProperty = (DefaultProperty) createProperty(FONT_PROPERTY_TITLE, FONT_PROPERTY_DESCRIPTION, Font.class, _wordArtEditor.getFont(), FONT_PROPERTY_NAME);
		addProperty(fontProperty);

		final DefaultProperty autoSizeFontProperty = (DefaultProperty) createProperty(AUTOSIZEFONT_PROPERTY_TITLE, AUTOSIZEFONT_PROPERTY_DESCRIPTION, Boolean.class, _wordArtEditor.isAutoSizeFont(), AUTOSIZEFONT_PROPERTY_NAME);
		addProperty(autoSizeFontProperty);

		final DefaultProperty backgroundProperty = (DefaultProperty) createProperty(BACKGROUND_PROPERTY_TITLE, BACKGROUND_PROPERTY_DESCRIPTION, null, null, BACKGROUND_PROPERTY_NAME);
		final DefaultProperty backgroundColorProperty = (DefaultProperty) createProperty(BACKGROUND_COLOR_PROPERTY_TITLE, BACKGROUND_COLOR_PROPERTY_DESCRIPTION, Color.class, _wordArtEditor.getBackgroundColor(), BACKGROUND_COLOR_PROPERTY_NAME);
		backgroundProperty.addSubProperty(backgroundColorProperty);
		final DefaultProperty backgroundOpacityProperty = (DefaultProperty) createProperty(BACKGROUND_OPACITY_PROPERTY_TITLE, BACKGROUND_OPACITY_PROPERTY_DESCRIPTION, Integer.class, _wordArtEditor.getBackgroundColor().getAlpha(), BACKGROUND_OPACITY_PROPERTY_NAME);
		backgroundProperty.addSubProperty(backgroundOpacityProperty);
		addProperty(backgroundProperty);

		final DefaultProperty dimensionProperty = (DefaultProperty) createProperty(DIMENSION_PROPERTY_TITLE, DIMENSION_PROPERTY_DESCRIPTION, null, null, DIMENSION_PROPERTY_NAME);
		final DefaultProperty dimensionWidthProperty = (DefaultProperty) createProperty(DIMENSION_WIDTH_PROPERTY_TITLE, DIMENSION_WIDTH_PROPERTY_DESCRIPTION, Integer.class, (int) _wordArtEditor.getDimension().getWidth(), DIMENSION_WIDTH_PROPERTY_NAME);
		dimensionProperty.addSubProperty(dimensionWidthProperty);
		final DefaultProperty dimensionHeightProperty = (DefaultProperty) createProperty(DIMENSION_HEIGHT_PROPERTY_TITLE, DIMENSION_HEIGHT_PROPERTY_DESCRIPTION, Integer.class, (int) _wordArtEditor.getDimension().getHeight(), DIMENSION_HEIGHT_PROPERTY_NAME);
		dimensionProperty.addSubProperty(dimensionHeightProperty);
		final DefaultProperty dimensionStretchProperty = (DefaultProperty) createProperty(DIMENSION_STRETCH_PROPERTY_TITLE, DIMENSION_STRETCH_PROPERTY_DESCRIPTION, Boolean.class, _wordArtEditor.isStretch(), DIMENSION_STRETCH_PROPERTY_NAME);
		dimensionProperty.addSubProperty(dimensionStretchProperty);
		addProperty(dimensionProperty);

		final DefaultProperty totalSizeProperty = (DefaultProperty) createProperty(TOTALSIZE_PROPERTY_TITLE, TOTALSIZE_PROPERTY_DESCRIPTION, null, null, TOTALSIZE_PROPERTY_NAME);
		final DefaultProperty totalSizeWidthProperty = (DefaultProperty) createProperty(TOTALSIZE_WIDTH_PROPERTY_TITLE, TOTALSIZE_WIDTH_PROPERTY_DESCRIPTION, Integer.class, (int) _wordArtEditor.getTotalSize().getWidth(), TOTALSIZE_WIDTH_PROPERTY_NAME);
		totalSizeProperty.addSubProperty(totalSizeWidthProperty);
		final DefaultProperty totalSizeHeightProperty = (DefaultProperty) createProperty(TOTALSIZE_HEIGHT_PROPERTY_TITLE, TOTALSIZE_HEIGHT_PROPERTY_DESCRIPTION, Integer.class, (int) _wordArtEditor.getTotalSize().getHeight(), TOTALSIZE_HEIGHT_PROPERTY_NAME);
		totalSizeProperty.addSubProperty(totalSizeHeightProperty);
		addProperty(totalSizeProperty);
	}

	protected void change(Property property) {
		final String name = property.getName();
		if (TEXT_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.setText((String) property.getValue());
		} else if (FONT_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.setFont((Font) property.getValue());
		} else if (BACKGROUND_COLOR_PROPERTY_NAME.equals(name)) {
			Color color = (Color) property.getValue();
			_wordArtEditor.setBackgroundColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), _wordArtEditor.getBackgroundColor().getAlpha()));
		} else if (BACKGROUND_OPACITY_PROPERTY_NAME.equals(name)) {
			final Integer value = (Integer) property.getValue();
			if (value >= 0 || value <= 255) {
				_wordArtEditor.setBackgroundColor(new Color(_wordArtEditor.getBackgroundColor().getRed(), _wordArtEditor.getBackgroundColor().getGreen(), _wordArtEditor.getBackgroundColor().getBlue(), (Integer) property.getValue()));
			}
		} else if (DIMENSION_WIDTH_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.getDimension().setSize((Integer) property.getValue(), _wordArtEditor.getDimension().getHeight());
		} else if (DIMENSION_HEIGHT_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.getDimension().setSize(_wordArtEditor.getDimension().getWidth(), (Integer) property.getValue());
		} else if (DIMENSION_STRETCH_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.setStretch((Boolean) property.getValue());
		} else if (AUTOSIZEFONT_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.setAutoSizeFont((Boolean) property.getValue());
		} else if (TOTALSIZE_WIDTH_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.getTotalSize().setSize((Integer) property.getValue(), _wordArtEditor.getTotalSize().getHeight());
		} else if (TOTALSIZE_HEIGHT_PROPERTY_NAME.equals(name)) {
			_wordArtEditor.getTotalSize().setSize(_wordArtEditor.getTotalSize().getWidth(), (Integer) property.getValue());
		}
		for (final PropertyChangeListener listener : _listeners) {
			if (!(listener instanceof PropertyChange)) {
				listener.propertyChange(new PropertyChangeEvent(property, property.getName(), property.getValue(), property.getValue()));
			}
		}
	}

	protected class PropertyChange implements PropertyChangeListener {
		public void propertyChange(PropertyChangeEvent arg0) {
			if (arg0.getSource() instanceof Property) {
				change((Property) arg0.getSource());
			}
		}
	}

	public String toString() {
		return "dks.src.wordArt.JdksWordArtEditorPane[wordart=" + _wordArtEditor + "]";
	}

	protected Object readResolve() throws ObjectStreamException {
		_propertyChangeListener = new PropertyChange();
		return this;
	}
}
