package typecontrol;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CTypeControl {

	private static final long serialVersionUID = 8223166023497168675L;

	public final Dimension BTN_SIZE = new Dimension(18, 18);
	public static final String BTN_INFO_NAME = "btnInfo";
	
	public static final Color FOCUS_COLOR = new Color(240, 255, 255);
	
	protected Color _focusBackground;
	protected String _info; 
	protected String _label;
	protected Integer _alignment;
	protected Integer _width;
	protected List<ChangeListener> _changeListener;
	
	protected JLabel _labLabel;
	protected JButton _btnInfo;
	
	public Color getFocusBackground() {
		return _focusBackground;
	}
	
	public void setFocusBackground(Color focusBackground) {
		_focusBackground = focusBackground;
	}
	
	public String getInfo() {
		return _info;
	}
	
	public void setInfo(String info) {
		_info = info;
	}
	
	public String getLabel() {
		return _label;
	}
	
	public void setLabel(String label) {
		_label = label;
	}
	
	public void setLabelAlignment(int alignment) {
		_alignment = alignment;
		if (isLabelled()) {
			getLabLabel().setHorizontalAlignment(alignment);
		}
	}
	
	public void setLabelWidth(int width) {
		_width = width;
		if (isLabelled()) {
			getLabLabel().setPreferredSize(new Dimension(width, 20));
		}
	}
	
	public boolean isLabelled() {
		return _label != null && !_label.equals("");
	}
	
	protected void btnInfo_Click() {
		JOptionPane.showMessageDialog(null, (String) _info, "Informations", JOptionPane.OK_OPTION + JOptionPane.INFORMATION_MESSAGE);
	}

	public JLabel getLabLabel() {
		if (_labLabel == null) {
			_labLabel = new JLabel(_label);
		}
		return _labLabel;
	}

	public JButton getBtnInfo() {
		if (_btnInfo == null) {
			_btnInfo = new JButton();
			_btnInfo.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(getClass().getClassLoader().getResource("ressources/info.png"))));
			_btnInfo.setPreferredSize(BTN_SIZE);
			_btnInfo.setName(BTN_INFO_NAME);
			_btnInfo.addActionListener(new Action());
		}
		return _btnInfo;
	}
	
	public void addChangeListener(ChangeListener changeListener) {
		if (_changeListener == null) {
			_changeListener = new LinkedList<ChangeListener>();
		}
		_changeListener.add(changeListener);
	}
	
	public void removeChangeListener(ChangeListener changeListener) {
		if (_changeListener != null) {
			_changeListener.remove(changeListener);
			if (_changeListener.size() == 0) {
				_changeListener = null;
			}
		}
	}
	
	public void raiseChangeListener(IdksTypeControl source) {
		if (_changeListener != null) {
			for (ChangeListener change : _changeListener) {
				if (change != null) {
					change.stateChanged(new ChangeEvent(source));
				}
			}
		}
	}
	
	private class Action implements ActionListener {
		public void actionPerformed(ActionEvent arg0) {
			String name = ((JComponent) arg0.getSource()).getName();
			if (name.equals(BTN_INFO_NAME)) {
				btnInfo_Click();
			}
		}
	}
}
