package typecontrol.test;

import java.awt.Color;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import typecontrol.controls.JdksCheckBox;
import typecontrol.controls.JdksColorChooser;
import typecontrol.controls.JdksComboBox;
import typecontrol.controls.JdksFileChooser;
import typecontrol.controls.JdksTextField;
import typecontrol.filters.DateFilter;
import typecontrol.filters.DoubleFilter;
import typecontrol.filters.FloatFilter;
import typecontrol.filters.HourFilter;
import typecontrol.filters.IntegerFilter;
import typecontrol.filters.TelephoneFilter;

public class FrmMain extends JFrame {

	private static final long serialVersionUID = 1L;

	private GUI _gui;
	
	public FrmMain() {
		super();
		setTitle("test des filtres ");
		
		initialize();
		//_gui.getTxtFilterDate().setInfo("Nouvelle info");
		
		pack();
		setVisible(true);
		
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			SwingUtilities.updateComponentTreeUI(this);
		} 
		catch (Exception e) {
			System.out.println("FrmUsers.FrmUsers : impossible d'appliquer le thme du systme");
		}
	}
	
	private void initialize() {
		_gui = new GUI();
		
		_gui.getTxtFilterDouble().setNormalBackground(Color.red);
		_gui.getCmbComboBox().setNormalBackground(Color.green);
	}
	
	private class GUI {
		private final Color FOCUS_COLOR = new Color(240, 255, 255);
		
		private final String LAB_INTEGER_CAPTION = "Entier : ";
		private final String LAB_FLOAT_CAPTION = "Prix : ";
		private final String LAB_DOUBLE_CAPTION = "Numrique : ";
		private final String LAB_HOUR_CAPTION = "Heure : ";
		private final String LAB_DATE_CAPTION = "Date : ";
		private final String LAB_TELEPHONE_CAPTION = "Tlphone : ";
		private final String LAB_CHECK_CAPTION = "CheckBox : ";
		private final String LAB_COL_CHOOSER_CAPTION = "Couleur : ";
		private final String LAB_FIL_CHOOSER_CAPTION = "Fichier : ";
		private final String LAB_CMB_COMBO_CAPTION = "ComboBox : ";
		private final String LAB_CMB_DATA_COMBO_CAPTION = "DataComboBox : ";
		
		private JdksTextField _txtFilterInteger;
		private JdksTextField _txtFilterFloat;
		private JdksTextField _txtFilterDouble;
		private JdksTextField _txtFilterHour;
		private JdksTextField _txtFilterDate;
		private JdksTextField _txtFilterTelephone;
		
		private JdksCheckBox _chkCheckBox;
		
		private JdksColorChooser _colColorChooser;
		
		private JdksFileChooser _filFileChooser;
		
		private JdksComboBox _cmbComboBox;
		private JdksComboBox _cmbDataComboBox;
	
		public GUI() {
			setLayout(new GridLayout(11, 1));
			add(getTxtFilterInteger());
			add(getTxtFilterFloat());
			add(getTxtFilterDouble());
			add(getTxtFilterHour());
			add(getTxtFilterDate());
			add(getTxtFilterTelephone());
			add(getChkCheckBox());
			add(getColColorChooser());
			add(getFilFileChooser());
			add(getCmbComboBox());
			add (getCmbDataComboBox());
		}
				
		protected JdksTextField getTxtFilterInteger() {
			if (_txtFilterInteger == null) {
				_txtFilterInteger = new JdksTextField(LAB_INTEGER_CAPTION, "test", new IntegerFilter());
				_txtFilterInteger.setFocusBackground(FOCUS_COLOR);
				_txtFilterInteger.setLabelAlignment(JLabel.RIGHT);
				_txtFilterInteger.setLabelWidth(100);
			}
			return _txtFilterInteger;
		}
				
		protected JdksTextField getTxtFilterFloat() {
			if (_txtFilterFloat == null) {
				_txtFilterFloat = new JdksTextField(LAB_FLOAT_CAPTION, new FloatFilter());
				_txtFilterFloat.setFocusBackground(FOCUS_COLOR);
				_txtFilterFloat.setLabelAlignment(JLabel.RIGHT);
				_txtFilterFloat.setLabelWidth(100);
			}
			return _txtFilterFloat;
		}
				
		protected JdksTextField getTxtFilterDouble() {
			if (_txtFilterDouble == null) {
				_txtFilterDouble = new JdksTextField(LAB_DOUBLE_CAPTION, new DoubleFilter());
				_txtFilterDouble.setFocusBackground(FOCUS_COLOR);
				_txtFilterDouble.setLabelAlignment(JLabel.RIGHT);
				_txtFilterDouble.setLabelWidth(100);
			}
			return _txtFilterDouble;
		}
				
		protected JdksTextField getTxtFilterHour() {
			if (_txtFilterHour == null) {
				_txtFilterHour = new JdksTextField(LAB_HOUR_CAPTION, new HourFilter());
				_txtFilterHour.setFocusBackground(FOCUS_COLOR);
				_txtFilterHour.setLabelAlignment(JLabel.RIGHT);
				_txtFilterHour.setLabelWidth(100);
			}
			return _txtFilterHour;
		}
				
		protected JdksTextField getTxtFilterDate() {
			if (_txtFilterDate == null) {
				_txtFilterDate = new JdksTextField(LAB_DATE_CAPTION, new DateFilter());
				_txtFilterDate.setFocusBackground(FOCUS_COLOR);
				_txtFilterDate.setLabelAlignment(JLabel.RIGHT);
				_txtFilterDate.setLabelWidth(100);
			}
			return _txtFilterDate;
		}
		
		protected JdksTextField getTxtFilterTelephone() {
			if (_txtFilterTelephone == null) {
				_txtFilterTelephone = new JdksTextField(LAB_TELEPHONE_CAPTION, new TelephoneFilter());
				_txtFilterTelephone.setFocusBackground(FOCUS_COLOR);
				_txtFilterTelephone.setLabelAlignment(JLabel.RIGHT);
				_txtFilterTelephone.setLabelWidth(100);
			}
			return _txtFilterTelephone;
		}
		
		protected JdksCheckBox getChkCheckBox() {
			if (_chkCheckBox == null) {
				_chkCheckBox = new JdksCheckBox(LAB_CHECK_CAPTION, "Informations sur une checkbox");
				_chkCheckBox.setLabelWidth(100);
				_chkCheckBox.setLabelAlignment(JLabel.RIGHT);
			}
			return _chkCheckBox;
		}
	
		protected JdksColorChooser getColColorChooser() {
			if (_colColorChooser == null) {
				_colColorChooser = new JdksColorChooser(LAB_COL_CHOOSER_CAPTION, "Informations sur un colorChooser");
				_colColorChooser.setLabelWidth(100);
				_colColorChooser.setLabelAlignment(JLabel.RIGHT);
				_colColorChooser.setValue("RGB(255,255,0)");
			}
			return _colColorChooser;
		}
	
		protected JdksFileChooser getFilFileChooser() {
			if (_filFileChooser == null) {
				_filFileChooser = new JdksFileChooser(LAB_FIL_CHOOSER_CAPTION, "Informations sur un fileChooser");
				_filFileChooser.setLabelAlignment(JLabel.RIGHT);
				_filFileChooser.setLabelWidth(100);
				_filFileChooser.setFocusBackground(FOCUS_COLOR);
			}
			return _filFileChooser;
		}
	
		protected JdksComboBox getCmbComboBox() {
			if (_cmbComboBox == null) {
				_cmbComboBox = new JdksComboBox(LAB_CMB_COMBO_CAPTION, "test");
				//_cmbComboBox.setFocusBackground(FOCUS_COLOR);
				_cmbComboBox.setLabelAlignment(JLabel.RIGHT);
				_cmbComboBox.setLabelWidth(100);
//				_cmbComboBox.addItem("Tata", "Tata");
//				_cmbComboBox.addItem("Tete", "Tete");
//				_cmbComboBox.addItem("Titi", "Titi");
//				_cmbComboBox.addItem("Toto", "Toto");
//				_cmbComboBox.addItem("Tutu", "Tutu");
				_cmbComboBox.setEditable(false);
			}
			return _cmbComboBox;
		}
	
		protected JdksComboBox getCmbDataComboBox() {
			if (_cmbDataComboBox == null) {
				_cmbDataComboBox = new JdksComboBox(LAB_CMB_DATA_COMBO_CAPTION, "test");
				_cmbDataComboBox.setFocusBackground(FOCUS_COLOR);
				_cmbDataComboBox.setLabelAlignment(JLabel.RIGHT);
				_cmbDataComboBox.setLabelWidth(100);
//				try {
//					CDataBaseAccess.getInstance();
//					Statement state = CDataBaseAccess.getStatement();
//					_cmbDataComboBox.loadFromResultSet(state.executeQuery("SELECT id, C_Caption FROM tb_menus ORDER BY C_Caption"), "C_Caption", "id");
//				} catch (SQLException e) {
//					e.printStackTrace();
//				}
				_cmbComboBox.setEditable(false);
			}
			return _cmbDataComboBox;
		}
	}
	
	public static void main(String arg[]) {
		new FrmMain();
	}
	
}
