package typecontrol.tools;

import java.sql.*;

public class CDataBaseAccess {

	private static final String DATABASENAME = "illicoperso";
	private static final String USERNAME = "Illico";
	private static final String PASSWORD = "IllicoAdmin";
	
	static Connection _connection;
	static CDataBaseAccess _instance;
	
	protected CDataBaseAccess() {} 
	
	public static CDataBaseAccess getInstance() {
		if (_instance == null) {
			_instance = new CDataBaseAccess();
			try {
				connect();
			} catch (ConnectErrorException e) {
				System.out.println("Erreur lors de la connection  la base de donnes : " + e.getMessage());
			}
		}
		return _instance;
	}
	
	private static void connect() throws ConnectErrorException {
	    try {
	    	Class.forName("com.mysql.jdbc.Driver").newInstance();
	    	_connection = DriverManager.getConnection("jdbc:mysql://localhost/" + DATABASENAME, USERNAME, PASSWORD);
		}
		catch (Exception e) {
			e.printStackTrace();
			ConnectErrorException exception = new ConnectErrorException();
			throw exception;
		}
	}
	
	public static Statement getStatement() throws SQLException {
		return _connection.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE);
	}
	
	public void disconnect() throws SQLException {
		_connection.close();
	}    
	
	public static void updateColumn(String sTable, String sColumn, String sFormat, Boolean bNullable, String sDefault) {
		String sRequete = "ALTER TABLE " + sTable + " ADD COLUMN " + sColumn + " " + sFormat;
		if (!bNullable) {
			sRequete += " NOT NULL ";
		}
		if (sDefault.compareTo("") != 0) {
			sRequete += " default '" + sDefault + "' ";
		}
		try {
			Statement oState = getStatement();
			oState.execute(sRequete);
		}
		catch (Exception e) {
			System.out.println(sRequete + " : " + e.getMessage());
		}
	}
	
	public static void addIndex(String sIndexName, String sTable, String sColumn, boolean bUnique) {
		String sRequete = "ALTER TABLE " + sTable + " ADD " + (bUnique ? "UNIQUE " : " ") + sIndexName + " (" + sColumn + ")";
		try {
			Statement oState = getStatement();
			oState.execute(sRequete);
		}
		catch (Exception e) {
			System.out.println(sRequete + " : " + e.getMessage());
		}
		
	}
	
	public static void createTable(String sTableName) {
		String sCreateQuery = "CREATE TABLE " + sTableName + " (id INTEGER UNSIGNED NOT NULL DEFAULT NULL AUTO_INCREMENT, PRIMARY KEY(id)) ENGINE = MYISAM";
		try {
			Statement oState = getStatement();
			oState.execute(sCreateQuery);
		}
		catch (Exception e) {
			System.out.println("Erreur lors de la cration de la table " + sTableName + " : " + e.getMessage());
		}
	}
		
	public static class ConnectErrorException extends Throwable{

		private static final long serialVersionUID = 1L;

		public String getMessage() {
			return "Impossible de se connecter  la base de donnes.";
		}
	}
}

