/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh;

import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import java.util.Set;

public final class Util {
    private Util() {
    }

    public static Set<TypeLabel> getNodeLabels(HostGraph graph, HostNode node) {
        MyHashSet<TypeLabel> nodeLabels = new MyHashSet<TypeLabel>();
        TypeNode typeNode = node.getType();
        if (!typeNode.isTopType()) {
            nodeLabels.add(typeNode.label());
        }
        for (HostEdge edge : graph.edgeSet(node)) {
            if (edge.getRole() == EdgeRole.BINARY) continue;
            nodeLabels.add(edge.label());
        }
        return nodeLabels;
    }

    public static Set<TypeLabel> getBinaryLabels(HostGraph graph) {
        MyHashSet<TypeLabel> result = new MyHashSet<TypeLabel>();
        for (HostEdge edge : graph.edgeSet()) {
            if (edge.getRole() != EdgeRole.BINARY) continue;
            result.add(edge.label());
        }
        return result;
    }

    public static <E extends HostEdge> Set<E> getBinaryEdges(HostGraph graph) {
        MyHashSet result = new MyHashSet();
        for (HostEdge edge : graph.edgeSet()) {
            if (edge.getRole() != EdgeRole.BINARY) continue;
            result.add(edge);
        }
        return result;
    }

    public static Set<ShapeEdge> getBinaryEdges(Shape shape) {
        return Util.getBinaryEdges((HostGraph)shape);
    }

    public static <N extends Node, E extends Edge> void getIntersectEdges(Graph graph, N src, N tgt, Label label, Set<E> result) {
        result.clear();
        for (Edge edge : graph.outEdgeSet(src)) {
            if (!edge.label().equals(label) || !edge.target().equals(tgt)) continue;
            result.add(edge);
        }
    }

    public static <N extends Node, E extends Edge> void getIntersectEdges(Graph graph, Set<N> srcs, N tgt, Label label, Set<E> result) {
        result.clear();
        for (Edge edge : graph.inEdgeSet(tgt)) {
            if (!edge.label().equals(label) || !srcs.contains(edge.source())) continue;
            result.add(edge);
        }
    }

    public static <N extends Node, E extends Edge> void getIntersectEdges(Graph graph, N src, Set<N> tgts, Label label, Set<E> result) {
        result.clear();
        for (Edge edge : graph.outEdgeSet(src)) {
            if (!edge.label().equals(label) || !tgts.contains(edge.target())) continue;
            result.add(edge);
        }
    }
}

