/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.lts;

import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.NeighAbsParam;
import groove.abstraction.neigh.lts.ShapeMatchApplier;
import groove.abstraction.neigh.lts.ShapeNextState;
import groove.abstraction.neigh.lts.ShapeState;
import groove.abstraction.neigh.lts.ShapeTransition;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.iso.ShapeIsoChecker;
import groove.grammar.Grammar;
import groove.grammar.host.HostGraph;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.graph.GraphCache;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.lts.MatchApplier;
import groove.lts.RuleTransition;
import groove.lts.RuleTransitionLabel;
import groove.transform.RuleEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class AGTS
extends GTS {
    private int subsumedStatesCount = 0;
    private int subsumedTransitionsCount = 0;
    private final boolean reachability;
    private final Collection<ShapeState> toRemove;
    private int nextStateNr;

    public AGTS(Grammar grammar, boolean reachability) {
        super(grammar);
        this.reachability = reachability;
        this.toRemove = this.reachability ? new MyHashSet<ShapeState>() : null;
        this.nextStateNr = 0;
        this.getRecord().setReuseEvents(RuleEvent.Reuse.NONE);
        this.getRecord().setCheckIso(true);
        this.storeAbsLabels();
    }

    private AGTS(AGTS agts) {
        super(agts.getGrammar());
        this.reachability = agts.reachability;
        this.toRemove = null;
        this.nextStateNr = 0;
        this.getRecord().setReuseEvents(RuleEvent.Reuse.NONE);
        this.getRecord().setCheckIso(false);
    }

    @Override
    public ShapeState addState(GraphState newGState) {
        ShapeState newState;
        ShapeState result;
        assert (newGState instanceof ShapeState) : "Type error : " + newGState + " is not of type ShapeState.";
        if (this.reachability) {
            this.toRemove.clear();
        }
        if ((result = (ShapeState)super.addState(newState = (ShapeState)newGState)) == null) {
            this.subsumedStatesCount += newState.markSubsumedStates(this.toRemove);
            if (this.reachability) {
                for (ShapeState stateToRemove : this.toRemove) {
                    this.getStateSet().remove(stateToRemove);
                    stateToRemove.disconnectState();
                }
            }
            this.nextStateNr = newState.getNumber() + 1;
        } else if (newState.isSubsumed()) {
            ++this.subsumedTransitionsCount;
        }
        return result;
    }

    @Override
    public void addTransition(GraphTransition transition) {
        assert (transition instanceof ShapeTransition || transition instanceof ShapeNextState) : "Type error : " + transition + " is not of type ShapeTransition or ShapeNextState.";
        if (!this.reachability) {
            super.addTransition(transition);
        }
    }

    @Override
    public Set<? extends ShapeState> nodeSet() {
        return super.nodeSet();
    }

    @Override
    protected ShapeStateSet createStateSet() {
        return new ShapeStateSet(this.getCollapse(), this.isReachability());
    }

    @Override
    protected GraphCache<GraphState, RuleTransition> createCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Shape createStartGraph(HostGraph startGraph) {
        Shape result = Shape.createShape(startGraph);
        return result;
    }

    @Override
    protected ShapeState createStartState(HostGraph startGraph) {
        ShapeState result = new ShapeState(this, (Shape)startGraph, this.getGrammar().getCtrlAut().getStart(), 0);
        return result;
    }

    @Override
    public boolean checkDiamonds() {
        return false;
    }

    @Override
    public ShapeState startState() {
        return (ShapeState)super.startState();
    }

    private void storeAbsLabels() {
        TypeGraph typeGraph = this.getGrammar().getTypeGraph();
        MyHashSet unaryLabels = new MyHashSet();
        for (TypeEdge typeEdge : typeGraph.edgeSet()) {
            if (typeEdge.getRole() == EdgeRole.BINARY) continue;
            unaryLabels.add((TypeLabel)typeEdge.label());
        }
        if (!typeGraph.isImplicit()) {
            for (TypeNode typeNode : typeGraph.nodeSet()) {
                if (typeNode.isTopType()) continue;
                unaryLabels.add(typeNode.label());
            }
        }
        List<String> absLabelsStr = this.getGrammar().getProperties().getAbstractionLabels();
        MyHashSet<TypeLabel> absLabels = new MyHashSet<TypeLabel>();
        for (TypeLabel unaryLabel : unaryLabels) {
            if (!absLabelsStr.contains(unaryLabel.text())) continue;
            absLabels.add(unaryLabel);
        }
        NeighAbsParam.getInstance().setAbsLabels(absLabels);
    }

    public int getSubsumedStatesCount() {
        return this.subsumedStatesCount;
    }

    public int getSubsumedTransitionsCount() {
        return this.subsumedTransitionsCount;
    }

    public int getStateCount() {
        return this.nodeCount();
    }

    public boolean isReachability() {
        return this.reachability;
    }

    public int getNextStateNr() {
        return this.nextStateNr;
    }

    public AGTS reduceGTS() {
        AGTS result = new AGTS(this);
        MyHashMap<ShapeState, ShapeState> closureMap = new MyHashMap<ShapeState, ShapeState>();
        ArrayList<ShapeState> ancestors = new ArrayList<ShapeState>();
        for (GraphState graphState : this.getStateSet()) {
            ShapeState state = (ShapeState)graphState;
            if (!state.isSubsumed() && !closureMap.containsKey(state)) {
                closureMap.put(state, state);
                continue;
            }
            ShapeState closure = (ShapeState)closureMap.get(state);
            if (closure != null) continue;
            ShapeState subsumptor = state.getSubsumptor();
            closure = (ShapeState)closureMap.get(subsumptor);
            ancestors.clear();
            ancestors.add(state);
            while (closure == null) {
                if (subsumptor.isSubsumed()) {
                    ancestors.add(subsumptor);
                    subsumptor = subsumptor.getSubsumptor();
                    closure = (ShapeState)closureMap.get(subsumptor);
                    continue;
                }
                closure = subsumptor;
                ancestors.add(closure);
            }
            for (ShapeState ancestor : ancestors) {
                assert (!closureMap.containsKey(ancestor));
                closureMap.put(ancestor, closure);
            }
        }
        LinkedList<ShapeState> toProcess = new LinkedList<ShapeState>();
        toProcess.add(this.startState());
        MyHashMap<ShapeState, ShapeState> stateMap = new MyHashMap<ShapeState, ShapeState>();
        while (!toProcess.isEmpty()) {
            ShapeState origSrc = (ShapeState)toProcess.remove(0);
            ShapeState origSrcClosure = (ShapeState)closureMap.get(origSrc);
            assert (origSrcClosure != null);
            ShapeState reducedSrc = (ShapeState)stateMap.get(origSrcClosure);
            if (reducedSrc == null) {
                assert (!(origSrc instanceof ShapeNextState));
                reducedSrc = new ShapeState(this, origSrcClosure.getGraph(), origSrcClosure.getCtrlState(), 0);
                this.addReducedState(result, origSrcClosure, reducedSrc);
                stateMap.put(origSrcClosure, reducedSrc);
                result.startState = reducedSrc;
            }
            for (RuleTransition origTrans : origSrcClosure.getRuleTransitions()) {
                ShapeState origTgt = (ShapeState)origTrans.target();
                ShapeState origTgtClosure = (ShapeState)closureMap.get(origTgt);
                assert (origTgtClosure != null);
                ShapeState reducedTgt = (ShapeState)stateMap.get(origTgtClosure);
                if (reducedTgt == null) {
                    reducedTgt = new ShapeNextState(result.nodeCount(), origTgtClosure.getGraph(), reducedSrc, origTrans.getKey());
                    toProcess.add(origTgtClosure);
                    this.addReducedState(result, origTgtClosure, reducedTgt);
                    stateMap.put(origTgtClosure, reducedTgt);
                    continue;
                }
                RuleTransitionLabel transLabel = origTrans.label();
                if (reducedSrc.containsTransition(transLabel, reducedTgt)) continue;
                ShapeTransition reducedTrans = new ShapeTransition(reducedSrc, origTrans.getKey(), reducedTgt);
                result.addTransition(reducedTrans);
            }
        }
        return result;
    }

    private void addReducedState(AGTS reducedGTS, ShapeState origState, ShapeState reducedState) {
        reducedGTS.addStateWithoutCheck(reducedState);
        if (reducedState instanceof ShapeNextState) {
            reducedGTS.addTransition((RuleTransition)((Object)reducedState));
        }
        reducedState.setClosed(true);
        if (this.isFinal(origState)) {
            reducedGTS.setFinal(reducedState);
        }
    }

    private ShapeState addStateWithoutCheck(ShapeState state) {
        return (ShapeState)super.addState(state);
    }

    @Override
    protected MatchApplier createMatchApplier() {
        return new ShapeMatchApplier(this);
    }

    private static final class ShapeStateSet
    extends GTS.StateSet {
        private final boolean reachability;

        ShapeStateSet(GTS.CollapseMode collapse, boolean reachability) {
            super(collapse, ShapeIsoChecker.getInstance(true));
            this.reachability = reachability;
        }

        @Override
        protected boolean areEqual(GraphState myState, GraphState otherState) {
            int comparison;
            ShapeIsoChecker checker;
            if (myState.getCtrlState() != otherState.getCtrlState()) {
                return false;
            }
            assert (myState instanceof ShapeState);
            assert (otherState instanceof ShapeState);
            ShapeState myShapeState = (ShapeState)myState;
            ShapeState otherShapeState = (ShapeState)otherState;
            if (this.reachability) {
                if (myShapeState.isSubsumed() || otherShapeState.isSubsumed()) {
                    return myShapeState == otherShapeState;
                }
            } else if (otherShapeState.isSubsumed()) {
                return false;
            }
            if ((checker = ShapeIsoChecker.getInstance(true)).isDomStrictlyLargerThanCod(comparison = checker.compareShapes(myShapeState.getGraph(), otherShapeState.getGraph()).one().intValue())) {
                myShapeState.addSubsumedState(otherShapeState);
            } else if (checker.isCodSubsumesDom(comparison)) {
                myShapeState.setSubsumptor(otherShapeState);
            }
            return checker.areEqual(comparison);
        }
    }
}

