/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.trans.BoundType;
import groove.abstraction.neigh.trans.Solution;
import groove.abstraction.neigh.trans.Var;
import groove.util.Fixable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

final class Equation
implements Fixable {
    private final BoundType type;
    private final List<Var> vars;
    private final BitSet varSet;
    private final int constant;
    private final ShapeNode node;
    private int hashCode;

    Equation(List<Var> vars, BoundType type, int constant, ShapeNode node) {
        this.type = type;
        this.vars = vars;
        this.varSet = new BitSet();
        for (Var var : vars) {
            this.varSet.set(var.getNumber());
        }
        this.constant = constant;
        this.node = node;
        this.hashCode = 0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<Var> iter = this.vars.iterator();
        while (iter.hasNext()) {
            result.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            result.append(" + ");
        }
        switch (this.type) {
            case UB: {
                result.append(" <= ");
                break;
            }
            case LB: {
                result.append(" >= ");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.constant == Integer.MAX_VALUE) {
            result.append("w");
        } else {
            result.append(this.constant);
        }
        if (this.hasNode()) {
            result.append(" (" + this.getNode() + ")");
        }
        return result.toString();
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            if (this.hashCode == 0) {
                this.hashCode = -1;
            }
        }
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = 1;
        result = 31 * result + this.constant;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.varSet.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        boolean result;
        if (!(o instanceof Equation)) {
            result = false;
        } else {
            Equation eq = (Equation)o;
            result = this.constant == eq.constant && this.type == eq.type && this.varSet.equals(eq.varSet);
        }
        return result;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.hashCode();
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.hashCode != 0;
    }

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    boolean hasNode() {
        return this.node != null;
    }

    ShapeNode getNode() {
        assert (this.hasNode());
        return this.node;
    }

    public int getConstant() {
        return this.constant;
    }

    public BoundType getType() {
        return this.type;
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    boolean isTrivial() {
        return this.vars.size() == 1 && !this.hasNode();
    }

    boolean isUseful() {
        boolean result = false;
        switch (this.type) {
            case UB: {
                result = this.hasNode() || this.constant < Integer.MAX_VALUE;
                break;
            }
            case LB: {
                result = this.hasNode() || this.constant > 0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    boolean computeNewValues(Solution sol) {
        int fixedVarsSum = sol.getSum(this.vars, true);
        if (!this.hasOpenVars(sol)) {
            if (this.hasNode() && fixedVarsSum == 0) {
                sol.addGarbageNode(this.getNode());
            }
            return true;
        }
        if (this.hasNode() && sol.isGarbage(this.getNode())) {
            for (Var var : this.vars) {
                sol.setToZero(var);
            }
            return true;
        }
        ArrayList<Var> openVars = this.getOpenVars(sol);
        int newConst = Multiplicity.sub(this.constant, fixedVarsSum);
        if (this.type == BoundType.LB) {
            if (openVars.size() == 1) {
                sol.cutLow(openVars.get(0), newConst);
                return !this.hasNode();
            }
            int openVarsMaxSum = this.getOpenVarsMaxSum(sol);
            if (openVarsMaxSum == newConst) {
                for (Var openVar : openVars) {
                    sol.cutLow(openVar, sol.getMaxValue(openVar));
                }
            }
            return false;
        }
        if (this.type == BoundType.UB) {
            if (newConst == 0) {
                for (Var openVar : openVars) {
                    sol.cutHigh(openVar, newConst);
                }
                return true;
            }
            if (openVars.size() == 1) {
                sol.cutHigh(openVars.get(0), newConst);
                return !this.hasNode();
            }
            for (Var openVar : openVars) {
                sol.cutHigh(openVar, newConst);
            }
            return false;
        }
        assert (false);
        return false;
    }

    public boolean hasOpenVars(Solution sol) {
        boolean result = false;
        for (Var var : this.vars) {
            if (sol.isSingleton(var)) continue;
            result = true;
            break;
        }
        return result;
    }

    public ArrayList<Var> getOpenVars(Solution sol) {
        ArrayList<Var> result = new ArrayList<Var>(this.vars.size());
        for (Var var : this.vars) {
            if (sol.isSingleton(var)) continue;
            result.add(var);
        }
        return result;
    }

    private int getOpenVarsMaxSum(Solution sol) {
        int result = 0;
        for (Var var : this.vars) {
            if (sol.isSingleton(var)) continue;
            result += sol.getMaxValue(var);
        }
        return result;
    }

    boolean isValidSolution(Solution sol) {
        int sum = sol.getSum(this.vars, false);
        boolean result = false;
        switch (this.type) {
            case LB: {
                result = sum >= this.constant;
                break;
            }
            case UB: {
                result = sum <= this.constant;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }
}

