/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.trans;

import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.trans.EdgeBundle;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class PowerSetIterator
implements Iterator<Map<EdgeBundle, Set<ShapeEdge>>> {
    private final boolean skipEmpty;
    private final EdgeBundle[] bundles;
    private final int[] masks;
    private final ShapeEdge[] edges;
    private final int[] results;
    private final Map<EdgeBundle, Set<ShapeEdge>> resultMap;
    private int total;
    private int curr;

    public PowerSetIterator(Set<EdgeBundle> bundles, boolean skipEmpty) {
        this.bundles = new EdgeBundle[bundles.size()];
        bundles.toArray(this.bundles);
        this.masks = new int[this.bundles.length];
        this.resultMap = new MyHashMap<EdgeBundle, Set<ShapeEdge>>();
        int edgeCount = 0;
        int bundleIdx = 0;
        while (bundleIdx < this.bundles.length) {
            int mask;
            EdgeBundle bundle = this.bundles[bundleIdx];
            this.resultMap.put(bundle, new MyHashSet());
            int bundleSize = bundle.possibleEdges.size();
            this.masks[bundleIdx] = mask = (int)Math.pow(2.0, bundleSize) - 1 << edgeCount;
            edgeCount += bundleSize;
            ++bundleIdx;
        }
        this.edges = new ShapeEdge[edgeCount];
        int edgeIdx = 0;
        int bundleIdx2 = 0;
        while (bundleIdx2 < this.bundles.length) {
            for (ShapeEdge edge : this.bundles[bundleIdx2].possibleEdges) {
                this.edges[edgeIdx++] = edge;
            }
            ++bundleIdx2;
        }
        int resultCount = (int)Math.pow(2.0, edgeCount);
        this.results = new int[resultCount];
        this.total = 0;
        int result = 0;
        int i = 0;
        while (i < resultCount) {
            if (this.isValidResult(result)) {
                this.results[this.total++] = result;
            }
            ++result;
            ++i;
        }
        this.skipEmpty = skipEmpty;
        this.curr = this.skipEmpty ? 1 : 0;
    }

    @Override
    public boolean hasNext() {
        return this.curr < this.total;
    }

    @Override
    public Map<EdgeBundle, Set<ShapeEdge>> next() {
        assert (this.hasNext());
        int result = this.results[this.curr++];
        int bundleIdx = 0;
        while (bundleIdx < this.bundles.length) {
            EdgeBundle bundle = this.bundles[bundleIdx];
            int mask = this.masks[bundleIdx];
            int maskedResult = result & mask;
            Set<ShapeEdge> edgeSet = this.resultMap.get(bundle);
            edgeSet.clear();
            int edgeIdx = 0;
            while (edgeIdx < this.edges.length) {
                int shiftedIdx = 1 << edgeIdx;
                if ((maskedResult & shiftedIdx) == shiftedIdx) {
                    edgeSet.add(this.edges[edgeIdx]);
                }
                ++edgeIdx;
            }
            ++bundleIdx;
        }
        return this.resultMap;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean isValidResult(int result) {
        boolean isValid = true;
        int bundleIdx = 0;
        while (bundleIdx < this.bundles.length) {
            EdgeBundle bundle = this.bundles[bundleIdx];
            int mask = this.masks[bundleIdx];
            int maskedResult = result & mask;
            int bound = bundle.origEsMult.getUpperBound();
            if (Integer.bitCount(maskedResult) > bound) {
                isValid = false;
                break;
            }
            ++bundleIdx;
        }
        return isValid;
    }

    public int resultCount() {
        if (this.skipEmpty) {
            return this.total - 1;
        }
        return this.total;
    }
}

