/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.explore;

import groove.abstraction.Multiplicity;
import groove.abstraction.pattern.PatternAbsParam;
import groove.abstraction.pattern.PatternAbstraction;
import groove.abstraction.pattern.explore.PatternGraphGenerator;
import groove.abstraction.pattern.lts.PSTS;
import groove.util.CommandLineOption;
import java.io.PrintStream;

public final class PatternShapeGenerator
extends PatternGraphGenerator {
    private static final String USAGE_MESSAGE = "Usage: PatternShapeGenerator [options] <grammar> <start-graph-name> <type-graph-name>";

    public PatternShapeGenerator(String ... args) {
        super(args);
        this.addOption(new MultiplicityBoundOption(Multiplicity.MultKind.NODE_MULT));
        this.addOption(new MultiplicityBoundOption(Multiplicity.MultKind.EDGE_MULT));
        this.addOption(new ThreeMultValOption());
    }

    @Override
    protected String getUsageMessage() {
        return USAGE_MESSAGE;
    }

    @Override
    public PSTS getPGTS() {
        if (pgts == null) {
            pgts = new PSTS(this.getGrammar());
        }
        return (PSTS)pgts;
    }

    @Override
    protected void reset() {
        PatternAbstraction.initialise();
        pgts = null;
    }

    @Override
    protected void prelude() {
        if (this.getVerbosity() > 0) {
            this.println("\n======================================================\n");
            this.println("Grammar:\t" + this.grammarLocation);
            this.println("Start graph:\t" + (this.startGraphName == null ? "default" : this.startGraphName));
            this.println("Type graph:\t" + this.typeGraphName);
            PatternAbsParam params = PatternAbsParam.getInstance();
            this.print("Node bound:\t" + params.getNodeMultBound() + "\tEdge bound:\t" + params.getEdgeMultBound());
            if (params.isUseThreeValues()) {
                this.println("\tLIMITING MULTIPLICITIES TO 0, 1 and 0+");
            } else {
                this.println();
            }
            this.println("Timestamp:\t" + this.invocationTime);
            this.print("\nProgress:\n\n");
            this.addProgressMonitor();
        }
    }

    @Override
    public void report() {
        PrintStream out = System.out;
        PSTS psts = this.getPGTS();
        out.println(String.format("\nPSTS: States: %d -- %d subsumed (%d discarded) / Transitions: %d (%d subsumed)\n", psts.getStateCount(), psts.getSubsumedStatesCount(), psts.openStateCount(), psts.getTransitionCount(), psts.getSubsumedTransitionsCount()));
    }

    public static void main(String[] args) {
        new PatternShapeGenerator(args).start();
    }

    private static class MultiplicityBoundOption
    implements CommandLineOption {
        final Multiplicity.MultKind kind;

        MultiplicityBoundOption(Multiplicity.MultKind kind) {
            this.kind = kind;
        }

        @Override
        public String getName() {
            String name = null;
            switch (this.kind) {
                case NODE_MULT: {
                    name = "n";
                    break;
                }
                case EDGE_MULT: {
                    name = "m";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return name;
        }

        @Override
        public String[] getDescription() {
            String type = null;
            switch (this.kind) {
                case NODE_MULT: {
                    type = "node";
                    break;
                }
                case EDGE_MULT: {
                    type = "edge";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new String[]{"Set the " + type + " multiplicity bound to " + "the given value.", "Argument '" + this.getParameterName() + "' must be greater than zero (default value is 1)."};
        }

        @Override
        public String getParameterName() {
            return "val";
        }

        @Override
        public boolean hasParameter() {
            return true;
        }

        @Override
        public void parse(String parameter) throws IllegalArgumentException {
            int bound = 0;
            try {
                bound = Integer.parseInt(parameter);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("verbosity value '" + parameter + "' must be numeric");
            }
            if (bound < 1) {
                throw new IllegalArgumentException("'" + parameter + "' bound must be >= 1.");
            }
            switch (this.kind) {
                case NODE_MULT: {
                    PatternAbsParam.getInstance().setNodeMultBound(bound);
                    break;
                }
                case EDGE_MULT: {
                    PatternAbsParam.getInstance().setEdgeMultBound(bound);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private class ThreeMultValOption
    implements CommandLineOption {
        private ThreeMultValOption() {
        }

        @Override
        public String[] getDescription() {
            return new String[]{"Limit the possible multiplicity values to three: 0, 1, or 0+."};
        }

        @Override
        public String getParameterName() {
            return null;
        }

        @Override
        public String getName() {
            return "t";
        }

        @Override
        public boolean hasParameter() {
            return false;
        }

        @Override
        public void parse(String parameter) {
            PatternAbsParam.getInstance().setUseThreeValues(true);
        }
    }
}

