/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.explore.util;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.lts.MatchResult;
import groove.abstraction.pattern.lts.PatternState;
import groove.abstraction.pattern.match.Matcher;
import groove.abstraction.pattern.match.MatcherFactory;
import groove.abstraction.pattern.trans.PatternRule;
import groove.control.CtrlSchedule;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import java.util.Collection;
import java.util.List;

public class PatternGraphMatchSetCollector {
    private final PatternState state;
    private final CtrlState ctrlState;
    private int transIx;
    private boolean matchFound;

    public PatternGraphMatchSetCollector(PatternState state) {
        this.state = state;
        this.ctrlState = state.getCtrlState();
        assert (this.ctrlState != null);
    }

    public Collection<MatchResult> getMatchSet() {
        MyHashSet<MatchResult> result = new MyHashSet<MatchResult>();
        CtrlTransition ctrlTrans = this.firstCall();
        while (ctrlTrans != null) {
            boolean hasMatches = this.collectEvents(ctrlTrans, result);
            ctrlTrans = this.nextCall(hasMatches);
        }
        return result;
    }

    protected boolean isInjective() {
        return true;
    }

    private CtrlTransition firstCall() {
        CtrlTransition result;
        CtrlSchedule schedule = this.ctrlState.getSchedule();
        this.state.setSchedule(schedule);
        if (schedule.isFinished()) {
            result = null;
        } else {
            result = schedule.getTransitions().get(0);
            this.transIx = 1;
            this.matchFound = false;
        }
        return result;
    }

    private CtrlTransition nextCall(boolean matchFound) {
        CtrlTransition result;
        CtrlSchedule schedule = this.state.getSchedule();
        this.matchFound |= matchFound;
        if (schedule.isFinished()) {
            result = null;
        } else if (this.transIx < schedule.getTransitions().size()) {
            result = schedule.getTransitions().get(this.transIx);
            ++this.transIx;
        } else {
            schedule = schedule.next(this.matchFound);
            this.state.setSchedule(schedule);
            if (schedule.isFinished()) {
                result = null;
            } else {
                result = schedule.getTransitions().get(0);
                this.transIx = 1;
                this.matchFound = false;
            }
        }
        return result;
    }

    private boolean collectEvents(CtrlTransition ctrlTrans, Collection<MatchResult> result) {
        String ruleName = ctrlTrans.getRule().getLastName();
        PatternRule pRule = this.state.getPGTS().getGrammar().getRule(ruleName);
        Matcher matcher = MatcherFactory.instance().getMatcher(pRule, this.isInjective());
        List<MatchResult> matches = matcher.findMatches(this.state.getGraph(), ctrlTrans);
        result.addAll(matches);
        return !matches.isEmpty();
    }
}

