/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.lts;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.lts.PGTS;
import groove.abstraction.pattern.lts.PatternState;
import groove.abstraction.pattern.lts.PatternTransition;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.control.CtrlSchedule;
import groove.control.CtrlState;
import java.util.Set;

public abstract class AbstractPatternState
implements PatternState {
    private final int nr;
    private CtrlSchedule schedule;
    private boolean closed;
    private Set<PatternTransition> transitions;

    public AbstractPatternState(int number) {
        assert (number >= 0);
        this.nr = number;
        this.transitions = new MyHashSet<PatternTransition>();
    }

    @Override
    public int getNumber() {
        return this.nr;
    }

    public String toString() {
        return "s" + this.nr;
    }

    @Override
    public abstract PGTS getPGTS();

    @Override
    public abstract PatternGraph getGraph();

    @Override
    public final CtrlState getCtrlState() {
        return this.schedule.getState();
    }

    protected final void setCtrlState(CtrlState ctrlState) {
        this.schedule = ctrlState.getSchedule();
    }

    @Override
    public final CtrlSchedule getSchedule() {
        return this.schedule;
    }

    @Override
    public final void setSchedule(CtrlSchedule schedule) {
        assert (schedule.getState() == this.getCtrlState());
        this.schedule = schedule;
    }

    @Override
    public final boolean setClosed(boolean finished) {
        this.closed = finished;
        if (finished) {
            this.getPGTS().notifyClosure(this);
        }
        return finished;
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean addTransition(PatternTransition transition) {
        this.transitions.add(transition);
        return true;
    }

    @Override
    public final Set<PatternTransition> getTransitionSet() {
        return this.transitions;
    }
}

