/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.match.Matcher;
import groove.abstraction.pattern.match.PatternEdgeSearchItem;
import groove.abstraction.pattern.match.SearchItem;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import java.util.Collection;

final class NegatedSearchItem
extends SearchItem {
    private final RuleEdge edge1;
    private final RuleEdge edge2;
    final SearchItem inner1;
    final SearchItem inner2;
    private final Collection<RuleNode> neededNodes;

    public NegatedSearchItem(RuleEdge edge1, RuleEdge edge2) {
        assert (((RuleNode)edge1.target()).equals(edge2.target()));
        this.edge1 = edge1;
        this.edge2 = edge2;
        this.inner1 = new PatternEdgeSearchItem(edge1);
        this.inner2 = new PatternEdgeSearchItem(edge2);
        this.neededNodes = new MyHashSet<RuleNode>();
        this.neededNodes.add((RuleNode)this.edge1.source());
        this.neededNodes.add((RuleNode)this.edge2.source());
    }

    @Override
    public NegatedSearchRecord createRecord(Matcher.Search search) {
        return new NegatedSearchRecord(search);
    }

    public String toString() {
        return String.format("Negation of [%s && %s]", this.inner1, this.inner2);
    }

    @Override
    public Collection<RuleNode> needsNodes() {
        return this.neededNodes;
    }

    @Override
    int getRating() {
        return 0;
    }

    @Override
    public void activate(Matcher matcher) {
        this.inner1.activate(matcher);
        this.inner2.activate(matcher);
    }

    private class NegatedSearchRecord
    extends SearchItem.SingularRecord {
        private final SearchItem.Record innerRecord1;
        private final SearchItem.Record innerRecord2;

        NegatedSearchRecord(Matcher.Search search) {
            super(NegatedSearchItem.this, search);
            this.innerRecord1 = NegatedSearchItem.this.inner1.createRecord(search);
            this.innerRecord2 = NegatedSearchItem.this.inner2.createRecord(search);
        }

        @Override
        public void initialise(PatternGraph host) {
            super.initialise(host);
            this.innerRecord1.initialise(host);
            this.innerRecord2.initialise(host);
        }

        @Override
        boolean find() {
            boolean edge1Found = false;
            boolean edge2Found = false;
            edge1Found = this.innerRecord1.next();
            while (edge1Found) {
                edge2Found = this.innerRecord2.next();
                if (edge2Found) break;
                this.innerRecord2.reset();
                edge1Found = this.innerRecord1.next();
            }
            this.innerRecord1.reset();
            this.innerRecord2.reset();
            return !edge1Found || !edge2Found;
        }

        @Override
        void erase() {
        }

        @Override
        boolean write() {
            return true;
        }
    }
}

