/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.match;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.match.NegatedSearchItem;
import groove.abstraction.pattern.match.PatternEdgeSearchItem;
import groove.abstraction.pattern.match.PatternNodeSearchItem;
import groove.abstraction.pattern.match.SearchItem;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.PatternRuleGraph;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class PatternSearchPlan
extends ArrayList<SearchItem> {
    private final PatternRule pRule;
    private final List<Integer> dependencies;
    private final boolean injective;

    public PatternSearchPlan(PatternRule pRule, boolean injective) {
        this.pRule = pRule;
        this.injective = injective;
        this.dependencies = new ArrayList<Integer>();
        this.computeSearchItems();
    }

    @Override
    public boolean add(SearchItem e) {
        int position = this.size();
        boolean result = super.add(e);
        int depend = -1;
        MyHashSet usedNodes = new MyHashSet();
        usedNodes.addAll(e.needsNodes());
        usedNodes.addAll(e.bindsNodes());
        int i = 0;
        while (i < position) {
            if (usedNodes.removeAll(((SearchItem)this.get(i)).bindsNodes())) {
                depend = i;
            }
            ++i;
        }
        if (this.injective) {
            MyHashSet boundNodes = new MyHashSet();
            BitSet bindsNewNodes = new BitSet();
            int i2 = 0;
            while (i2 <= position) {
                bindsNewNodes.set(i2, boundNodes.addAll(((SearchItem)this.get(i2)).bindsNodes()));
                ++i2;
            }
            if (bindsNewNodes.get(position)) {
                i2 = 0;
                while (i2 < position) {
                    if (bindsNewNodes.get(i2)) {
                        depend = i2;
                    }
                    ++i2;
                }
            }
        }
        this.dependencies.add(depend);
        return result;
    }

    public PatternRule getRule() {
        return this.pRule;
    }

    public int getDependency(int i) {
        return this.dependencies.get(i);
    }

    private void computeSearchItems() {
        PlanData planData = new PlanData(this.pRule);
        for (SearchItem item : planData.getPlanItems()) {
            item.setRelevant(true);
            this.add(item);
        }
        this.trimToSize();
    }

    @Override
    public SearchItem set(int index, SearchItem element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, SearchItem element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchItem remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends SearchItem> c) {
        throw new UnsupportedOperationException();
    }

    private static class ConnectedPartsComparator
    implements Comparator<SearchItem> {
        private final Set<RuleNode> remainingNodes;

        ConnectedPartsComparator(Set<RuleNode> remainingNodes) {
            this.remainingNodes = remainingNodes;
        }

        @Override
        public int compare(SearchItem o1, SearchItem o2) {
            return this.getConnectCount(o1) - this.getConnectCount(o2);
        }

        private int getConnectCount(SearchItem item) {
            int result = 0;
            for (RuleNode node : item.bindsNodes()) {
                if (this.remainingNodes.contains(node)) continue;
                ++result;
            }
            return result;
        }
    }

    private static class ItemComparatorComparator
    implements Comparator<Comparator<SearchItem>> {
        ItemComparatorComparator() {
        }

        @Override
        public int compare(Comparator<SearchItem> o1, Comparator<SearchItem> o2) {
            return this.getRating(o1) - this.getRating(o2);
        }

        private int getRating(Comparator<SearchItem> comparator) {
            int result = 0;
            Class<?> compClass = comparator.getClass();
            if (compClass == ItemTypeComparator.class) {
                return result;
            }
            ++result;
            if (compClass == ConnectedPartsComparator.class) {
                return result;
            }
            ++result;
            if (compClass == LayerComparator.class) {
                return result;
            }
            throw new IllegalArgumentException(String.format("Unknown comparator class %s", compClass));
        }
    }

    private static class ItemTypeComparator
    implements Comparator<SearchItem> {
        private ItemTypeComparator() {
        }

        @Override
        public int compare(SearchItem o1, SearchItem o2) {
            return this.getRating(o1) - this.getRating(o2);
        }

        int getRating(SearchItem item) {
            int result = 0;
            Class<?> itemClass = item.getClass();
            if (itemClass == NegatedSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == PatternNodeSearchItem.class) {
                return result;
            }
            ++result;
            if (itemClass == PatternEdgeSearchItem.class) {
                return result;
            }
            throw new IllegalArgumentException(String.format("Unrecognised search item %s", item));
        }
    }

    private static class LayerComparator
    implements Comparator<SearchItem> {
        LayerComparator() {
        }

        @Override
        public int compare(SearchItem item1, SearchItem item2) {
            if (item1 instanceof NegatedSearchItem) {
                item1 = ((NegatedSearchItem)item1).inner1;
            }
            if (item2 instanceof NegatedSearchItem) {
                item2 = ((NegatedSearchItem)item2).inner1;
            }
            RuleNode node1 = null;
            RuleNode node2 = null;
            if (item1 instanceof PatternNodeSearchItem) {
                node1 = ((PatternNodeSearchItem)item1).getNode();
            } else if (item1 instanceof PatternEdgeSearchItem) {
                node1 = (RuleNode)((PatternEdgeSearchItem)item1).getEdge().target();
            }
            if (item2 instanceof PatternNodeSearchItem) {
                node2 = ((PatternNodeSearchItem)item2).getNode();
            } else if (item2 instanceof PatternEdgeSearchItem) {
                node2 = (RuleNode)((PatternEdgeSearchItem)item2).getEdge().target();
            }
            assert (node1 != null && node2 != null);
            return node1.getLayer() - node2.getLayer();
        }
    }

    private static final class PlanData
    implements Comparator<SearchItem> {
        private final PatternRule pRule;
        private final Set<RuleNode> remainingNodes;
        private final Set<RuleEdge> remainingEdges;
        private final Collection<Comparator<SearchItem>> comparators;

        PlanData(PatternRule pRule) {
            this.pRule = pRule;
            PatternRuleGraph lhs = this.pRule.lhs();
            this.remainingNodes = new LinkedHashSet(lhs.nodeSet());
            this.remainingEdges = new LinkedHashSet<RuleEdge>(lhs.edgeSet());
            this.comparators = this.computeComparators();
        }

        List<SearchItem> getPlanItems() {
            ArrayList<SearchItem> result = new ArrayList<SearchItem>();
            Collection<SearchItem> items = this.computeSearchItems();
            while (!items.isEmpty()) {
                SearchItem bestItem = Collections.max(items, this);
                result.add(bestItem);
                this.remainingEdges.removeAll(bestItem.bindsEdges());
                this.remainingNodes.removeAll(bestItem.bindsNodes());
                items.remove(bestItem);
            }
            return result;
        }

        Collection<Comparator<SearchItem>> computeComparators() {
            TreeSet<Comparator<SearchItem>> result = new TreeSet<Comparator<SearchItem>>(new ItemComparatorComparator());
            result.add(new ItemTypeComparator());
            result.add(new ConnectedPartsComparator(this.remainingNodes));
            result.add(new LayerComparator());
            return result;
        }

        @Override
        public int compare(SearchItem o1, SearchItem o2) {
            int result = 0;
            Iterator<Comparator<SearchItem>> comparatorIter = this.comparators.iterator();
            while (result == 0 && comparatorIter.hasNext()) {
                Comparator<SearchItem> next = comparatorIter.next();
                result = next.compare(o1, o2);
            }
            if (result == 0) {
                result = o1.compareTo(o2);
            }
            return result;
        }

        Collection<SearchItem> computeSearchItems() {
            ArrayList<SearchItem> result = new ArrayList<SearchItem>();
            LinkedHashSet<RuleNode> unmatchedNodes = new LinkedHashSet<RuleNode>(this.remainingNodes);
            for (RuleEdge edge : this.remainingEdges) {
                SearchItem edgeItem = this.createEdgeSearchItem(edge);
                result.add(edgeItem);
                unmatchedNodes.removeAll(edgeItem.bindsNodes());
            }
            for (RuleNode node : unmatchedNodes) {
                SearchItem nodeItem = this.createNodeSearchItem(node);
                result.add(nodeItem);
            }
            if (this.pRule.isClosure()) {
                RuleEdge[] edges = this.pRule.getCreatorEdges();
                SearchItem negatedEdge = this.createNegatedSearchItem(edges[0], edges[1]);
                result.add(negatedEdge);
            }
            return result;
        }

        SearchItem createNodeSearchItem(RuleNode node) {
            return new PatternNodeSearchItem(node);
        }

        SearchItem createEdgeSearchItem(RuleEdge edge) {
            return new PatternEdgeSearchItem(edge);
        }

        SearchItem createNegatedSearchItem(RuleEdge edge1, RuleEdge edge2) {
            return new NegatedSearchItem(edge1, edge2);
        }
    }
}

