/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.Util;
import groove.abstraction.pattern.shape.AbstractPatternEdge;
import groove.abstraction.pattern.shape.AbstractPatternNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.graph.AEdge;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.NodeSetEdgeSetGraph;
import groove.util.Duo;
import groove.util.Pair;
import groove.util.collect.UnmodifiableSetView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class AbstractPatternGraph<N extends AbstractPatternNode, E extends AbstractPatternEdge<N>>
extends NodeSetEdgeSetGraph<N, E> {
    protected int depth = 0;
    protected final List<Set<N>> layers = new ArrayList<Set<N>>();

    protected AbstractPatternGraph(String name) {
        super(name);
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.PATTERN;
    }

    @Override
    public Set<N> nodeSet() {
        return super.nodeSet();
    }

    @Override
    public Set<E> edgeSet() {
        return super.edgeSet();
    }

    @Override
    public Set<E> edgeSet(Node node) {
        return super.edgeSet(node);
    }

    @Override
    public Set<E> outEdgeSet(Node node) {
        return super.outEdgeSet(node);
    }

    @Override
    public Set<E> inEdgeSet(Node node) {
        return super.inEdgeSet(node);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pattern graph: " + this.getName() + " (depth = " + this.depth() + ")\n");
        sb.append("Nodes: [");
        for (AbstractPatternNode node : this.nodeSet()) {
            sb.append(String.valueOf(node.toString()) + ", ");
        }
        if (this.nodeSet().isEmpty()) {
            sb.append("]\n");
        } else {
            sb.replace(sb.length() - 2, sb.length(), "]\n");
        }
        sb.append("Edges: [");
        for (AbstractPatternEdge edge : this.edgeSet()) {
            sb.append(String.valueOf(edge.toString()) + ", ");
        }
        if (this.edgeSet().isEmpty()) {
            sb.append("]\n");
        } else {
            sb.replace(sb.length() - 2, sb.length(), "]\n");
        }
        return sb.toString();
    }

    @Override
    public boolean addNode(N node) {
        boolean result = super.addNode(node);
        if (result) {
            this.addToLayer(node);
        }
        return result;
    }

    @Override
    public boolean removeNodeContext(N node) {
        boolean result = super.removeNodeContext(node);
        if (result) {
            this.removeFromLayer(node);
        }
        return result;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.getInfo().setFixed();
            super.setFixed();
        }
        return result;
    }

    public boolean isWellDefined() {
        return this.isWellFormed();
    }

    public boolean isWellFormed() {
        for (AbstractPatternNode pNode : this.getLayerNodes(0)) {
            HostGraph pattern = pNode.getPattern();
            if (pattern.nodeCount() == 1 && Util.getBinaryEdgesCount(pattern) == 0) continue;
            return false;
        }
        int i = 1;
        while (i <= this.depth) {
            for (AbstractPatternNode pNode : this.getLayerNodes(i)) {
                HostGraph pattern = pNode.getPattern();
                if (Util.getBinaryEdgesCount(pattern) != i) {
                    return false;
                }
                if (this.isCovered(pNode)) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isCommuting() {
        for (AbstractPatternNode pNode : this.getLayerNodes(1)) {
            AbstractPatternNode pTgt;
            if (pNode.getSimpleEdge().isLoop()) continue;
            HostNode sSrc = pNode.getSource();
            HostNode sTgt = pNode.getTarget();
            AbstractPatternNode pSrc = (AbstractPatternNode)((AEdge)this.getCoveringEdge(pNode, sSrc)).source();
            if (!pSrc.equals(pTgt = (AbstractPatternNode)((AEdge)this.getCoveringEdge(pNode, sTgt)).source())) continue;
            return false;
        }
        int layer = 2;
        while (layer <= this.depth()) {
            for (AbstractPatternNode pNode : this.getLayerNodes(layer)) {
                for (HostNode sNode : pNode.getPattern().nodeSet()) {
                    if (this.hasCommonAncestor(pNode, sNode)) continue;
                    return false;
                }
                for (HostEdge sEdge : pNode.getPattern().edgeSet()) {
                    if (this.hasCommonAncestor(pNode, sEdge)) continue;
                    return false;
                }
            }
            ++layer;
        }
        return true;
    }

    public int depth() {
        return this.depth;
    }

    public Set<N> getLayerNodes(int layer) {
        assert (layer >= 0);
        if (layer >= this.layers.size()) {
            int i = this.layers.size();
            while (i <= layer) {
                this.layers.add(i, new MyHashSet());
                ++i;
            }
        }
        return this.layers.get(layer);
    }

    public Set<E> getLayerInEdges(int layer) {
        MyHashSet result = new MyHashSet();
        for (AbstractPatternNode pNode : this.getLayerNodes(layer)) {
            result.addAll(this.inEdgeSet(pNode));
        }
        return result;
    }

    public Set<E> getLayerOutEdges(int layer) {
        MyHashSet result = new MyHashSet();
        for (AbstractPatternNode pNode : this.getLayerNodes(layer)) {
            result.addAll(this.outEdgeSet(pNode));
        }
        return result;
    }

    private boolean isCovered(N pNode) {
        HostGraph pattern = ((AbstractPatternNode)pNode).getPattern();
        Set<HostEdge> sEdges = ((AbstractPatternNode)pNode).getLayer() == 1 ? null : Util.getBinaryEdges(pattern);
        return this.isCovered(pNode, pattern.nodeSet(), sEdges);
    }

    private boolean isCovered(N pNode, Set<HostNode> sNodes, Set<HostEdge> sEdges) {
        MyHashSet nodes = new MyHashSet();
        nodes.addAll(sNodes);
        MyHashSet edges = new MyHashSet();
        if (sEdges != null) {
            edges.addAll(sEdges);
        }
        for (AbstractPatternEdge pEdge : this.inEdgeSet((Node)pNode)) {
            for (HostNode sNode : sNodes) {
                if (!pEdge.isCod(sNode)) continue;
                nodes.remove(sNode);
            }
            if (sEdges == null) continue;
            for (HostEdge sEdge : sEdges) {
                if (!pEdge.isCod(sEdge.source()) || !pEdge.isCod(sEdge.target())) continue;
                edges.remove(sEdge);
            }
        }
        return nodes.isEmpty() && edges.isEmpty();
    }

    final void addToLayer(N pNode) {
        int layer = ((AbstractPatternNode)pNode).getLayer();
        this.getLayerNodes(layer).add(pNode);
        if (this.depth < layer) {
            this.depth = layer;
        }
    }

    private void removeFromLayer(N pNode) {
        int layer = ((AbstractPatternNode)pNode).getLayer();
        this.getLayerNodes(layer).remove(pNode);
        if (this.depth == layer) {
            while (this.getLayerNodes(layer).isEmpty() && layer >= 0) {
                --layer;
            }
            this.depth = layer;
        }
    }

    private Set<E> getCoveringEdges(N pNode, final HostNode sNode) {
        return new UnmodifiableSetView<E>(this.inEdgeSet((Node)pNode)){

            @Override
            public boolean approves(Object obj) {
                if (!(obj instanceof AbstractPatternEdge)) {
                    return false;
                }
                AbstractPatternEdge pEdge = (AbstractPatternEdge)obj;
                return pEdge.isCod(sNode);
            }
        };
    }

    private Set<E> getCoveringEdges(N pNode, final HostEdge sNode) {
        return new UnmodifiableSetView<E>(this.inEdgeSet((Node)pNode)){

            @Override
            public boolean approves(Object obj) {
                if (!(obj instanceof AbstractPatternEdge)) {
                    return false;
                }
                AbstractPatternEdge pEdge = (AbstractPatternEdge)obj;
                return pEdge.isCod(sNode);
            }
        };
    }

    public E getCoveringEdge(N pNode, HostNode sNode) {
        assert (((AbstractPatternNode)pNode).isEdgePattern());
        for (AbstractPatternEdge pEdge : this.inEdgeSet((Node)pNode)) {
            if (!pEdge.isCod(sNode)) continue;
            return (E)pEdge;
        }
        return null;
    }

    private boolean hasCommonAncestor(N pNode, HostNode sNode) {
        return this.getAncestors(pNode, sNode).size() == 1;
    }

    public Set<N> getAncestors(N pNode, HostNode sNode) {
        MyHashSet result = new MyHashSet();
        LinkedList<Pair<AbstractPatternNode, HostNode>> queue = new LinkedList<Pair<AbstractPatternNode, HostNode>>();
        Set<E> coveringEdges = this.getCoveringEdges(pNode, sNode);
        for (AbstractPatternEdge pEdge : coveringEdges) {
            AbstractPatternNode pN = (AbstractPatternNode)pEdge.source();
            if (pN.getLayer() == 0) {
                result.add(pN);
                continue;
            }
            HostNode sN = pEdge.getPreImage(sNode);
            queue.add(new Pair<AbstractPatternNode, HostNode>(pN, sN));
        }
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.remove(0);
            AbstractPatternNode pN = (AbstractPatternNode)pair.one();
            HostNode sN = (HostNode)pair.two();
            coveringEdges = this.getCoveringEdges(pN, sN);
            for (AbstractPatternEdge pEdge : coveringEdges) {
                AbstractPatternNode newPN = (AbstractPatternNode)pEdge.source();
                if (newPN.getLayer() == 0) {
                    result.add(newPN);
                    continue;
                }
                HostNode newSN = pEdge.getPreImage(sN);
                Pair<AbstractPatternNode, HostNode> newPair = new Pair<AbstractPatternNode, HostNode>(newPN, newSN);
                if (queue.contains(newPair)) continue;
                queue.add(newPair);
            }
        }
        return result;
    }

    private boolean hasCommonAncestor(N pNode, HostEdge sEdge) {
        if (sEdge.getRole() != EdgeRole.BINARY) {
            return true;
        }
        return this.getAncestors(pNode, sEdge).size() == 1;
    }

    public Set<N> getAncestors(N pNode, HostEdge sEdge) {
        MyHashSet result = new MyHashSet();
        LinkedList<Pair<AbstractPatternNode, HostEdge>> queue = new LinkedList<Pair<AbstractPatternNode, HostEdge>>();
        Set<E> coveringEdges = this.getCoveringEdges(pNode, sEdge);
        for (AbstractPatternEdge pEdge : coveringEdges) {
            AbstractPatternNode pN = (AbstractPatternNode)pEdge.source();
            HostEdge sE = pEdge.getPreImage(sEdge);
            if (pN.getLayer() == 1 && pN.introduces(sE)) {
                result.add(pN);
                continue;
            }
            queue.add(new Pair<AbstractPatternNode, HostEdge>(pN, sE));
        }
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.remove(0);
            AbstractPatternNode pN = (AbstractPatternNode)pair.one();
            HostEdge sE = (HostEdge)pair.two();
            coveringEdges = this.getCoveringEdges(pN, sE);
            for (AbstractPatternEdge pEdge : coveringEdges) {
                AbstractPatternNode newPN = (AbstractPatternNode)pEdge.source();
                HostEdge newSE = pEdge.getPreImage(sE);
                if (newPN.getLayer() == 1 && newPN.introduces(newSE)) {
                    result.add(newPN);
                    continue;
                }
                Pair<AbstractPatternNode, HostEdge> newPair = new Pair<AbstractPatternNode, HostEdge>(newPN, newSE);
                if (queue.contains(newPair)) continue;
                queue.add(newPair);
            }
        }
        return result;
    }

    public SortedSet<N> getDownwardTraversal(List<N> toTraverse) {
        TreeSet<AbstractPatternNode> result = new TreeSet<AbstractPatternNode>(AbstractPatternNode.comparator);
        while (!toTraverse.isEmpty()) {
            AbstractPatternNode node = (AbstractPatternNode)toTraverse.remove(toTraverse.size() - 1);
            if (result.contains(node)) continue;
            for (AbstractPatternEdge edge : this.outEdgeSet(node)) {
                toTraverse.add((AbstractPatternNode)edge.target());
            }
            result.add(node);
        }
        return result;
    }

    public SortedSet<N> getDownwardTraversal(N node) {
        LinkedList<N> toTraverse = new LinkedList<N>();
        toTraverse.add(node);
        return this.getDownwardTraversal((N)toTraverse);
    }

    public Set<N> getEdgeLayerAncestors(N node) {
        assert (((AbstractPatternNode)node).getLayer() > 1);
        MyHashSet result = new MyHashSet();
        LinkedList<E> toTraverse = new LinkedList<E>();
        toTraverse.addAll(this.inEdgeSet((Node)node));
        while (!toTraverse.isEmpty()) {
            AbstractPatternEdge edge = (AbstractPatternEdge)toTraverse.remove(0);
            AbstractPatternNode source = (AbstractPatternNode)edge.source();
            if (source.getLayer() == 1) {
                result.add(source);
                continue;
            }
            toTraverse.addAll(this.inEdgeSet(source));
        }
        return result;
    }

    public Duo<E> getIncomingEdges(N node) {
        Iterator<E> iter = this.inEdgeSet((Node)node).iterator();
        AbstractPatternEdge d1 = (AbstractPatternEdge)iter.next();
        AbstractPatternEdge d2 = iter.hasNext() ? (AbstractPatternEdge)iter.next() : d1;
        assert (!iter.hasNext());
        return new Duo<AbstractPatternEdge>(d1, d2);
    }

    @Override
    protected E createEdge(N source, Label label, N target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public N addNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E addEdge(N source, String label, N target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E addEdge(N source, Label label, N target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addNodeSet(Collection<? extends N> nodeSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdgeSetContext(Collection<? extends E> edgeSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeEdgeSet(Collection<? extends E> edgeSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mergeNodes(N from, N to) {
        throw new UnsupportedOperationException();
    }
}

