/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.pattern.shape.AbstractPatternEdge;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.SimpleMorphism;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.graph.plain.PlainLabel;

public final class PatternEdge
extends AbstractPatternEdge<PatternNode> {
    private static final String PREFIX = "d";
    private final TypeEdge type;

    public PatternEdge(int nr, PatternNode source, PatternNode target, TypeEdge type) {
        super(nr, source, (PlainLabel)type.label(), target);
        this.type = type;
    }

    @Override
    public boolean setFixed() {
        assert (this.type.isFixed());
        return false;
    }

    @Override
    public boolean isFixed() {
        return this.type.isFixed();
    }

    @Override
    protected String getToStringPrefix() {
        return PREFIX;
    }

    @Override
    public String toString() {
        return String.valueOf(((PatternNode)this.source).getIdStr()) + "--" + this.getPrintableLabel() + "-->" + ((PatternNode)this.target).getIdStr();
    }

    @Override
    public SimpleMorphism getMorphism() {
        return this.getType().getMorphism();
    }

    @Override
    public String getPrintableLabel() {
        return String.valueOf(this.getIdStr()) + ":" + this.type.getIdStr();
    }

    public TypeEdge getType() {
        return this.type;
    }
}

