/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeNode;
import java.util.Map;
import java.util.Set;

public final class PatternEquivRel {
    private final PatternShape pShape;
    private final Map<PatternNode, NodeEquivClass> nodeToCellMap;
    private final Map<PatternEdge, AuxEdgeEquivClass> edgeToCellMap;
    private final Set<NodeEquivClass> nodeRel;
    private final Set<EdgeEquivClass> edgeRel;
    private final Map<NodeInfo, NodeEquivClass> nodePartition;
    private final Map<EdgeInfo, AuxEdgeEquivClass> edgePartition;

    public PatternEquivRel(PatternShape pShape) {
        this.pShape = pShape;
        this.nodeToCellMap = new MyHashMap<PatternNode, NodeEquivClass>();
        this.edgeToCellMap = new MyHashMap<PatternEdge, AuxEdgeEquivClass>();
        this.nodePartition = new MyHashMap<NodeInfo, NodeEquivClass>();
        this.edgePartition = new MyHashMap<EdgeInfo, AuxEdgeEquivClass>();
        this.nodeRel = new MyHashSet<NodeEquivClass>();
        this.edgeRel = new MyHashSet<EdgeEquivClass>();
        this.compute();
    }

    public String toString() {
        return String.format("Pattern equivalence relation:\nNodes: %s\nEdges:%s", this.nodeRel, this.edgeRel);
    }

    private void compute() {
        int i = this.pShape.depth;
        while (i >= 0) {
            this.computeNodeEquiv(i);
            this.computeEdgeEquiv(i);
            --i;
        }
    }

    private void computeNodeEquiv(int layer) {
        this.nodePartition.clear();
        for (PatternNode pNode : this.pShape.getLayerNodes(layer)) {
            NodeInfo nInfo = this.computeNodeInfo(pNode);
            NodeEquivClass nEc = this.nodePartition.get(nInfo);
            if (nEc == null) {
                nEc = new NodeEquivClass();
                this.nodePartition.put(nInfo, nEc);
                this.edgeRel.addAll(this.computeFinerEdgeRel(nInfo, nEc, pNode));
            }
            nEc.add(pNode);
            this.nodeToCellMap.put(pNode, nEc);
        }
        this.nodeRel.addAll(this.nodePartition.values());
    }

    private void computeEdgeEquiv(int layer) {
        this.edgePartition.clear();
        for (PatternEdge pEdge : this.pShape.getLayerInEdges(layer)) {
            EdgeInfo eInfo = this.computeEdgeInfo(pEdge);
            AuxEdgeEquivClass eEc = this.edgePartition.get(eInfo);
            if (eEc == null) {
                eEc = new AuxEdgeEquivClass();
                this.edgePartition.put(eInfo, eEc);
            }
            eEc.add(pEdge);
            this.edgeToCellMap.put(pEdge, eEc);
        }
    }

    private NodeInfo computeNodeInfo(PatternNode pNode) {
        NodeInfo nInfo = new NodeInfo(pNode);
        for (PatternEdge pEdge : this.pShape.outEdgeSet(pNode)) {
            AuxEdgeEquivClass eEc = this.edgeToCellMap.get(pEdge);
            assert (eEc != null);
            if (nInfo.containsKey(eEc)) continue;
            nInfo.add(eEc, pNode);
        }
        return nInfo;
    }

    private Set<EdgeEquivClass> computeFinerEdgeRel(NodeInfo nInfo, NodeEquivClass sourceEc, PatternNode pNode) {
        MyHashSet<EdgeEquivClass> result = new MyHashSet<EdgeEquivClass>();
        for (Map.Entry entry : nInfo.entrySet()) {
            PatternEdge pEdge = (PatternEdge)((AuxEdgeEquivClass)entry.getKey()).iterator().next();
            NodeEquivClass targetEc = this.nodeToCellMap.get(pEdge.target());
            Multiplicity mult = (Multiplicity)entry.getValue();
            EdgeEquivClass eEc = new EdgeEquivClass(sourceEc, pEdge.getType(), targetEc, mult);
            result.add(eEc);
        }
        return result;
    }

    private EdgeInfo computeEdgeInfo(PatternEdge pEdge) {
        EdgeInfo eInfo = new EdgeInfo(pEdge);
        return eInfo;
    }

    public Set<NodeEquivClass> getNodeEquivRel() {
        return this.nodeRel;
    }

    public Set<EdgeEquivClass> getEdgeEquivRel() {
        return this.edgeRel;
    }

    private static class AuxEdgeEquivClass
    extends MyHashSet<PatternEdge> {
        private AuxEdgeEquivClass() {
        }
    }

    public static class EdgeEquivClass {
        final NodeEquivClass sourceEc;
        final NodeEquivClass targetEc;
        final TypeEdge typeEdge;
        final Multiplicity mult;

        EdgeEquivClass(NodeEquivClass sourceEc, TypeEdge typeEdge, NodeEquivClass targetEc, Multiplicity mult) {
            this.sourceEc = sourceEc;
            this.targetEc = targetEc;
            this.typeEdge = typeEdge;
            this.mult = mult;
        }

        public String toString() {
            return String.format("%s--%s-->%s", this.sourceEc, this.mult, this.targetEc);
        }
    }

    private class EdgeInfo {
        final TypeEdge typeEdge;
        final NodeEquivClass targetEc;
        int hashCode;

        EdgeInfo(PatternEdge pEdge) {
            this.typeEdge = pEdge.getType();
            this.targetEc = (NodeEquivClass)PatternEquivRel.this.nodeToCellMap.get(pEdge.target());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 1;
                result = 31 * result + this.typeEdge.hashCode();
                this.hashCode = result = 31 * result + this.targetEc.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return this.hashCode() == other.hashCode();
        }

        public String toString() {
            return String.format("Edge info: (%d, %s, %s)", this.hashCode, this.typeEdge, this.targetEc);
        }
    }

    public class NodeEquivClass
    extends MyHashSet<PatternNode> {
        public Multiplicity getMult() {
            Multiplicity result = Multiplicity.ZERO_NODE_MULT;
            for (PatternNode pNode : this) {
                result = result.add(PatternEquivRel.this.pShape.getMult(pNode));
            }
            return result;
        }
    }

    private class NodeInfo
    extends MyHashMap<AuxEdgeEquivClass, Multiplicity> {
        final TypeNode typeNode;
        int hashCode;

        NodeInfo(PatternNode pNode) {
            this.typeNode = pNode.getType();
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 1;
                result = 31 * result + super.hashCode();
                this.hashCode = result = 31 * result + this.typeNode.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public boolean equals(Object other) {
            return this.hashCode() == other.hashCode();
        }

        void add(AuxEdgeEquivClass eEc, PatternNode pNode) {
            assert (this.get(eEc) == null);
            Multiplicity mult = Multiplicity.ZERO_EDGE_MULT;
            PatternShape pShape = PatternEquivRel.this.pShape;
            for (PatternEdge pEdge : eEc) {
                if (!pShape.outEdgeSet(pNode).contains(pEdge)) continue;
                mult = mult.add(pShape.getMult(pEdge));
            }
            this.put(eEc, mult);
        }

        @Override
        public String toString() {
            return String.format("Node info: (%d, %s, %s)", this.hashCode, this.typeNode, super.toString());
        }
    }
}

