/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.MyHashMap;
import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.shape.AbstractPatternGraph;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternFactory;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeGraph;
import groove.abstraction.pattern.shape.TypeNode;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.graph.Edge;
import groove.graph.Node;
import groove.util.Duo;
import groove.util.Pair;
import groove.util.collect.UnmodifiableSetView;
import java.util.Set;

public class PatternGraph
extends AbstractPatternGraph<PatternNode, PatternEdge> {
    private final TypeGraph type;
    private final PatternFactory factory;

    private PatternGraph(String name, TypeGraph type, PatternFactory factory) {
        super(name);
        this.type = type;
        this.factory = factory;
    }

    PatternGraph(String name, TypeGraph type) {
        super(name);
        this.type = type;
        this.factory = type.getPatternFactory();
    }

    PatternGraph(TypeGraph type, PatternFactory factory) {
        this("", type, factory);
    }

    protected PatternGraph(PatternGraph pGraph) {
        this(pGraph.getName(), pGraph.getTypeGraph());
        this.depth = pGraph.depth;
        for (PatternNode pNode : pGraph.nodeSet()) {
            this.addNode(pNode);
        }
        for (PatternEdge pEdge : pGraph.edgeSet()) {
            this.addEdgeContext(pEdge);
        }
    }

    @Override
    protected boolean isTypeCorrect(Node node) {
        return node instanceof PatternNode;
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        return edge instanceof PatternEdge;
    }

    public PatternFactory getFactory() {
        return this.factory;
    }

    @Override
    public PatternGraph clone() {
        return new PatternGraph(this);
    }

    public TypeGraph getTypeGraph() {
        return this.type;
    }

    public HostGraph flatten() {
        assert (this.isCommuting());
        DefaultHostGraph result = new DefaultHostGraph(this.getName());
        MyHashMap<PatternNode, HostNode> nodeMap = new MyHashMap<PatternNode, HostNode>();
        for (PatternNode pNode : this.getLayerNodes(0)) {
            HostNode sNode = (HostNode)result.addNode();
            nodeMap.put(pNode, sNode);
            for (HostEdge sEdge : pNode.getPattern().edgeSet()) {
                result.addEdge(sNode, sEdge.label(), sNode);
            }
        }
        for (PatternNode pNode : this.getLayerNodes(1)) {
            HostEdge sEdge = pNode.getSimpleEdge();
            HostNode sSrc = (HostNode)nodeMap.get(((PatternEdge)this.getCoveringEdge(pNode, sEdge.source())).source());
            HostNode sTgt = (HostNode)nodeMap.get(((PatternEdge)this.getCoveringEdge(pNode, sEdge.target())).source());
            result.addEdge(sSrc, sEdge.label(), sTgt);
        }
        return result;
    }

    public PatternNode createNode(TypeNode type) {
        return this.getFactory().createNode(type, this.nodeSet());
    }

    public PatternEdge createEdge(PatternNode source, TypeEdge type, PatternNode target) {
        return this.getFactory().createEdge(source, type, target);
    }

    public Set<PatternEdge> getInEdgesWithType(PatternNode node, final TypeEdge edgeType) {
        return new UnmodifiableSetView<PatternEdge>(this.inEdgeSet(node)){

            @Override
            public boolean approves(Object obj) {
                if (!(obj instanceof PatternEdge)) {
                    return false;
                }
                PatternEdge pEdge = (PatternEdge)obj;
                return pEdge.getType() == edgeType;
            }
        };
    }

    public boolean hasInEdgeWithType(PatternNode node, TypeEdge edgeType) {
        return this.getInEdgesWithType(node, edgeType).size() > 0;
    }

    public Set<TypeEdge> getIncomingEdgeTypes(PatternNode pNode) {
        return this.getTypeGraph().inEdgeSet(pNode.getType());
    }

    public Duo<TypeEdge> getDuoIncomingEdgeTypes(PatternNode pNode) {
        return this.getTypeGraph().getIncomingEdges(pNode.getType());
    }

    public boolean isUniquelyCovered(PatternNode node) {
        for (TypeEdge edgeType : this.getTypeGraph().inEdgeSet(node.getType())) {
            if (this.getInEdgesWithType(node, edgeType).size() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean deletePattern(PatternNode node) {
        if (!this.containsNode(node)) {
            return false;
        }
        for (PatternNode delNode : this.getDownwardTraversal(node)) {
            assert (this.isUniquelyCovered(delNode));
            this.removeNodeContext(delNode);
        }
        return true;
    }

    public PatternNode addNodePattern(TypeNode tNode) {
        assert (tNode.isNodePattern());
        PatternNode pNode = this.createNode(tNode);
        this.addNode(pNode);
        return pNode;
    }

    public Pair<PatternNode, Duo<PatternEdge>> addEdgePattern(TypeEdge m1, TypeEdge m2, PatternNode p1, PatternNode p2) {
        assert (p1.isNodePattern() && p2.isNodePattern());
        return this.addPattern(m1, m2, p1, p2);
    }

    public void prepareClosure(Match match) {
    }

    public Pair<PatternNode, Duo<PatternEdge>> closePattern(TypeEdge m1, TypeEdge m2, PatternNode p1, PatternNode p2) {
        assert (this.isUniquelyCovered(p1) && this.isUniquelyCovered(p2));
        return this.addPattern(m1, m2, p1, p2);
    }

    private Pair<PatternNode, Duo<PatternEdge>> addPattern(TypeEdge m1, TypeEdge m2, PatternNode p1, PatternNode p2) {
        assert (this.containsNode(p1) && this.containsNode(p2));
        assert (((TypeNode)m1.target()).equals(m2.target()));
        assert (((TypeNode)m1.source()).equals(p1.getType()));
        assert (((TypeNode)m2.source()).equals(p2.getType()));
        TypeNode tNode = (TypeNode)m1.target();
        PatternNode pNode = this.createNode(tNode);
        this.addNode(pNode);
        PatternEdge d1 = this.createEdge(p1, m1, pNode);
        PatternEdge d2 = this.createEdge(p2, m2, pNode);
        this.addEdgeContext(d1);
        this.addEdgeContext(d2);
        Duo<PatternEdge> duo = new Duo<PatternEdge>(d1, d2);
        return new Pair<PatternNode, Duo<PatternEdge>>(pNode, duo);
    }
}

