/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.Precedence;
import groove.algebra.Signature;
import groove.algebra.SignatureKind;
import groove.annotation.InfixSymbol;
import groove.annotation.PrefixSymbol;
import groove.annotation.Syntax;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipHeader;

public abstract class BoolSignature<Bool>
implements Signature {
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    @ToolTipHeader(value="Inversion")
    @Syntax(value="Q%s.LPAR.b1.RPAR")
    @ToolTipBody(value={"Yields TRUE if boolean %s is FALSE"})
    @PrefixSymbol(symbol="!")
    public abstract Bool not(Bool var1);

    @ToolTipHeader(value="Conjunction")
    @Syntax(value="Q%s.LPAR.b1.COMMA.b2.RPAR")
    @ToolTipBody(value={"Yields TRUE if booleans %s and %s are both TRUE"})
    @InfixSymbol(symbol="&", precedence=Precedence.AND)
    public abstract Bool and(Bool var1, Bool var2);

    @ToolTipHeader(value="Disjunction")
    @Syntax(value="Q%s.LPAR.b1.COMMA.b2.RPAR")
    @ToolTipBody(value={"Yields TRUE if at least one of booleans %s and %s is TRUE"})
    @InfixSymbol(symbol="|", precedence=Precedence.OR)
    public abstract Bool or(Bool var1, Bool var2);

    @ToolTipHeader(value="Boolean equality test")
    @Syntax(value="Q%s.LPAR.b1.COMMA.b2.RPAR")
    @ToolTipBody(value={"Yields TRUE if boolean %s equals boolean %s"})
    @InfixSymbol(symbol="==", precedence=Precedence.EQUAL)
    public abstract Bool eq(Bool var1, Bool var2);

    @ToolTipHeader(value="Boolean inequality test")
    @Syntax(value="Q%s.LPAR.b1.COMMA.b2.RPAR")
    @ToolTipBody(value={"Yields TRUE if boolean %s is not equal to boolean %s"})
    @InfixSymbol(symbol="!=", precedence=Precedence.EQUAL)
    public abstract Bool neq(Bool var1, Bool var2);

    @Override
    public SignatureKind getKind() {
        return SignatureKind.BOOL;
    }

    @Override
    public final boolean isValue(String value) {
        return value.equals(TRUE) || value.equals(FALSE);
    }

    public final Bool getValueFromJava(Object constant) {
        if (!(constant instanceof Boolean)) {
            throw new IllegalArgumentException(String.format("Native int type is %s, not %s", Boolean.class.getSimpleName(), constant.getClass().getSimpleName()));
        }
        return this.toValue((Boolean)constant);
    }

    protected abstract Bool toValue(Boolean var1);
}

