/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.RegAut;
import groove.automaton.RegEdge;
import groove.automaton.RegExpr;
import groove.automaton.RegExprCalculator;
import groove.automaton.RegFactory;
import groove.automaton.RegNode;
import groove.automaton.SimpleNFA;
import groove.grammar.rule.RuleLabel;
import groove.grammar.type.ImplicitTypeGraph;
import groove.grammar.type.TypeGraph;
import groove.graph.Label;
import groove.util.DefaultDispenser;
import java.util.Iterator;
import java.util.List;

public class RegAutCalculator
implements RegExprCalculator<RegAut> {
    private final RegAut prototype;
    private TypeGraph typeGraph;
    private final DefaultDispenser nodeDispenser = new DefaultDispenser();

    public RegAutCalculator() {
        this(SimpleNFA.PROTOTYPE);
    }

    public RegAutCalculator(RegAut prototype) {
        this.prototype = prototype;
    }

    public RegAut compute(RegExpr expr) {
        return this.compute(expr, ImplicitTypeGraph.newInstance(expr.getTypeLabels()));
    }

    public RegAut compute(RegExpr expr, TypeGraph typeGraph) {
        this.nodeDispenser.reset();
        this.typeGraph = typeGraph;
        RegAut result = expr.apply(this);
        result.setFixed();
        return result;
    }

    @Override
    public RegAut computeNeg(RegExpr.Neg expr, RegAut arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegAut computeStar(RegExpr.Star expr, RegAut arg) {
        RegAut result = this.computePlus((RegExpr.Plus)null, arg);
        result.setAcceptsEmptyWord(true);
        return result;
    }

    @Override
    public RegAut computePlus(RegExpr.Plus expr, RegAut result) {
        RegNode newNode = this.createNode();
        result.addNode(newNode);
        for (RegEdge finalEdge : result.inEdgeSet(result.getEndNode())) {
            result.addEdge((RegNode)finalEdge.source(), (Label)finalEdge.label(), newNode);
        }
        for (RegEdge initEdge : result.outEdgeSet(result.getStartNode())) {
            result.addEdge(newNode, (Label)initEdge.label(), (RegNode)initEdge.target());
        }
        return result;
    }

    @Override
    public RegAut computeInv(RegExpr.Inv expr, RegAut arg) {
        RegAut result = this.createAutomaton();
        for (RegEdge edge : arg.edgeSet()) {
            RuleLabel label = this.invert((RuleLabel)edge.label());
            RegNode source = (RegNode)edge.source();
            RegNode target = (RegNode)edge.target();
            result.addNode(source);
            result.addNode(target);
            result.addEdge(target, label, source);
        }
        result.mergeNodes(arg.getEndNode(), result.getStartNode());
        result.mergeNodes(arg.getStartNode(), result.getEndNode());
        result.setAcceptsEmptyWord(arg.isAcceptsEmptyWord());
        return result;
    }

    @Override
    public RegAut computeSeq(RegExpr.Seq expr, List<RegAut> argList) {
        Iterator<RegAut> argIter = argList.iterator();
        RegAut result = argIter.next();
        while (argIter.hasNext()) {
            RegAut next = argIter.next();
            result.addNodeSet(next.nodeSet());
            result.addEdgeSetContext(next.edgeSet());
            if (result.isAcceptsEmptyWord()) {
                for (RegEdge nextInitEdge : next.outEdgeSet(next.getStartNode())) {
                    RegNode target = (RegNode)nextInitEdge.target();
                    result.addNode(target);
                    result.addEdge(result.getStartNode(), (Label)nextInitEdge.label(), target);
                }
                result.setAcceptsEmptyWord(next.isAcceptsEmptyWord());
            }
            if (next.isAcceptsEmptyWord()) {
                for (RegEdge resultFinalEdge : result.inEdgeSet(result.getEndNode())) {
                    RegNode source = (RegNode)resultFinalEdge.source();
                    RegNode target = next.getEndNode();
                    result.addNode(source);
                    result.addNode(target);
                    result.addEdge(source, (Label)resultFinalEdge.label(), target);
                }
            }
            result.mergeNodes(result.getEndNode(), next.getStartNode());
            result.setEndNode(next.getEndNode());
        }
        return result;
    }

    @Override
    public RegAut computeChoice(RegExpr.Choice expr, List<RegAut> argList) {
        Iterator<RegAut> argIter = argList.iterator();
        RegAut result = argIter.next();
        while (argIter.hasNext()) {
            RegAut next = argIter.next();
            result.addNodeSet(next.nodeSet());
            result.addEdgeSetContext(next.edgeSet());
            result.mergeNodes(next.getStartNode(), result.getStartNode());
            result.mergeNodes(next.getEndNode(), result.getEndNode());
            if (!next.isAcceptsEmptyWord()) continue;
            result.setAcceptsEmptyWord(true);
        }
        return result;
    }

    @Override
    public RegAut computeAtom(RegExpr.Atom expr) {
        RegAut result = this.createAutomaton();
        if (!this.typeGraph.getTypes(expr.toTypeLabel()).isEmpty()) {
            result.addEdge(result.getStartNode(), expr.toLabel(), result.getEndNode());
        }
        return result;
    }

    @Override
    public RegAut computeSharp(RegExpr.Sharp expr) {
        RegAut result = this.createAutomaton();
        result.addEdge(result.getStartNode(), expr.toLabel(), result.getEndNode());
        return result;
    }

    @Override
    public RegAut computeWildcard(RegExpr.Wildcard expr) {
        RegAut result = this.createAutomaton();
        result.addEdge(result.getStartNode(), expr.toLabel(), result.getEndNode());
        return result;
    }

    @Override
    public RegAut computeEmpty(RegExpr.Empty expr) {
        RegAut result = this.createAutomaton();
        result.setAcceptsEmptyWord(true);
        return result;
    }

    protected RegAut createAutomaton() {
        return this.prototype.newAutomaton(this.createNode(), this.createNode(), this.typeGraph);
    }

    protected RuleLabel invert(RuleLabel label) {
        RuleLabel invLabel = label.getInvLabel();
        RuleLabel result = invLabel == null ? label.getMatchExpr().inv().toLabel() : invLabel;
        return result;
    }

    private RegNode createNode() {
        return RegFactory.instance().createNode(this.nodeDispenser.getNext());
    }
}

