/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.control.CtrlLabel;
import groove.control.CtrlTransition;
import groove.graph.Edge;
import groove.graph.EdgeComparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class CtrlGuard
extends TreeSet<CtrlTransition>
implements Comparable<CtrlGuard> {
    private static final EdgeComparator edgeComparator = EdgeComparator.instance();

    public CtrlGuard newGuard(Map<CtrlTransition, CtrlTransition> map) {
        CtrlGuard result = new CtrlGuard();
        for (CtrlTransition key : this) {
            CtrlTransition image;
            CtrlTransition ctrlTransition = image = map == null ? key : map.get(key);
            if (image == null) continue;
            result.add(image);
        }
        return result;
    }

    @Override
    public boolean add(CtrlTransition e) {
        assert (e != null);
        return super.add(e);
    }

    @Override
    public int compareTo(CtrlGuard o) {
        int result = this.size() - o.size();
        if (result == 0) {
            Iterator myIter = this.iterator();
            Iterator hisIter = o.iterator();
            while (result == 0 && myIter.hasNext()) {
                result = edgeComparator.compare((Edge)myIter.next(), (Edge)hisIter.next());
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CtrlGuard)) {
            return false;
        }
        CtrlGuard other = (CtrlGuard)obj;
        if (this.size() != other.size()) {
            return false;
        }
        HashSet<CtrlLabel> otherLabels = new HashSet<CtrlLabel>();
        for (CtrlTransition trans : other) {
            otherLabels.add((CtrlLabel)trans.label());
        }
        for (CtrlTransition trans : this) {
            if (otherLabels.contains(trans.label())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (CtrlTransition trans : this) {
            result += ((CtrlLabel)trans.label()).hashCode();
        }
        return result;
    }
}

