/*
 * Decompiled with CFR 0.152.
 */
package groove.control.parse;

import groove.annotation.Help;
import groove.grammar.model.FormatException;
import groove.io.FileType;
import groove.io.Util;
import groove.util.ExprParser;
import groove.util.Groove;
import groove.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.grammar.syntax.GrammarSyntaxLexer;
import org.antlr.works.grammar.syntax.GrammarSyntaxParser;

public class CtrlDoc {
    private boolean initialised;
    private final Map<String, String> tokenMap = new HashMap<String, String>();
    private final Map<String, List<Line>> nameToEntriesMap = new HashMap<String, List<Line>>();
    private final Map<Line, List<Line>> ruleToEntriesMap = new LinkedHashMap<Line, List<Line>>();
    private final Map<Line, String> toolTipMap = new HashMap<Line, String>();
    public static final String MULTI_PREFIX = "/**";
    public static final String MULTI_SUFFIX = "*/";
    public static final String SYNTAX_PATTERN = "@S ";
    public static final String HEADER_PATTERN = "@H ";
    public static final String BODY_PATTERN = "@B ";
    public static final String PARS_PATTERN = "@P ";
    public static final String CTRL_GRAMMAR_FILE = "groove/control/parse/Ctrl.g";

    public Map<?, ? extends List<?>> getItemTree() {
        if (!this.initialised) {
            this.init();
        }
        return this.ruleToEntriesMap;
    }

    public Map<?, String> getToolTipMap() {
        if (!this.initialised) {
            this.init();
        }
        return this.toolTipMap;
    }

    private void init() {
        String grammarText = this.readGrammarText();
        for (Map.Entry<ElementRule, ATEToken> nonterminal : this.getRules(grammarText).entrySet()) {
            this.processRule(nonterminal.getKey(), nonterminal.getValue());
        }
        this.initialised = true;
    }

    private String readGrammarText() {
        URL url = Groove.getResource(CTRL_GRAMMAR_FILE);
        String grammarText = "";
        try {
            if (FileType.JAR.getExtensionName().equals(url.getProtocol())) {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                JarFile zipFile = conn.getJarFile();
                InputStream in = ((ZipFile)zipFile).getInputStream(conn.getJarEntry());
                grammarText = Util.readInputStreamToString(in);
            } else {
                File file = new File(url.getFile());
                try {
                    grammarText = Util.readFileToString(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    grammarText = Util.readInputStreamToString(url.openStream());
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error while reading grammar file %s: %s", CTRL_GRAMMAR_FILE, e.getMessage()));
        }
        return grammarText;
    }

    private Map<ElementRule, ATEToken> getRules(String text) {
        LinkedHashMap<ElementRule, ATEToken> result = new LinkedHashMap<ElementRule, ATEToken>();
        GrammarSyntaxLexer lexer = new GrammarSyntaxLexer();
        lexer.tokenize(text);
        GrammarSyntaxParser parser = new GrammarSyntaxParser();
        List tokens = lexer.getTokens();
        parser.parse(tokens);
        for (ElementRule rule : parser.rules) {
            String content = this.getSymbol(rule, tokens);
            if (content != null) {
                this.tokenMap.put(rule.name, content);
            }
            ATEToken comment = null;
            int index = rule.start.index;
            if (index > 0) {
                ATEToken prev = (ATEToken)tokens.get(index - 1);
                if (prev.type == 4) {
                    comment = prev;
                }
            }
            result.put(rule, comment);
        }
        return result;
    }

    private void processRule(ElementRule rule, ATEToken comment) {
        ArrayList<Pair<String, Help>> content = new ArrayList<Pair<String, Help>>();
        Help currentHelp = null;
        List tokens = rule.getTokens();
        int i = 0;
        while (i < tokens.size()) {
            ATEToken aTEToken = (ATEToken)tokens.get(i);
            if (aTEToken.type == 3) {
                String par;
                String body;
                String header;
                String text = aTEToken.getAttribute();
                String syntax = this.getSuffix(text, SYNTAX_PATTERN);
                if (syntax != null) {
                    currentHelp = new Help(this.tokenMap);
                    int colonIx = syntax.indexOf(58);
                    if (colonIx >= 0) {
                        String ruleName = syntax.substring(0, colonIx);
                        syntax = syntax.substring(colonIx + 1);
                        content.add(Pair.newPair(ruleName, currentHelp));
                    } else {
                        content.add(Pair.newPair(rule.name, currentHelp));
                    }
                    currentHelp.setSyntax(syntax);
                }
                if ((header = this.getSuffix(text, HEADER_PATTERN)) != null) {
                    currentHelp.setHeader(header);
                }
                if ((body = this.getSuffix(text, BODY_PATTERN)) != null) {
                    currentHelp.addBody(body);
                }
                if ((par = this.getSuffix(text, PARS_PATTERN)) != null) {
                    currentHelp.addPar(par);
                }
            }
            ++i;
        }
        ArrayList<Line> entries = new ArrayList<Line>();
        for (Pair pair : content) {
            Line line = this.createLine((Help)pair.two());
            if (((String)pair.one()).equals(rule.name)) {
                entries.add(line);
                continue;
            }
            List<Line> otherEntries = this.nameToEntriesMap.get(pair.one());
            if (otherEntries == null) {
                throw new IllegalStateException(String.format("Reference to non-existent rule '%s' in comment line '%s'", pair.one(), ((Help)pair.two()).getItem()));
            }
            otherEntries.add(line);
        }
        if (!entries.isEmpty()) {
            Help help = this.extractRuleHelp(rule.name, comment);
            this.ruleToEntriesMap.put(this.createLine(help), entries);
            this.nameToEntriesMap.put(rule.name, entries);
        }
    }

    private Help extractRuleHelp(String name, ATEToken token) {
        Help result = new Help(this.tokenMap);
        result.setSyntax(Help.bf(Help.it(name)), false);
        if (token != null) {
            StringBuilder text = new StringBuilder(token.getAttribute());
            this.remove(text, MULTI_PREFIX);
            this.remove(text, MULTI_SUFFIX);
            String header = null;
            ArrayList<String> body = new ArrayList<String>();
            String[] stringArray = text.toString().split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String bodyPart;
                String line = stringArray[n2];
                if (header == null) {
                    header = this.getSuffix(line, HEADER_PATTERN);
                }
                if ((bodyPart = this.getSuffix(line, BODY_PATTERN)) != null) {
                    body.add(bodyPart);
                }
                ++n2;
            }
            if (header != null) {
                result.setHeader(header);
                result.setBody(body);
            }
        }
        return result;
    }

    private String getSymbol(ElementRule rule, List<ATEToken> tokens) {
        String result = null;
        int i = rule.start.index + 1;
        while (i < rule.end.index) {
            ATEToken token = tokens.get(i);
            if (token.type == 1) {
                try {
                    result = ExprParser.toUnquoted(token.getAttribute(), '\'');
                }
                catch (FormatException formatException) {}
            }
            ++i;
        }
        return result;
    }

    private String getSuffix(String text, String pattern) {
        String result = null;
        int ix = text.indexOf(pattern);
        if (ix >= 0) {
            result = text.substring(ix + pattern.length());
        }
        return result;
    }

    private boolean remove(StringBuilder result, String substring) {
        int index = result.indexOf(substring);
        if (index >= 0) {
            result.replace(index, index + substring.length(), "");
            return true;
        }
        return false;
    }

    private Line createLine(Help help) {
        Line result = new Line(help.getItem());
        String tip = help.getTip();
        if (tip != null && tip.length() > 0) {
            this.toolTipMap.put(result, tip);
        }
        return result;
    }

    public static void main(String[] args) {
        CtrlDoc doc = new CtrlDoc();
        for (Map.Entry<?, List<?>> ruleEntry : doc.getItemTree().entrySet()) {
            System.out.printf("Nonterminal: %s%n", ruleEntry.getKey());
            for (Object rule : ruleEntry.getValue()) {
                System.out.printf("* %s%n", rule);
                String tip = doc.getToolTipMap().get(rule);
                if (tip == null) continue;
                System.out.printf("  (%s)%n", tip);
            }
        }
    }

    private class Line {
        private final String text;

        public Line(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

