/*
 * Decompiled with CFR 0.152.
 */
package groove.control.parse;

import groove.algebra.AlgebraFamily;
import groove.control.CtrlAut;
import groove.control.CtrlCall;
import groove.control.CtrlPar;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.control.CtrlType;
import groove.control.CtrlVar;
import groove.control.parse.CtrlFragment;
import groove.control.parse.CtrlTree;
import groove.control.parse.Namespace;
import groove.control.parse.SymbolTable;
import groove.grammar.QualName;
import groove.grammar.model.FormatErrorSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class CtrlHelper {
    private String currentName;
    private CtrlCall.Kind currentKind;
    private final Namespace namespace;
    private final AlgebraFamily algebraFamily;
    private final FormatErrorSet errors = new FormatErrorSet();
    private final SymbolTable symbolTable = new SymbolTable();
    private final Map<String, Set<String>> dependencyMap = new HashMap<String, Set<String>>();
    private Set<String> initVars = new HashSet<String>();
    private final Stack<Set<String>[]> initVarScopes = new Stack();
    private String packageName = "";
    private Map<String, String> importMap = new HashMap<String, String>();

    public CtrlHelper(BaseRecognizer recogniser, Namespace namespace, AlgebraFamily family) {
        this.namespace = namespace;
        this.algebraFamily = family;
    }

    String getControlName() {
        return this.namespace.getFullName();
    }

    void setPackage(CommonTree packageTree) {
        this.packageName = packageTree.getText();
        String parentName = this.namespace.getParentName();
        if (!parentName.equals(this.packageName)) {
            this.emitErrorMessage((Tree)packageTree, "Package declaration '%s' does not equal program location '%s'", this.packageName, parentName);
        }
    }

    void addImport(CommonTree importTree) {
        String fullName = importTree.getText();
        String name = QualName.getLastName(fullName);
        this.importMap.put(name, fullName);
    }

    void openScope() {
        this.symbolTable.openScope();
    }

    void closeScope() {
        this.symbolTable.closeScope();
    }

    void startBranch() {
        Set[] setArray = new Set[2];
        setArray[0] = new HashSet<String>(this.initVars);
        this.initVarScopes.push(setArray);
    }

    void nextBranch() {
        Set<String>[] topInitVarScope = this.initVarScopes.peek();
        if (topInitVarScope[1] == null) {
            topInitVarScope[1] = new HashSet<String>(this.initVars);
        } else {
            topInitVarScope[1].retainAll(this.initVars);
        }
        this.initVars = new HashSet<String>(topInitVarScope[0]);
    }

    void endBranch() {
        Set<String>[] topInitVarScope = this.initVarScopes.pop();
        this.initVars = topInitVarScope[0];
        if (topInitVarScope[1] != null) {
            this.initVars.retainAll(topInitVarScope[1]);
        }
    }

    CommonTree emptyPackage() {
        CtrlTree result = new CtrlTree((Token)new CommonToken(43));
        result.addChild((Tree)this.toQualName(Collections.emptyList()));
        return result;
    }

    CommonTree toQualName(List<? extends Token> children) {
        CommonToken token = new CommonToken(27, this.flatten(children));
        if (!children.isEmpty()) {
            CommonToken child = (CommonToken)children.get(0);
            token.setLine(child.getLine());
            token.setTokenIndex(child.getTokenIndex());
        }
        return new CtrlTree((Token)token);
    }

    CommonTree lookup(CommonTree ruleNameToken) {
        CommonTree result = ruleNameToken;
        String name = ruleNameToken.getText();
        if (QualName.getParent(name).isEmpty()) {
            name = this.importMap.containsKey(name) ? this.importMap.get(name) : QualName.extend(this.packageName, name);
            CommonToken token = new CommonToken(27, name);
            token.setLine(ruleNameToken.getLine());
            token.setTokenIndex(ruleNameToken.getToken().getTokenIndex());
            result = new CtrlTree((Token)token);
        }
        if (!this.namespace.hasName(name)) {
            this.emitErrorMessage((Tree)result, "Unknown name or identifier %s", name);
        }
        return result;
    }

    String qualify(String name) {
        return QualName.extend(this.namespace.getParentName(), name);
    }

    String looukp(String name) {
        String result = this.importMap.get(name);
        if (result == null) {
            result = this.qualify(name);
        }
        return name;
    }

    String flatten(List<?> children) {
        String result = "";
        for (Object token : children) {
            result = QualName.extend(result, ((CommonToken)token).getText());
        }
        return result.toString();
    }

    boolean declareName(Tree functionTree, CtrlFragment fragment) {
        boolean result = false;
        assert ((functionTree.getType() == 25 || functionTree.getType() == 51) && functionTree.getChildCount() <= 3);
        String name = this.qualify(functionTree.getChild(0).getText());
        if (this.namespace.hasName(name)) {
            this.emitErrorMessage(functionTree, "Duplicate name: %s %s already defined", this.namespace.getKind(name).getName(true), name);
        } else if (functionTree.getType() == 25) {
            this.namespace.addFunction(name, new ArrayList<CtrlPar.Var>());
            result = true;
        } else {
            String priority = functionTree.getChildCount() == 2 ? "0" : functionTree.getChild(1).getText();
            this.namespace.addRecipe(name, Integer.parseInt(priority), new ArrayList<CtrlPar.Var>(), fragment.getName(), fragment.getStartLine());
            result = true;
        }
        return result;
    }

    void startBody(CtrlTree nameTree, CtrlCall.Kind kind) {
        assert (this.currentName == null);
        this.currentName = nameTree.getText();
        this.currentKind = kind;
    }

    void endBody() {
        assert (this.currentName != null);
        this.currentName = null;
        this.currentKind = null;
    }

    void reorderFunctions(CtrlTree functionsTree) {
        assert (functionsTree.getType() == 26);
        int functionsCount = functionsTree.getChildCount();
        HashMap<String, CtrlTree> functionMap = new HashMap<String, CtrlTree>();
        int i = 0;
        while (i < functionsCount) {
            CtrlTree function = functionsTree.getChild(i);
            functionMap.put(function.getChild(0).getText(), function);
            ++i;
        }
        LinkedHashSet<String> resolved = new LinkedHashSet<String>();
        int i2 = 0;
        while (i2 < functionsCount) {
            String next = null;
            for (String from : functionMap.keySet()) {
                Set<String> to = this.dependencyMap.get(from);
                if (resolved.contains(from) || to != null && !resolved.containsAll(to)) continue;
                next = from;
                break;
            }
            if (next == null) {
                this.emitErrorMessage((Tree)functionsTree, "Circular dependencies in function calls", new Object[0]);
                break;
            }
            resolved.add(next);
            ++i2;
        }
        if (resolved.size() == functionsCount) {
            i2 = 0;
            for (String name : resolved) {
                functionsTree.setChild(i2, (Tree)functionMap.get(name));
                ++i2;
            }
        }
    }

    private String toLocalName(String name) {
        return this.currentName == null ? name : String.valueOf(this.currentName) + "." + name;
    }

    boolean declareVar(Tree nameTree, CtrlTree typeTree) {
        boolean result = true;
        String name = this.toLocalName(nameTree.getText());
        if (!this.symbolTable.declareSymbol(name, typeTree.getCtrlType())) {
            this.emitErrorMessage(nameTree, "Duplicate local variable name %s", name);
            result = false;
        }
        return result;
    }

    void checkPackage(CtrlTree importTree) {
        String actualName;
        String name = importTree.getText();
        if (!name.equals(actualName = this.namespace.getParentName())) {
            this.emitErrorMessage((Tree)importTree, "Package %s should be %s", name, actualName);
        }
    }

    void checkImport(CtrlTree importTree) {
        String name = importTree.getText();
        if (!this.namespace.hasName(name)) {
            this.emitErrorMessage((Tree)importTree, "Imported name '%s' does not exist", name);
        }
    }

    CtrlType checkType(CtrlTree typeTree) {
        CtrlType result = typeTree.getType() == 37 ? CtrlType.NODE : CtrlType.valueOf(typeTree.getText().toUpperCase());
        typeTree.setCtrlType(result);
        return result;
    }

    CtrlVar checkVar(CtrlTree nameTree, boolean checkInit) {
        CtrlVar result = null;
        String name = this.toLocalName(nameTree.getText());
        CtrlType type = this.symbolTable.getType(name);
        if (type == null) {
            this.emitErrorMessage((Tree)nameTree, "Local variable %s not declared", name);
        } else {
            result = new CtrlVar(name, type);
            nameTree.setCtrlVar(result);
            if (checkInit && !this.initVars.contains(name)) {
                this.emitErrorMessage((Tree)nameTree, "Variable %s may not have been initialised", name);
            } else {
                this.initVars.add(name);
            }
        }
        return result;
    }

    CtrlPar checkVarArg(CtrlTree argTree) {
        CtrlPar.Var result = null;
        int childCount = argTree.getChildCount();
        assert (argTree.getType() == 7 && childCount > 0 && childCount <= 2);
        boolean isOutArg = childCount == 2;
        CtrlVar var = this.checkVar(argTree.getChild(childCount - 1), !isOutArg);
        if (var != null) {
            result = new CtrlPar.Var(var, !isOutArg);
            argTree.setCtrlPar(result);
        }
        return result;
    }

    CtrlPar checkDontCareArg(CtrlTree argTree) {
        assert (argTree.getType() == 7 && argTree.getChildCount() == 1);
        CtrlPar.Wild result = new CtrlPar.Wild();
        argTree.setCtrlPar(result);
        return result;
    }

    CtrlPar checkConstArg(CtrlTree argTree) {
        assert (argTree.getType() == 7 && argTree.getChildCount() == 1);
        String constant = argTree.getChild(0).getText();
        CtrlPar.Const result = new CtrlPar.Const(this.algebraFamily.getAlgebraFor(constant), constant);
        argTree.setCtrlPar(result);
        return result;
    }

    CtrlCall checkCall(CtrlTree callTree) {
        int childCount = callTree.getChildCount();
        assert (callTree.getType() == 14 && childCount >= 1);
        CtrlCall result = null;
        String name = callTree.getChild(0).getText();
        ArrayList<CtrlPar> args = null;
        if (childCount == 2) {
            args = new ArrayList<CtrlPar>();
            CtrlTree argsTree = callTree.getChild(1);
            int i = 0;
            while (i < argsTree.getChildCount()) {
                CtrlPar arg = argsTree.getChild(i).getCtrlPar();
                if (arg != null) {
                    args.add(arg);
                    ++i;
                    continue;
                }
                break;
            }
        } else if (this.checkCall(callTree, name, args)) {
            CtrlCall.Kind kind = this.namespace.getKind(name);
            this.namespace.useName(name);
            if (kind == CtrlCall.Kind.RULE) {
                result = new CtrlCall(this.namespace.getRule(name), args);
            } else {
                result = new CtrlCall(kind, name, args);
                if (this.currentName != null) {
                    this.addDependency(this.currentName, name);
                }
            }
            callTree.setCtrlCall(result);
        }
        return result;
    }

    void checkAny(CtrlTree anyTree) {
        if (this.currentKind == CtrlCall.Kind.RECIPE) {
            this.emitErrorMessage((Tree)anyTree, "'any' may not be used within a recipe", new Object[0]);
        }
        HashSet<String> anyNames = new HashSet<String>(this.namespace.getTopNames());
        anyNames.removeAll(this.namespace.getUsedNames());
        this.checkGroupCall(anyTree, anyNames);
    }

    void checkOther(CtrlTree otherTree) {
        if (this.currentKind == CtrlCall.Kind.RECIPE) {
            this.emitErrorMessage((Tree)otherTree, "'other' may not be used within a recipe", new Object[0]);
        }
        HashSet<String> unusedRules = new HashSet<String>(this.namespace.getTopNames());
        unusedRules.removeAll(this.namespace.getUsedNames());
        this.checkGroupCall(otherTree, unusedRules);
    }

    private void checkGroupCall(CtrlTree callTree, Set<String> rules) {
        for (String ruleName : rules) {
            this.checkCall(callTree, ruleName, null);
        }
    }

    void checkEOF(CommonTree EOFToken) {
        if (this.packageName.isEmpty() && !this.namespace.getParentName().isEmpty()) {
            this.emitErrorMessage((Tree)EOFToken, "Missing package declaration", this.namespace.getFullName());
        }
    }

    private boolean checkCall(CtrlTree callTree, String name, List<CtrlPar> args) {
        boolean result;
        CtrlCall.Kind kind = this.namespace.getKind(name);
        List<CtrlPar.Var> sig = kind == null ? null : this.namespace.getSig(name);
        boolean bl = result = sig != null;
        if (!result) {
            this.emitErrorMessage((Tree)callTree, "Unknown action '%s'", name);
        } else if (args == null) {
            result = kind == CtrlCall.Kind.RULE || kind == CtrlCall.Kind.RECIPE;
            int i = 0;
            while (result && i < sig.size()) {
                result = sig.get(i).compatibleWith(new CtrlPar.Wild());
                ++i;
            }
            if (!result) {
                String message = "%s %s%s not applicable without arguments";
                String ruleSig = this.toTypeString(sig);
                this.emitErrorMessage((Tree)callTree, message, kind.getName(true), name, ruleSig);
            }
        } else {
            result = args.size() == sig.size();
            int i = 0;
            while (result && i < args.size()) {
                result = sig.get(i).compatibleWith(args.get(i));
                ++i;
            }
            if (!result) {
                String message = "%s %s%s not applicable for arguments %s";
                String callSig = this.toTypeString(args);
                String ruleSig = this.toTypeString(sig);
                this.emitErrorMessage((Tree)callTree, message, kind.getName(true), name, ruleSig, callSig);
            }
        }
        return result;
    }

    String toTypeString(List<? extends CtrlPar> sig) {
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (CtrlPar ctrlPar : sig) {
            if (result.length() > 1) {
                result.append(',');
            }
            if (ctrlPar.isOutOnly()) {
                result.append("out");
                result.append(' ');
            }
            result.append((Object)ctrlPar.getType());
        }
        result.append(')');
        return result.toString();
    }

    private void emitErrorMessage(Tree marker, String message, Object ... args) {
        if (marker == null) {
            this.errors.add(message, args);
        } else {
            int line = marker.getLine();
            int column = marker.getCharPositionInLine();
            message = String.format(message, args);
            message = String.format("line %d:%d %s", line, column, message);
            this.addError(message, line, column);
        }
    }

    void addError(String message, int line, int column) {
        this.errors.add(message, line, column);
    }

    FormatErrorSet getErrors() {
        return this.errors;
    }

    private void addDependency(String from, String to) {
        Set<String> dependencies = this.dependencyMap.get(from);
        if (dependencies == null) {
            dependencies = new HashSet<String>();
            this.dependencyMap.put(from, dependencies);
        }
        dependencies.add(to);
    }

    boolean checkRecipeBody(CtrlTree actionTree, String name, CtrlAut aut) {
        boolean result = true;
        for (CtrlState state : aut.nodeSet()) {
            if (!state.isTransient()) continue;
            this.emitErrorMessage((Tree)actionTree, "Recipe '%s' contains a nested recipe call to '%s'", name, state.getRecipe());
        }
        for (CtrlTransition omegaTrans : aut.getOmegas()) {
            if (omegaTrans.source() != aut.getStart()) continue;
            this.emitErrorMessage((Tree)actionTree, "Recipe '%s' has empty behaviour", name);
            result = false;
            break;
        }
        if (aut.getOmegas().isEmpty()) {
            this.emitErrorMessage((Tree)actionTree, "Recipe '%s' does not terminate", name);
            result = false;
        } else if (!aut.isEndDeterministic()) {
            this.emitErrorMessage((Tree)actionTree, "Recipe '%s' does not terminate deterministically", name);
            result = false;
        }
        return result;
    }
}

