/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.encode.StringEditor;
import groove.grammar.Grammar;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import java.util.Map;
import java.util.TreeMap;

public class EncodedEdgeMap
implements EncodedType<Map<TypeLabel, Integer>, String> {
    @Override
    public EncodedTypeEditor<Map<TypeLabel, Integer>, String> createEditor(GrammarModel grammar) {
        return new StringEditor<Map<TypeLabel, Integer>>(grammar, "label>num,[label>num]*", "", 30);
    }

    private TypeLabel parseLabel(TypeGraph typegraph, String source) throws FormatException {
        for (TypeLabel label : typegraph.getLabels()) {
            if (!label.text().equals(source)) continue;
            return label;
        }
        throw new FormatException("'" + source + "' is not a valid edge name in the current grammar.", new Object[0]);
    }

    private Integer parseBound(String source) throws FormatException {
        Integer num = Integer.parseInt(source, 10);
        if (num == null || num < 0) {
            throw new FormatException("'" + source + "' is not a valid edge bound.", new Object[0]);
        }
        return num;
    }

    @Override
    public Map<TypeLabel, Integer> parse(Grammar rules, String source) throws FormatException {
        String[] units;
        if (source.equals("")) {
            throw new FormatException("The empty string is not a valid condition edge>num.", new Object[0]);
        }
        TreeMap<TypeLabel, Integer> edgeMap = new TreeMap<TypeLabel, Integer>();
        TypeGraph typeGraph = rules.getTypeGraph();
        String[] stringArray = units = source.split(",");
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            String[] assignment = unit.split(">");
            if (assignment.length != 2) {
                throw new FormatException("'" + unit + "' is not a valid condition edge>num.", new Object[0]);
            }
            edgeMap.put(this.parseLabel(typeGraph, assignment[0]), this.parseBound(assignment[1]));
            ++n2;
        }
        return edgeMap;
    }
}

