/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.strategy.Boundary;
import groove.explore.strategy.LTLStrategy;
import groove.explore.util.RandomChooserInSequence;
import groove.lts.GraphTransition;
import groove.lts.RuleTransition;
import groove.verify.ProductState;
import groove.verify.ProductTransition;

public class BoundedLTLStrategy
extends LTLStrategy {
    private Boundary boundary;

    public void setBoundary(Boundary boundary) {
        this.boundary = boundary.instantiate(this.getRecord());
    }

    public Boundary getBoundary() {
        return this.boundary;
    }

    @Override
    protected boolean exploreState(ProductState prodState) {
        boolean result = false;
        if (prodState.isExplored()) {
            for (ProductTransition prodTrans : prodState.outTransitions()) {
                result = this.findCounterExample(prodState, prodTrans.target());
                if (!result) {
                    continue;
                }
                break;
            }
        } else {
            result = super.exploreState(prodState);
            if (!result) {
                prodState.setExplored();
            }
        }
        return result;
    }

    @Override
    protected ProductState computeNextState() {
        ProductState result = super.computeNextState();
        if (result == null && this.getStateSet().hasOpenStates()) {
            result = this.getStartState();
            this.getRecord().increase();
            this.getBoundary().increase();
            this.getBoundary().setCurrentDepth(0);
        }
        return result;
    }

    @Override
    protected ProductState getFreshState() {
        ProductState result = null;
        for (ProductTransition outTransition : this.getNextState().outTransitions()) {
            ProductState target = outTransition.target();
            if (!this.isUnexplored(target) || !(target.getGraphState() instanceof RuleTransition)) continue;
            if (!this.getBoundary().crossingBoundary(outTransition, true)) {
                result = target;
                break;
            }
            this.processBoundaryCrossingTransition(outTransition);
        }
        return result;
    }

    private ProductState processBoundaryCrossingTransition(ProductTransition transition) {
        if (this.getBoundary().currentDepth() < this.getRecord().getIteration() - 1) {
            return transition.target();
        }
        transition.target().setIteration(this.getRecord().getIteration() + 1);
        return null;
    }

    @Override
    protected ProductState rollbackState() {
        ProductState previous = this.getStateStack().peek();
        GraphTransition origin = previous.getOrigin();
        if (origin != null) {
            this.getBoundary().backtrackTransition(origin);
        }
        return super.rollbackState();
    }

    @Override
    protected void colourState(ProductState state) {
        if (state.getBuchiLocation().isAccepting()) {
            state.setColour(this.getRecord().red());
        } else {
            state.setColour(this.getRecord().blue());
        }
    }

    protected boolean isUnexplored(ProductState newState) {
        boolean result = newState.colour() != this.getRecord().cyan() && newState.colour() != this.getRecord().blue() && newState.colour() != this.getRecord().red();
        return result;
    }

    @Override
    protected ProductState getNextSuccessor(ProductState state) {
        ProductState result = null;
        RandomChooserInSequence<ProductTransition> chooser = new RandomChooserInSequence<ProductTransition>();
        for (ProductTransition p : state.outTransitions()) {
            ProductState buchiState = p.target();
            if (!this.isUnexplored(buchiState)) continue;
            if (!this.getBoundary().crossingBoundary(p, false) || buchiState.isExplored()) {
                chooser.show(p);
                continue;
            }
            buchiState.setIteration(this.getRecord().getIteration() + 1);
        }
        ProductTransition resultTransition = (ProductTransition)chooser.pickRandom();
        if (resultTransition != null) {
            this.getBoundary().crossingBoundary(resultTransition, true);
            result = resultTransition.target();
        }
        return result;
    }
}

