/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.result.Acceptor;
import groove.explore.strategy.GTSStrategy;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.transform.Record;
import groove.transform.RuleEvent;
import java.util.Stack;

public class LinearStrategy
extends GTSStrategy {
    private final boolean closeFast;
    private final Stack<GraphState> pool = new Stack();
    private final ExploreListener exploreListener = new ExploreListener();

    public LinearStrategy() {
        this(false);
    }

    public LinearStrategy(boolean closeFast) {
        this.closeFast = closeFast;
    }

    @Override
    public void prepare(GTS gts, GraphState state, Acceptor acceptor) {
        Record record = gts.getRecord();
        record.setCollapse(false);
        record.setCopyGraphs(false);
        record.setReuseEvents(RuleEvent.Reuse.NONE);
        super.prepare(gts, state, acceptor);
        gts.addLTSListener(this.exploreListener);
    }

    @Override
    public GraphState doNext() {
        GraphState state = this.getNextState();
        MatchResult match = this.getMatch();
        if (!state.isClosed()) {
            this.putBackInPool();
        }
        if (match != null) {
            state.applyMatch(match);
        }
        this.setNextState();
        return state;
    }

    protected MatchResult getMatch() {
        return this.getNextState().getMatch();
    }

    @Override
    protected GraphState computeNextState() {
        if (this.pool.isEmpty()) {
            return null;
        }
        return this.pool.pop();
    }

    @Override
    public void finish() {
        this.getGTS().removeLTSListener(this.exploreListener);
    }

    private void putBackInPool() {
        this.pool.push(this.getNextState());
    }

    private void putFreshInPool(GraphState state) {
        if (!state.isTransient()) {
            if (this.isCloseFast()) {
                for (GraphState s : this.pool) {
                    s.setClosed(false);
                }
            }
            this.pool.clear();
        }
        if (state.isTransient() || !state.hasFlag(GraphState.Flag.KNOWN)) {
            this.pool.push(state);
        }
    }

    private boolean isCloseFast() {
        return this.closeFast;
    }

    private class ExploreListener
    extends GTSAdapter {
        private ExploreListener() {
        }

        @Override
        public void addUpdate(GTS gts, GraphState state) {
            LinearStrategy.this.putFreshInPool(state);
        }
    }
}

