/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.algebra.AlgebraFamily;
import groove.explore.result.Acceptor;
import groove.explore.strategy.BFSStrategy;
import groove.explore.strategy.ClosingStrategy;
import groove.explore.strategy.GTSStrategy;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.sts.Location;
import groove.sts.STS;
import groove.sts.STSException;
import groove.sts.SwitchRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class SymbolicStrategy
extends GTSStrategy {
    protected ClosingStrategy strategy;
    protected STS sts;

    public void setStrategy(ClosingStrategy strategy) {
        this.strategy = strategy;
    }

    public STS getSTS() {
        return this.sts;
    }

    @Override
    public void prepare(GTS gts, GraphState state, Acceptor acceptor) {
        super.prepare(gts, state, acceptor);
        if (this.getGTS().getGrammar().getProperties().getAlgebraFamily() != AlgebraFamily.POINT) {
            System.err.print("Grammar AlgebraFamily property should be point,if the SymbolicStrategy is used.");
            return;
        }
        if (this.strategy == null) {
            this.strategy = new BFSStrategy();
        }
        this.strategy.prepare(gts, state, acceptor);
        this.sts = new STS();
        this.sts.hostGraphToStartLocation(this.getGTS().getGrammar().getStartGraph());
    }

    @Override
    public GraphState doNext() {
        GraphState state = this.getNextState();
        assert (state != null);
        Location current = this.sts.getCurrentLocation();
        List<MatchResult> matchSet = state.getMatches();
        if (!matchSet.isEmpty()) {
            List<Collection<? extends MatchResult>> priorityGroups = this.createPriorityGroups(matchSet);
            HashSet<SwitchRelation> higherPriorityRelations = new HashSet<SwitchRelation>();
            HashSet<SwitchRelation> temp = new HashSet<SwitchRelation>();
            boolean emptyGuard = false;
            for (Collection<? extends MatchResult> matches : priorityGroups) {
                for (MatchResult matchResult : matches) {
                    SwitchRelation sr = null;
                    try {
                        sr = this.sts.ruleMatchToSwitchRelation(this.getNextState().getGraph(), matchResult, higherPriorityRelations);
                    }
                    catch (STSException e) {
                        e.printStackTrace();
                    }
                    if (sr.getGuard().isEmpty()) {
                        emptyGuard = true;
                    }
                    temp.add(sr);
                    RuleTransition transition = this.getNextState().applyMatch(matchResult);
                    Location l = this.sts.hostGraphToLocation(transition.target().getGraph());
                    current.addSwitchRelation(sr, l);
                }
                if (emptyGuard) break;
                higherPriorityRelations.addAll(temp);
                temp.clear();
            }
        }
        this.setNextState();
        return state;
    }

    @Override
    protected GraphState computeNextState() {
        GraphState state = null;
        state = this.strategy.computeNextState();
        if (state != null) {
            this.sts.toLocation(this.sts.hostGraphToLocation(state.getGraph()));
        }
        return state;
    }

    private List<Collection<? extends MatchResult>> createPriorityGroups(Collection<? extends MatchResult> matches) {
        ArrayList<? extends MatchResult> sortedMatches = new ArrayList<MatchResult>(matches);
        Collections.sort(sortedMatches, new PriorityComparator());
        ArrayList<Collection<? extends MatchResult>> priorityGroups = new ArrayList<Collection<? extends MatchResult>>();
        int priority = ((MatchResult)sortedMatches.get(0)).getRule().getPriority();
        HashSet<MatchResult> current = new HashSet<MatchResult>();
        for (MatchResult matchResult : sortedMatches) {
            if (matchResult.getRule().getPriority() != priority) {
                priorityGroups.add(current);
                current = new HashSet();
                priority = matchResult.getRule().getPriority();
            }
            current.add(matchResult);
        }
        priorityGroups.add(current);
        return priorityGroups;
    }

    private class PriorityComparator
    implements Comparator<MatchResult> {
        private PriorityComparator() {
        }

        @Override
        public int compare(MatchResult res1, MatchResult res2) {
            return res2.getRule().getPriority() - res1.getRule().getPriority();
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Comparator;
        }
    }
}

