/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.grammar.host.AnchorValue;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeElement;
import groove.graph.EdgeComparator;
import groove.graph.NodeComparator;

public enum AnchorKind implements Comparable<AnchorKind>
{
    NODE,
    EDGE,
    LABEL;


    public static int compare(AnchorValue one, AnchorValue two) {
        int result = one.getAnchorKind().compareTo(one.getAnchorKind());
        if (result == 0) {
            switch (one.getAnchorKind()) {
                case NODE: {
                    result = NodeComparator.instance().compare(AnchorKind.node(one), AnchorKind.node(two));
                    break;
                }
                case EDGE: {
                    result = EdgeComparator.instance().compare(AnchorKind.edge(one), AnchorKind.edge(two));
                    break;
                }
                case LABEL: {
                    result = AnchorKind.label(one).compareTo(AnchorKind.label(two));
                }
            }
        }
        return result;
    }

    public static RuleNode node(AnchorKey key) {
        return key.getAnchorKind() == NODE ? (RuleNode)key : null;
    }

    public static RuleEdge edge(AnchorKey key) {
        return key.getAnchorKind() == EDGE ? (RuleEdge)key : null;
    }

    public static LabelVar label(AnchorKey key) {
        return key.getAnchorKind() == LABEL ? (LabelVar)key : null;
    }

    public static HostNode node(AnchorValue key) {
        return key.getAnchorKind() == NODE ? (HostNode)key : null;
    }

    public static HostEdge edge(AnchorValue key) {
        return key.getAnchorKind() == EDGE ? (HostEdge)key : null;
    }

    public static TypeElement label(AnchorValue key) {
        return key.getAnchorKind() == LABEL ? (TypeElement)key : null;
    }
}

