/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.algebra.AlgebraFamily;
import groove.explore.Exploration;
import groove.grammar.model.FormatException;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeLabel;
import groove.gui.dialog.PropertyKey;
import groove.util.Fixable;
import groove.util.Groove;
import groove.util.Property;
import groove.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class GrammarProperties
extends Properties
implements Fixable {
    private boolean fixed;
    public static final String NUMERIC_YES = "1";
    public static final String NUMERIC_NO = "0";
    public static final Map<String, Key> KEYS;
    private static GrammarProperties instance;
    public static final GrammarProperties DEFAULT_PROPERTIES;
    private static final Map<ResourceKind, Key> resourceKeyMap;

    static {
        LinkedHashMap<String, Key> defaultKeys = new LinkedHashMap<String, Key>();
        Key[] keyArray = Key.values();
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray[n2];
            defaultKeys.put(key.getName(), key);
            ++n2;
        }
        KEYS = Collections.unmodifiableMap(defaultKeys);
        instance = new GrammarProperties();
        DEFAULT_PROPERTIES = GrammarProperties.getInstance();
        resourceKeyMap = new EnumMap<ResourceKind, Key>(ResourceKind.class);
        resourceKeyMap.put(ResourceKind.TYPE, Key.TYPE_NAMES);
        resourceKeyMap.put(ResourceKind.CONTROL, Key.CONTROL_NAMES);
        resourceKeyMap.put(ResourceKind.PROLOG, Key.PROLOG_NAMES);
        resourceKeyMap.put(ResourceKind.HOST, Key.START_GRAPH_NAMES);
    }

    public GrammarProperties() {
        this(false);
    }

    public GrammarProperties(boolean useCurrentGrooveVersion) {
        if (useCurrentGrooveVersion) {
            this.setCurrentVersionProperties();
            this.setShowLoopsAsLabels(false);
        } else {
            this.setGrooveVersion(Version.getInitialGrooveVersion());
            this.setGrammarVersion(Version.getInitialGrammarVersion());
        }
    }

    public void setCurrentVersionProperties() {
        this.setGrooveVersion(Version.getCurrentGrooveVersion());
        this.setGrammarVersion(Version.getCurrentGrammarVersion());
    }

    public boolean isCurrentVersionProperties() {
        return this.getGrooveVersion().equals(Version.getCurrentGrooveVersion()) && this.getGrammarVersion().equals(Version.getCurrentGrammarVersion());
    }

    public boolean isShowLoopsAsLabels() {
        String property = this.getProperty(Key.LOOPS_AS_LABELS);
        return property == null || property.isEmpty() || Boolean.valueOf(property) != false;
    }

    public void setShowLoopsAsLabels(boolean show) {
        this.setProperty(Key.LOOPS_AS_LABELS, "" + show);
    }

    public boolean isShowTransitionBrackets() {
        String property = this.getProperty(Key.TRANSITION_BRACKETS);
        return property != null && (Boolean.valueOf(property) != false || property.equals(NUMERIC_YES));
    }

    public boolean isUseParameters() {
        String params = this.getProperty(Key.TRANSITION_PARAMETERS);
        return params != null && (Boolean.valueOf(params) != false || params.equals(NUMERIC_YES));
    }

    public void setUseParameters(boolean useParameters) {
        this.setProperty(Key.TRANSITION_PARAMETERS, "" + useParameters);
    }

    public void setGrooveVersion(String version) {
        this.setProperty(Key.GROOVE_VERSION, version);
    }

    public String getGrooveVersion() {
        return this.getProperty(Key.GROOVE_VERSION);
    }

    public void setGrammarVersion(String version) {
        this.setProperty(Key.GRAMMAR_VERSION, version);
    }

    public String getGrammarVersion() {
        return this.getProperty(Key.GRAMMAR_VERSION);
    }

    public List<String> getControlLabels() {
        String controlLabels = this.getProperty(Key.CONTROL_LABELS);
        if (controlLabels == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(controlLabels.split("\\s"));
    }

    public void setControlLabels(List<String> controlLabels) {
        this.setProperty(Key.CONTROL_LABELS, Groove.toString(controlLabels.toArray(), "", "", " "));
    }

    public List<String> getCommonLabels() {
        String commonLabels = this.getProperty(Key.COMMON_LABELS);
        if (commonLabels == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(commonLabels.split("\\s"));
    }

    public void setCommonLabels(List<String> commonLabels) {
        this.setProperty(Key.COMMON_LABELS, Groove.toString(commonLabels.toArray(), "", "", " "));
    }

    public void setInjective(boolean injective) {
        this.setProperty(Key.INJECTIVE, "" + injective);
    }

    public boolean isInjective() {
        String result = this.getProperty(Key.INJECTIVE);
        return result != null && Boolean.valueOf(result) != false;
    }

    public void setCheckDangling(boolean dangling) {
        this.setProperty(Key.DANGLING, "" + dangling);
    }

    public boolean isCheckDangling() {
        String result = this.getProperty(Key.DANGLING);
        return result != null && Boolean.valueOf(result) != false;
    }

    public void setExploration(String strategy) {
        this.setProperty(Key.EXPLORATION, strategy);
    }

    public String getExploration() {
        String result = this.getProperty(Key.EXPLORATION);
        return GrammarProperties.stringOrNull(result);
    }

    public void setActiveNames(ResourceKind kind, Collection<String> names) {
        assert (kind != ResourceKind.RULE);
        this.setProperty(resourceKeyMap.get((Object)kind), Groove.toString(names.toArray(), "", "", " "));
    }

    public Set<String> getActiveNames(ResourceKind kind) {
        assert (kind != ResourceKind.RULE);
        if (kind == ResourceKind.CONFIG || kind == ResourceKind.GROOVY) {
            return Collections.emptySet();
        }
        String names = this.getProperty(resourceKeyMap.get((Object)kind));
        if (names == null || "".equals(names)) {
            return Collections.emptySet();
        }
        return new TreeSet<String>(Arrays.asList(names.split("\\s")));
    }

    public void setAlgebraFamily(AlgebraFamily family) {
        this.setProperty(Key.ALGEBRA, family.getName());
    }

    public AlgebraFamily getAlgebraFamily() {
        AlgebraFamily result;
        String property = this.getProperty(Key.ALGEBRA);
        AlgebraFamily algebraFamily = result = property == null || property.isEmpty() ? AlgebraFamily.DEFAULT : AlgebraFamily.getInstance(property);
        assert (result != null);
        return result;
    }

    public void setCheckCreatorEdges(boolean check) {
        this.setProperty(Key.CREATOR_EDGE, "" + check);
    }

    public boolean isCheckCreatorEdges() {
        String result = this.getProperty(Key.CREATOR_EDGE);
        return result != null && Boolean.valueOf(result) != false;
    }

    public void setCheckIsomorphism(boolean check) {
        this.setProperty(Key.ISOMORPHISM, "" + check);
    }

    public boolean isCheckIsomorphism() {
        String result = this.getProperty(Key.ISOMORPHISM);
        return result == null || result.isEmpty() || Boolean.valueOf(result) != false;
    }

    public boolean isRhsAsNac() {
        String result = this.getProperty(Key.RHS_AS_NAC);
        return result != null && Boolean.valueOf(result) != false;
    }

    public void setRhsAsNac(boolean value) {
        this.setProperty(Key.RHS_AS_NAC, "" + value);
    }

    public List<String> getAbstractionLabels() {
        String abstractionLabels = this.getProperty(Key.ABSTRACTION_LABELS);
        if (abstractionLabels == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(abstractionLabels.split("\\s"));
    }

    public void setAbstractionLabels(List<String> abstractionLabels) {
        this.setProperty(Key.ABSTRACTION_LABELS, Groove.toString(abstractionLabels.toArray(), "", "", " "));
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        this.testFixed(false);
        return super.setProperty(key, value);
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        this.testFixed(false);
        this.clear();
        super.load(inStream);
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        this.testFixed(false);
        this.clear();
        super.loadFromXML(in);
    }

    @Override
    public synchronized void clear() {
        this.testFixed(false);
        super.clear();
    }

    @Override
    public GrammarProperties clone() {
        GrammarProperties result = (GrammarProperties)super.clone();
        result.fixed = false;
        return result;
    }

    public GrammarProperties relabel(TypeLabel oldLabel, TypeLabel newLabel) {
        GrammarProperties result = this.clone();
        boolean hasChanged = false;
        String oldText = oldLabel.text();
        List<String> controlLabels = this.getControlLabels();
        ArrayList<String> newControlLabels = new ArrayList<String>(controlLabels);
        if (controlLabels != null && controlLabels.contains(oldText)) {
            int index = controlLabels.indexOf(oldText);
            newControlLabels.set(index, newLabel.text());
            result.setControlLabels(newControlLabels);
            hasChanged = true;
        }
        List<String> commonLabels = this.getControlLabels();
        ArrayList<String> newCommonLabels = new ArrayList<String>(commonLabels);
        if (commonLabels != null && commonLabels.contains(oldText)) {
            int index = commonLabels.indexOf(oldText);
            newCommonLabels.set(index, newLabel.text());
            result.setCommonLabels(newCommonLabels);
            hasChanged = true;
        }
        return hasChanged ? result : this;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        this.testFixed(false);
        return super.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.testFixed(false);
        return super.remove(key);
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public boolean setFixed() {
        boolean result = !this.isFixed();
        this.fixed = true;
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void testFixed(boolean fixed) throws IllegalStateException {
        if (this.fixed != fixed) {
            throw new IllegalStateException(String.format("Expected fixed = %b", fixed));
        }
    }

    private String getProperty(Key key) {
        return this.getProperty(key.getName());
    }

    private void setProperty(Key key, String value) {
        this.setProperty(key.getName(), value);
    }

    public static GrammarProperties getInstance() {
        return instance;
    }

    public static boolean isCheckDangling(GrammarProperties properties) {
        return properties != null && properties.isCheckDangling();
    }

    static String stringOrNull(String input) {
        return input == null || input.length() == 0 ? null : input;
    }

    private static class IsExplorationString
    extends Property<String> {
        public IsExplorationString() {
            super("Exploration syntax: \"<strategy> <acceptor> [<resultcount>]\"");
        }

        @Override
        public boolean isSatisfied(String value) {
            boolean result = true;
            try {
                Exploration.parse(value);
            }
            catch (FormatException formatException) {
                result = false;
            }
            return result;
        }
    }

    private static class IsExtendedBoolean
    extends Property.IsBoolean {
        public IsExtendedBoolean(String comment) {
            super(comment, true);
        }

        @Override
        public boolean isSatisfied(String value) {
            try {
                return super.isSatisfied(value) || Integer.parseInt(value) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    public static enum Key implements PropertyKey
    {
        GROOVE_VERSION("grooveVersion", PropertyKind.UNMODIFIABLE, "The Groove version that created this grammar"),
        GRAMMAR_VERSION("grammarVersion", PropertyKind.UNMODIFIABLE, "The version of this grammar"),
        REMARK("remark", "A one-line description of the graph production system"),
        ALGEBRA("algebraFamily", PropertyKind.ALGEBRA, "Flag controlling if matches should be injective"),
        INJECTIVE("matchInjective", PropertyKind.BOOLEAN, "Flag controlling if matches should be injective"),
        DANGLING("checkDangling", PropertyKind.BOOLEAN, "Flag controlling if dangling edges should be forbidden rather than deleted"),
        CREATOR_EDGE("checkCreatorEdges", PropertyKind.BOOLEAN, "Flag controlling if creator edges should be treated as implicit NACs"),
        RHS_AS_NAC("rhsIsNAC", PropertyKind.BOOLEAN, "Flag controlling if RHSs should be treated as implicit NACs"),
        ISOMORPHISM("checkIsomorphism", PropertyKind.BOOLEAN, "Flag controlling state graphs are checked up to isomorphism"),
        START_GRAPH_NAMES("startGraph", "Space-separated list of active start graph names"),
        CONTROL_NAMES("controlProgram", "Space-separated list of enabled control programs"),
        TYPE_NAMES("typeGraph", "Space-separated list of active type graph names"),
        PROLOG_NAMES("prolog", "Space-separated list of active prolog program names"),
        CONTROL_LABELS("controlLabels", "A list of rare labels, used to optimise rule matching"),
        COMMON_LABELS("commonLabels", "A list of frequent labels, used to optimise rule matching"),
        ABSTRACTION_LABELS("abstractionLabels", "A list of node labels, used by neighbourhood abstraction"),
        EXPLORATION("explorationStrategy", PropertyKind.EXPLORATION, "Default exploration strtategy for this grammar"),
        TRANSITION_BRACKETS("transitionBrackets", PropertyKind.EXTENDED_BOOLEAN, "Flag controlling if transition labels should be bracketed"),
        TRANSITION_PARAMETERS("transitionParameters", PropertyKind.EXTENDED_BOOLEAN, "Flag controlling if transition labels should include rule parameters"),
        LOOPS_AS_LABELS("loopsAsLabels", PropertyKind.BOOLEAN, "Flag controlling if binary self-edges may be shown as vertex labels");

        private final String name;
        private final String description;
        private final String category;
        private final String defaultValue;
        private final Property<String> format;
        private final boolean system;

        private Key(String text, String comment) {
            this(text, PropertyKind.TRUE, comment);
        }

        private Key(String text, PropertyKind property, String comment) {
            this(text, null, Groove.unCamel(text, false), "", property, comment);
        }

        private Key(String text, String category, String description, String defaultValue, PropertyKind property, String comment) {
            this.name = text;
            this.category = category;
            this.description = description;
            this.defaultValue = defaultValue;
            this.format = property.newInstance(comment);
            this.system = property == PropertyKind.UNMODIFIABLE;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Property<String> getFormat() {
            return this.format;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean isSystem() {
            return this.system;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        private static enum PropertyKind {
            TRUE{

                @Override
                public Property<String> newInstance(String comment) {
                    return new Property.True<String>(comment);
                }
            }
            ,
            BOOLEAN{

                @Override
                public Property<String> newInstance(String comment) {
                    return new Property.IsBoolean(comment, true);
                }
            }
            ,
            EXTENDED_BOOLEAN{

                @Override
                public Property<String> newInstance(String comment) {
                    return new IsExtendedBoolean(comment);
                }
            }
            ,
            ALGEBRA{

                @Override
                public Property<String> newInstance(String comment) {
                    return new Property.Choice<String>(comment, AlgebraFamily.DEFAULT.getName(), AlgebraFamily.POINT.getName(), AlgebraFamily.BIG.getName());
                }
            }
            ,
            EXPLORATION{

                @Override
                public Property<String> newInstance(String comment) {
                    return new IsExplorationString();
                }
            }
            ,
            UNMODIFIABLE{

                @Override
                public Property<String> newInstance(String comment) {
                    return new Property.Unmodifiable<String>(comment);
                }
            };


            public abstract Property<String> newInstance(String var1);
        }
    }
}

