/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.grammar.model.FormatException;
import groove.util.Groove;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QualName
implements Comparable<QualName> {
    private final String parent;
    private final List<String> tokens;
    private final String text;
    public static final String SEPARATOR = ".";
    public static final char SEPARATOR_CHAR = '.';
    private static String PARSE_ERROR_START = "identifiers must begin with a letter or '_'";
    private static String PARSE_ERROR_ILLEGAL_TAIL = "is not allowed in identifiers";
    public static String PARSE_ERROR_EMPTY = "empty identifiers are not allowed";
    public static String PARSE_ERROR_SEPARATOR_BEGIN = "identifiers may not begin with a separator";
    public static String PARSE_ERROR_SEPARATOR_END = "identifiers may not end with a separator";
    public static String PARSE_ERROR_SEPARATOR_CONSECUTIVE = "identifiers may not have consecutive separators";

    public QualName(List<String> tokens) throws FormatException {
        if (tokens.isEmpty()) {
            throw new FormatException("Name is empty", new Object[0]);
        }
        this.tokens = new ArrayList<String>(tokens);
        this.text = Groove.toString(tokens.toArray(), "", "", SEPARATOR, SEPARATOR);
        ArrayList<String> parentTokens = new ArrayList<String>(tokens);
        parentTokens.remove(tokens.size() - 1);
        this.parent = Groove.toString(parentTokens.toArray(), "", "", SEPARATOR, SEPARATOR);
    }

    public void testValid() throws FormatException {
        for (String token : this.tokens) {
            StringBuilder error;
            if (QualName.isValid(token, null, error = new StringBuilder())) continue;
            throw new FormatException("Fragment %s of qualified name %s is not well-formed: %s", token, this.text, error.toString());
        }
    }

    public QualName(String name) throws FormatException {
        this(Arrays.asList(name.split("\\.")));
    }

    public int hashCode() {
        return this.tokens().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualName other = (QualName)obj;
        return this.tokens.equals(other.tokens);
    }

    public String toString() {
        return this.text;
    }

    @Override
    public int compareTo(QualName o) {
        int result = 0;
        int minSize = Math.max(this.size(), o.size());
        int i = 0;
        while (result == 0 && i < minSize) {
            result = this.get(i).compareTo(o.get(i));
            ++i;
        }
        if (result == 0) {
            result = this.size() - o.size();
        }
        return result;
    }

    public String get(int i) {
        return this.tokens().get(i);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public int size() {
        return this.tokens().size();
    }

    public String child() {
        return this.get(this.size() - 1);
    }

    public String parent() {
        return this.parent;
    }

    public List<String> tokens() {
        return this.tokens;
    }

    public QualName extend(String child) throws FormatException {
        ArrayList<String> newTokens = new ArrayList<String>(this.tokens());
        newTokens.add(child);
        return new QualName(newTokens);
    }

    public static String getLastName(String fullName) {
        try {
            return new QualName(fullName).child();
        }
        catch (FormatException formatException) {
            assert (false);
            return null;
        }
    }

    public static String getParent(String fullName) {
        try {
            return new QualName(fullName).parent();
        }
        catch (FormatException formatException) {
            assert (false);
            return null;
        }
    }

    public static String extend(String parent, String child) {
        if (parent == null || parent.isEmpty()) {
            return child;
        }
        return String.valueOf(parent) + SEPARATOR + child;
    }

    public static QualName extend(QualName parent, String child) throws FormatException {
        if (parent == null) {
            return new QualName(child);
        }
        return parent.extend(child);
    }

    private static boolean isValidStarter(char character, boolean hasLegal, StringBuilder legal, boolean hasError, StringBuilder error) {
        if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character == '_') {
            if (hasLegal) {
                legal.append(character);
            }
            return true;
        }
        if (hasLegal) {
            QualName.legalize(character, legal);
        }
        if (hasError && error.length() == 0) {
            error.append(PARSE_ERROR_START);
        }
        return false;
    }

    private static boolean isValidCharacter(char character, boolean hasLegal, StringBuilder legal, boolean hasError, StringBuilder error) {
        if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '_' || character == '-') {
            if (hasLegal) {
                legal.append(character);
            }
            return true;
        }
        if (hasLegal) {
            QualName.legalize(character, legal);
        }
        if (hasError && error.length() == 0) {
            error.append(QualName.PARSE_ERROR_ILLEGAL(character));
        }
        return false;
    }

    private static void legalize(char character, StringBuilder result) {
        switch (character) {
            case '!': {
                result.append("_PLING_");
                break;
            }
            case '@': {
                result.append("_AT_");
                break;
            }
            case '#': {
                result.append("_HASH_");
                break;
            }
            case '$': {
                result.append("_DOLL_");
                break;
            }
            case '%': {
                result.append("_PERC_");
                break;
            }
            case '^': {
                result.append("_HAT_");
                break;
            }
            case '&': {
                result.append("_AMP_");
                break;
            }
            case '*': {
                result.append("_STAR_");
                break;
            }
            case '(': {
                result.append("_LPAR_");
                break;
            }
            case ')': {
                result.append("_RPAR");
                break;
            }
            case ' ': {
                result.append("_SPACE_");
                break;
            }
            case '+': {
                result.append("_PLUS_");
                break;
            }
            case '=': {
                result.append("_EQ_");
                break;
            }
            case '<': {
                result.append("_LT_");
                break;
            }
            case '>': {
                result.append("_GT_");
                break;
            }
            case ',': {
                result.append("_COMMA_");
                break;
            }
            case '?': {
                result.append("_QUERY_");
                break;
            }
            case '-': {
                result.append("_-");
                break;
            }
            default: {
                if (character >= '0' && character <= '9') {
                    result.append("_");
                    result.append(character);
                    break;
                }
                result.append("_UNKN_");
            }
        }
    }

    public static boolean isValid(String fullName) {
        return QualName.isValid(fullName, null, null);
    }

    public static boolean isValid(String id, StringBuilder legal, StringBuilder error) {
        boolean first = true;
        boolean valid = true;
        boolean hasLegal = legal != null;
        boolean hasError = error != null;
        int i = 0;
        while (i < id.length()) {
            if (id.charAt(i) == '.') {
                boolean bl = valid = valid && !first;
                if (first && hasError && error.length() == 0) {
                    if (i == 0) {
                        error.append(PARSE_ERROR_SEPARATOR_BEGIN);
                    } else {
                        error.append(PARSE_ERROR_SEPARATOR_CONSECUTIVE);
                    }
                }
                first = true;
                if (hasLegal) {
                    legal.append('.');
                }
            } else {
                valid = first ? QualName.isValidStarter(id.charAt(i), hasLegal, legal, hasError, error) && valid : QualName.isValidCharacter(id.charAt(i), hasLegal, legal, hasError, error) && valid;
                first = false;
            }
            ++i;
        }
        if (first && valid) {
            if (hasError && error.length() == 0) {
                if (id.length() == 0) {
                    error.append(PARSE_ERROR_EMPTY);
                } else {
                    error.append(PARSE_ERROR_SEPARATOR_END);
                }
            }
            return false;
        }
        return valid;
    }

    private static String PARSE_ERROR_ILLEGAL(char illegal) {
        return "'" + illegal + "' " + PARSE_ERROR_ILLEGAL_TAIL;
    }
}

