/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.model.FormatException;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.util.Pair;

public class AspectParser {
    public static final char ASSIGN = '=';
    public static final char SEPARATOR = ':';
    private static final AspectParser instance = new AspectParser();

    private AspectParser() {
    }

    public AspectLabel parse(String text, GraphRole role) {
        assert (role.inGrammar());
        AspectLabel result = new AspectLabel(role);
        this.parse(text, result);
        result.setFixed();
        return result;
    }

    private void parse(String text, AspectLabel result) {
        Aspect primType;
        int nextSeparator;
        String rest = text;
        boolean stopParsing = false;
        while (!stopParsing && (nextSeparator = rest.indexOf(58)) >= 0) {
            char c;
            StringBuilder prefixBuilder = new StringBuilder();
            int pos = 0;
            while (Character.isLetter(c = rest.charAt(pos))) {
                prefixBuilder.append(c);
                ++pos;
            }
            String prefix = prefixBuilder.toString();
            boolean bl = stopParsing = pos == 0 && nextSeparator != 0 || pos != 0 && EdgeRole.getRole(prefix) != null && pos == nextSeparator;
            if (stopParsing) continue;
            try {
                AspectKind kind = AspectKind.getKind(prefix);
                if (kind == null) {
                    throw new FormatException("Can't parse prefix '%s' (precede with ':' to use literal text)", rest.substring(0, nextSeparator));
                }
                Pair<Aspect, String> parseResult = kind.parseAspect(rest, result.getGraphRole());
                Aspect aspect = parseResult.one();
                result.addAspect(aspect);
                rest = parseResult.two();
                stopParsing = aspect.getKind().isLast();
            }
            catch (FormatException exc) {
                result.addError("%s in '%s'", exc.getMessage(), text);
                stopParsing = true;
            }
        }
        String typePrefix = EdgeRole.NODE_TYPE.getPrefix();
        if (rest.startsWith(typePrefix) && (primType = Aspect.getAspect(rest.substring(typePrefix.length()))) != null && primType.getKind().hasSignature()) {
            result.addAspect(primType);
            rest = "";
        }
        result.setInnerText(rest);
    }

    public static AspectParser getInstance() {
        return instance;
    }
}

