/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.control.CtrlAut;
import groove.explore.Exploration;
import groove.grammar.Action;
import groove.grammar.Grammar;
import groove.grammar.GrammarProperties;
import groove.grammar.QualName;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.host.HostGraph;
import groove.grammar.model.CompositeControlModel;
import groove.grammar.model.CompositeTypeModel;
import groove.grammar.model.ConfigModel;
import groove.grammar.model.ControlModel;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.GroovyModel;
import groove.grammar.model.HostModel;
import groove.grammar.model.PrologModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.RuleModel;
import groove.grammar.model.TextBasedModel;
import groove.grammar.model.TypeModel;
import groove.grammar.type.TypeGraph;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.io.store.EditType;
import groove.io.store.SystemStore;
import groove.io.store.SystemStoreFactory;
import groove.prolog.GrooveEnvironment;
import groove.util.ChangeCount;
import groove.util.Version;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class GrammarModel
implements Observer {
    private final Map<ResourceKind, SortedMap<String, ResourceModel<?>>> resourceMap = new EnumMap(ResourceKind.class);
    private final Map<ResourceKind, SortedSet<String>> storedActiveNamesMap = new EnumMap<ResourceKind, SortedSet<String>>(ResourceKind.class);
    private final Map<ResourceKind, SortedSet<String>> localActiveNamesMap = new EnumMap<ResourceKind, SortedSet<String>>(ResourceKind.class);
    private final SystemStore store;
    private final ChangeCount changeCount;
    private final Map<ResourceKind, ChangeCount> resourceChangeCounts = new EnumMap<ResourceKind, ChangeCount>(ResourceKind.class);
    private boolean isExternalStartGraphModel = false;
    private FormatErrorSet errors;
    private Grammar grammar;
    private GrooveEnvironment prologEnvironment;
    private HostModel startGraphModel;
    private CompositeTypeModel typeModel;
    private CompositeControlModel controlModel;

    public GrammarModel(SystemStore store) {
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            this.resourceMap.put(kind, new TreeMap());
            this.storedActiveNamesMap.put(kind, new TreeSet());
            this.resourceChangeCounts.put(kind, new ChangeCount());
            ++n2;
        }
        this.store = store;
        this.changeCount = new ChangeCount();
        String grammarVersion = store.getProperties().getGrammarVersion();
        boolean noActiveStartGraphs = store.getProperties().getActiveNames(ResourceKind.HOST).isEmpty();
        if (Version.compareGrammarVersions(grammarVersion, "3.2") < 0 && noActiveStartGraphs) {
            this.setLocalActiveNames(ResourceKind.HOST, "start");
        }
        for (ResourceKind resource : ResourceKind.all(false)) {
            this.syncResource(resource);
        }
    }

    public String getName() {
        return this.store.getName();
    }

    public SystemStore getStore() {
        return this.store;
    }

    public GrammarProperties getProperties() {
        return this.store.getProperties();
    }

    public Set<String> getNames(ResourceKind kind) {
        if (kind == ResourceKind.PROPERTIES) {
            return null;
        }
        if (kind.isTextBased()) {
            return this.getStore().getTexts(kind).keySet();
        }
        return this.getStore().getGraphs(kind).keySet();
    }

    public Map<String, ? extends ResourceModel<?>> getResourceMap(ResourceKind kind) {
        return this.resourceMap.get((Object)kind);
    }

    public Collection<ResourceModel<?>> getResourceSet(ResourceKind kind) {
        return this.resourceMap.get((Object)kind).values();
    }

    public GraphBasedModel<?> getGraphResource(ResourceKind kind, String name) {
        assert (kind.isGraphBased()) : String.format("Resource kind %s is not graph-based", new Object[]{kind});
        return (GraphBasedModel)this.getResourceMap(kind).get(name);
    }

    public TextBasedModel<?> getTextResource(ResourceKind kind, String name) {
        assert (kind.isTextBased()) : String.format("Resource kind %s is not text-based", new Object[]{kind});
        return (TextBasedModel)this.getResourceMap(kind).get(name);
    }

    public ResourceModel<?> getResource(ResourceKind kind, String name) {
        assert (name != null);
        return this.getResourceMap(kind).get(name);
    }

    public Set<String> getActiveNames(ResourceKind kind) {
        Set result = this.localActiveNamesMap.get((Object)kind);
        if (result == null) {
            result = this.storedActiveNamesMap.get((Object)kind);
        }
        result.retainAll(this.getNames(kind));
        return Collections.unmodifiableSet(result);
    }

    public Set<String> getLocalActiveNames(ResourceKind kind) {
        Set result = this.localActiveNamesMap.get((Object)kind);
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableSet(result);
    }

    public void setLocalActiveNames(ResourceKind kind, String ... names) {
        this.setLocalActiveNames(kind, Arrays.asList(names));
    }

    public void setLocalActiveNames(ResourceKind kind, Collection<String> names) {
        assert (names != null);
        this.localActiveNamesMap.put(kind, new TreeSet<String>(names));
        this.resourceChangeCounts.get((Object)kind).increase();
        this.invalidate();
    }

    public void resetLocalActiveNames(ResourceKind kind) {
        this.localActiveNamesMap.remove((Object)kind);
    }

    public HostModel getHostModel(String name) {
        return (HostModel)this.getResourceMap(ResourceKind.HOST).get(name);
    }

    public ControlModel getControlModel(String name) {
        return (ControlModel)this.getResource(ResourceKind.CONTROL, name);
    }

    public PrologModel getPrologModel(String name) {
        return (PrologModel)this.getResourceMap(ResourceKind.PROLOG).get(name);
    }

    public RuleModel getRuleModel(String name) {
        return (RuleModel)this.getResourceMap(ResourceKind.RULE).get(name);
    }

    public TypeModel getTypeModel(String name) {
        return (TypeModel)this.getResourceMap(ResourceKind.TYPE).get(name);
    }

    public CompositeTypeModel getTypeModel() {
        if (this.typeModel == null) {
            this.typeModel = new CompositeTypeModel(this);
        }
        return this.typeModel;
    }

    public CompositeControlModel getControlModel() {
        if (this.controlModel == null) {
            this.controlModel = new CompositeControlModel(this);
        }
        return this.controlModel;
    }

    public TypeGraph getTypeGraph() {
        return this.getTypeModel().getTypeGraph();
    }

    public HostModel getStartGraphModel() {
        if (this.startGraphModel == null) {
            TreeMap<String, AspectGraph> graphMap = new TreeMap<String, AspectGraph>();
            for (String name : this.getActiveNames(ResourceKind.HOST)) {
                graphMap.put(name, this.getStore().getGraphs(ResourceKind.HOST).get(name));
            }
            AspectGraph startGraph = AspectGraph.mergeGraphs(graphMap.values());
            if (startGraph != null) {
                this.startGraphModel = new HostModel(this, startGraph);
            }
        }
        return this.startGraphModel;
    }

    public void setStartGraph(AspectGraph startGraph) {
        assert (startGraph != null);
        if (startGraph.getRole() != GraphRole.HOST) {
            throw new IllegalArgumentException(String.format("Prospective start graph '%s' is not a graph", startGraph));
        }
        this.startGraphModel = new HostModel(this, startGraph);
        this.isExternalStartGraphModel = true;
        this.resourceChangeCounts.get((Object)ResourceKind.HOST).increase();
        this.invalidate();
    }

    public FormatErrorSet getErrors() {
        if (this.errors == null) {
            this.initGrammar();
        }
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public ChangeCount.Tracker createChangeTracker() {
        return this.changeCount.createTracker();
    }

    public ChangeCount.Tracker createChangeTracker(ResourceKind kind) {
        return this.resourceChangeCounts.get((Object)kind).createTracker();
    }

    public Grammar toGrammar() throws FormatException {
        if (this.errors == null) {
            this.initGrammar();
        }
        this.errors.throwException();
        return this.grammar;
    }

    private void initGrammar() {
        this.errors = new FormatErrorSet();
        try {
            this.grammar = this.computeGrammar();
        }
        catch (FormatException exc) {
            this.errors.addAll(exc.getErrors());
        }
        this.getPrologEnvironment();
        for (ResourceModel<?> prologModel : this.getResourceSet(ResourceKind.PROLOG)) {
            for (FormatError formatError : prologModel.getErrors()) {
                this.errors.add("Error in prolog program '%s': %s", prologModel.getFullName(), formatError, prologModel);
            }
        }
        for (ResourceKind kind : ResourceKind.all(false)) {
            for (ResourceModel resourceModel : this.getResourceSet(kind)) {
                if (QualName.isValid(resourceModel.getFullName(), null, null)) continue;
                this.errors.add(new FormatError(String.valueOf(kind.getName()) + " name '" + resourceModel.getFullName() + "' " + "is an illegal identifier", resourceModel));
            }
        }
    }

    public boolean hasRules() {
        return !this.getResourceSet(ResourceKind.RULE).isEmpty();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Grammar computeGrammar() throws FormatException {
        result = new Grammar(this.getName());
        errors = new FormatErrorSet();
        result.setTypeGraph(this.getTypeGraph());
        errors.addAll(this.getTypeModel().getErrors());
        block4: for (ResourceModel<?> ruleModel : this.getResourceSet(ResourceKind.RULE)) {
            try {
                if (!ruleModel.isEnabled()) continue;
                result.add((Action)((RuleModel)ruleModel).toResource());
                continue;
            }
            catch (FormatException exc) {
                ** for (error : exc.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                errors.add("Error in rule '%s': %s", new Object[]{ruleModel.getFullName(), error, ruleModel.getSource()});
                continue;
lbl16:
                // 1 sources

            }
        }
        control = (CtrlAut)this.getControlModel().toResource();
        if (result.hasMultiplePriorities() && !this.getActiveNames(ResourceKind.CONTROL).isEmpty()) {
            errors.add("Rule priorities and explicit control cannot be used simultaneously", new Object[0]);
        }
        result.setCtrlAut(control);
        result.setProperties(this.getProperties());
        if (this.getStartGraphModel() == null) {
            startGraphNames = this.getActiveNames(ResourceKind.HOST);
            if (startGraphNames.isEmpty()) {
                errors.add("No start graph set", new Object[0]);
            } else {
                errors.add("Start graph '%s' cannot be loaded", new Object[]{startGraphNames});
            }
        } else {
            try {
                startGraph = (HostGraph)this.getStartGraphModel().toResource();
                result.setStartGraph(startGraph);
                startGraphErrors /* !! */  = GraphInfo.getErrors(startGraph);
            }
            catch (FormatException exc) {
                startGraphErrors /* !! */  = exc.getErrors();
            }
            for (FormatError error : startGraphErrors /* !! */ ) {
                errors.add("Error in start graph: %s", new Object[]{error, this.getStartGraphModel().getSource()});
            }
        }
        result.setPrologEnvironment(this.getPrologEnvironment());
        errors.throwException();
        if (!GrammarModel.$assertionsDisabled && result.getCtrlAut() == null) {
            throw new AssertionError((Object)"Grammar must have control");
        }
        result.setFixed();
        return result;
    }

    public GrooveEnvironment getPrologEnvironment() {
        if (this.prologEnvironment == null) {
            this.prologEnvironment = new GrooveEnvironment(null, null);
            for (ResourceModel<?> model : this.getResourceSet(ResourceKind.PROLOG)) {
                PrologModel prologModel = (PrologModel)model;
                if (!model.isEnabled()) continue;
                try {
                    this.prologEnvironment.loadProgram(prologModel.getProgram());
                    prologModel.clearErrors();
                }
                catch (FormatException e) {
                    prologModel.setErrors(e.getErrors());
                }
            }
        }
        return this.prologEnvironment;
    }

    private void invalidate() {
        this.changeCount.increase();
        this.grammar = null;
        this.errors = null;
        if (!this.isExternalStartGraphModel) {
            this.startGraphModel = null;
        }
    }

    @Override
    public void update(Observable source, Object obj) {
        SystemStore.Edit edit = (SystemStore.Edit)obj;
        if (edit.getType() != EditType.LAYOUT) {
            Set<ResourceKind> change = edit.getChange();
            for (ResourceKind resource : change) {
                this.syncResource(resource);
            }
            this.invalidate();
        }
    }

    private void syncResource(ResourceKind kind) {
        this.resourceChangeCounts.get((Object)kind).increase();
        switch (kind) {
            case PROLOG: {
                this.prologEnvironment = null;
                break;
            }
            case PROPERTIES: {
                return;
            }
        }
        Map modelMap = this.resourceMap.get((Object)kind);
        Map<String, Object> sourceMap = kind.isGraphBased() ? this.getStore().getGraphs(kind) : this.getStore().getTexts(kind);
        modelMap.keySet().retainAll(sourceMap.keySet());
        TreeSet<String> newActiveNames = new TreeSet<String>();
        if (kind != ResourceKind.RULE && kind != ResourceKind.GROOVY && kind != ResourceKind.CONFIG) {
            newActiveNames.addAll(this.getProperties().getActiveNames(kind));
        }
        for (Map.Entry<String, Object> sourceEntry : sourceMap.entrySet()) {
            String name = sourceEntry.getKey();
            Object source = sourceEntry.getValue();
            ResourceModel<?> model = (ResourceModel<?>)modelMap.get(name);
            if (model == null || model.getSource() != source) {
                model = this.createModel(kind, name);
                modelMap.put(name, model);
            }
            if (kind != ResourceKind.RULE || !GraphInfo.isEnabled((AspectGraph)model.getSource())) continue;
            newActiveNames.add(name);
        }
        Set oldActiveNames = this.storedActiveNamesMap.get((Object)kind);
        if (!oldActiveNames.equals(newActiveNames)) {
            oldActiveNames.clear();
            oldActiveNames.addAll(newActiveNames);
            this.resetLocalActiveNames(kind);
        }
    }

    private ResourceModel<?> createModel(ResourceKind kind, String name) {
        ResourceModel result;
        block10: {
            block9: {
                result = null;
                if (!kind.isGraphBased()) break block9;
                AspectGraph graph = this.getStore().getGraphs(kind).get(name);
                if (graph == null) break block10;
                result = this.createGraphModel(graph);
                break block10;
            }
            assert (kind.isTextBased());
            String text = this.getStore().getTexts(kind).get(name);
            if (text != null) {
                switch (kind) {
                    case CONTROL: {
                        result = new ControlModel(this, name, text);
                        break;
                    }
                    case PROLOG: {
                        result = new PrologModel(this, name, text);
                        break;
                    }
                    case GROOVY: {
                        result = new GroovyModel(this, name, text);
                        break;
                    }
                    case CONFIG: {
                        result = new ConfigModel(this, name, text);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
        }
        return result;
    }

    public GraphBasedModel<?> createGraphModel(AspectGraph graph) {
        GraphBasedModel result = null;
        switch (graph.getRole()) {
            case HOST: {
                result = new HostModel(this, graph);
                break;
            }
            case RULE: {
                result = new RuleModel(this, graph);
                break;
            }
            case TYPE: {
                result = new TypeModel(this, graph);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    public Exploration getDefaultExploration() {
        if (this.getProperties().getExploration() == null) {
            return null;
        }
        try {
            return Exploration.parse(this.getProperties().getExploration());
        }
        catch (FormatException formatException) {
            return null;
        }
    }

    public static GrammarModel newInstance(URL url) throws IllegalArgumentException, IOException {
        SystemStore store = SystemStoreFactory.newStore(url);
        store.reload();
        GrammarModel result = store.toGrammarModel();
        return result;
    }

    public static GrammarModel newInstance(File file, boolean create) throws IOException {
        SystemStore store = SystemStoreFactory.newStore(file, create);
        store.reload();
        GrammarModel result = store.toGrammarModel();
        return result;
    }

    public static GrammarModel newInstance(String location) throws IllegalArgumentException, IOException {
        try {
            return GrammarModel.newInstance(new URL(location));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return GrammarModel.newInstance(new File(location), false);
        }
        catch (IOException iOException) {
            return GrammarModel.newInstance(new File(location), false);
        }
    }

    public static enum Manipulation {
        ADD,
        REMOVE,
        SET,
        TOGGLE;


        public static boolean apply(Set<String> set, Manipulation manipulation, Set<String> selected) {
            switch (manipulation) {
                case ADD: {
                    return set.addAll(selected);
                }
                case REMOVE: {
                    return set.removeAll(selected);
                }
                case SET: {
                    boolean changed = set.equals(selected);
                    set.clear();
                    set.addAll(selected);
                    return changed;
                }
                case TOGGLE: {
                    for (String text : selected) {
                        if (set.remove(text)) continue;
                        set.add(text);
                    }
                    return !selected.isEmpty();
                }
            }
            return false;
        }

        public static boolean apply(Set<String> set, Manipulation manipulation, String selected) {
            HashSet<String> temp = new HashSet<String>();
            temp.add(selected);
            return Manipulation.apply(set, manipulation, temp);
        }
    }
}

