/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.grammar.AnchorKind;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeNode;
import groove.graph.AEdge;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RuleEdge
extends AEdge<RuleNode, RuleLabel>
implements RuleElement {
    private final TypeEdge type;
    private final List<TypeGuard> typeGuards;
    private Set<LabelVar> vars;
    private final Set<TypeEdge> matchingTypes;

    public RuleEdge(RuleNode source, RuleLabel label, TypeEdge type, RuleNode target) {
        super(source, label, target);
        assert (label.getTypeLabel() == null || label.getTypeLabel().equals(type.label()));
        this.type = type;
        TypeGuard guard = label.getWildcardGuard();
        if (guard != null) {
            this.typeGuards = guard.isNamed() ? Collections.singletonList(guard) : Collections.emptyList();
            TypeGraph typeGraph = source.getType().getGraph();
            if (typeGraph == null) {
                this.matchingTypes = Collections.emptySet();
            } else {
                this.matchingTypes = new HashSet<TypeEdge>();
                for (TypeEdge typeEdge : typeGraph.edgeSet()) {
                    if (!((TypeNode)typeEdge.source()).getSubtypes().contains(source.getType()) || !((TypeNode)typeEdge.target()).getSubtypes().contains(target.getType()) || !guard.isSatisfied(typeEdge)) continue;
                    this.matchingTypes.add(typeEdge);
                }
            }
        } else if (type == null) {
            this.matchingTypes = Collections.emptySet();
            this.typeGuards = Collections.emptyList();
        } else {
            this.matchingTypes = new HashSet<TypeEdge>(type.getSubtypes());
            this.typeGuards = Collections.emptyList();
        }
    }

    @Override
    public TypeEdge getType() {
        return this.type;
    }

    public Set<TypeEdge> getMatchingTypes() {
        return this.matchingTypes;
    }

    @Override
    public List<TypeGuard> getTypeGuards() {
        return this.typeGuards;
    }

    @Override
    public Set<LabelVar> getVars() {
        Set<LabelVar> result = this.vars;
        if (result == null) {
            result = this.vars = new HashSet<LabelVar>();
            for (TypeGuard guard : this.getTypeGuards()) {
                if (!guard.isNamed()) continue;
                result.add(guard.getVar());
            }
        }
        return result;
    }

    public void setWildcardTypes(Set<TypeEdge> wildcardTypes) {
        assert (((RuleLabel)this.label).isWildcard());
        this.matchingTypes.retainAll(wildcardTypes);
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.EDGE;
    }
}

