/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.algebra.Operator;
import groove.algebra.Term;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.OperatorNode;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleGraphMorphism;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.VariableNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeFactory;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.ElementFactory;
import groove.graph.Label;
import java.util.List;

public class RuleFactory
implements ElementFactory<RuleNode, RuleEdge> {
    private final TypeFactory typeFactory;
    private int maxNodeNr;

    private RuleFactory(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public RuleNode createNode(int nr) {
        return this.createNode(nr, TypeLabel.NODE, true, null);
    }

    public DefaultRuleNode createNode(int nr, TypeLabel typeLabel, boolean sharp, List<TypeGuard> typeGuards) {
        this.updateMaxNodeNr(nr);
        TypeNode type = this.getTypeFactory().createNode(typeLabel);
        return new DefaultRuleNode(nr, type, sharp, typeGuards);
    }

    public VariableNode createVariableNode(int nr, Term term) {
        this.updateMaxNodeNr(nr);
        TypeNode type = this.getTypeFactory().getDataType(term.getSignature());
        return new VariableNode(nr, term, type);
    }

    public OperatorNode createOperatorNode(int nr, Operator operator, List<VariableNode> arguments, VariableNode target) {
        this.updateMaxNodeNr(nr);
        return new OperatorNode(nr, operator, arguments, target);
    }

    @Override
    public RuleLabel createLabel(String text) {
        return new RuleLabel(text);
    }

    @Override
    public RuleEdge createEdge(RuleNode source, String text, RuleNode target) {
        return this.createEdge(source, (Label)this.createLabel(text), target);
    }

    @Override
    public RuleEdge createEdge(RuleNode source, Label label, RuleNode target) {
        RuleLabel ruleLabel = (RuleLabel)label;
        TypeLabel typeLabel = ruleLabel.getTypeLabel();
        TypeEdge type = typeLabel == null ? null : this.getTypeFactory().createEdge(source.getType(), typeLabel, target.getType(), false);
        return new RuleEdge(source, ruleLabel, type, target);
    }

    public RuleGraphMorphism createMorphism() {
        return new RuleGraphMorphism();
    }

    @Override
    public int getMaxNodeNr() {
        return this.maxNodeNr;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    private void updateMaxNodeNr(int nr) {
        this.maxNodeNr = Math.max(this.maxNodeNr, nr);
    }

    public static RuleFactory newInstance() {
        return RuleFactory.newInstance(TypeFactory.newInstance());
    }

    public static RuleFactory newInstance(TypeFactory typeFactory) {
        return new RuleFactory(typeFactory);
    }
}

