/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.grammar.model.FormatException;
import groove.util.Duo;
import java.io.Serializable;

public class Multiplicity
extends Duo<Integer> {
    public static final String MULT_SEPARATOR = "..";
    public static final String UNBOUNDED = "*";

    public Multiplicity(Integer lower, Integer upper) {
        super(lower, upper);
        this.setFixed();
    }

    public Multiplicity(int lower, boolean unbounded) {
        super(lower, unbounded ? Integer.MAX_VALUE : lower);
    }

    @Override
    public String toString() {
        if (((Integer)this.one()).equals(this.two()) && !this.isUnbounded()) {
            return ((Integer)this.one()).toString();
        }
        if ((Integer)this.one() == 0 && this.isUnbounded()) {
            return UNBOUNDED;
        }
        StringBuilder result = new StringBuilder(((Integer)this.one()).toString());
        result.append(MULT_SEPARATOR);
        result.append(this.isUnbounded() ? UNBOUNDED : (Serializable)this.two());
        return result.toString();
    }

    public boolean isUnbounded() {
        return (Integer)this.two() == Integer.MAX_VALUE;
    }

    public static Multiplicity parse(String text) throws FormatException {
        int upper;
        int lower;
        try {
            int dotdot = text.indexOf(MULT_SEPARATOR);
            if (dotdot < 0) {
                if (UNBOUNDED.equals(text)) {
                    lower = 0;
                    upper = Integer.MAX_VALUE;
                } else {
                    lower = upper = Integer.parseInt(text);
                }
            } else {
                lower = Integer.parseInt(text.substring(0, dotdot));
                String upperText = text.substring(dotdot + MULT_SEPARATOR.length());
                upper = upperText.equals(UNBOUNDED) ? Integer.MAX_VALUE : Integer.parseInt(upperText);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException("Malformed multiplicity value %s", text);
        }
        if (lower < 0) {
            throw new FormatException("Negative lower bound %d", lower);
        }
        if (lower > upper) {
            throw new FormatException("Lower bound %d larger than upper bound %d", lower, upper);
        }
        return new Multiplicity((Integer)lower, upper);
    }

    public boolean inRange(int count) {
        return (Integer)this.one() <= count && count <= (Integer)this.two();
    }
}

