/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.grammar.AnchorKind;
import groove.grammar.type.Multiplicity;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.AEdge;
import groove.graph.EdgeRole;
import groove.graph.Label;
import java.util.Set;

public class TypeEdge
extends AEdge<TypeNode, TypeLabel>
implements TypeElement {
    private final TypeGraph graph;
    private boolean abstractType;
    private boolean iscomposite;
    private Multiplicity inMult;
    private Multiplicity outMult;

    TypeEdge(TypeNode source, TypeLabel label, TypeNode target, TypeGraph graph) {
        super(source, label, target);
        assert (graph != null);
        assert (source.equals(target) || label.getRole() == EdgeRole.BINARY) : String.format("Can't create %s label %s between distinct nodes %s and %s", label.getRole().getDescription(false), label, source, target);
        this.graph = graph;
    }

    public final boolean isAbstract() {
        return this.abstractType;
    }

    public final boolean isComposite() {
        return this.iscomposite;
    }

    public final void setAbstract(boolean value) {
        this.abstractType = value;
    }

    public final void setComposite(boolean value) {
        this.iscomposite = value;
    }

    public Multiplicity getInMult() {
        return this.inMult;
    }

    public Multiplicity getOutMult() {
        return this.outMult;
    }

    public void setInMult(Multiplicity inMult) {
        this.inMult = inMult;
    }

    public void setOutMult(Multiplicity outMult) {
        this.outMult = outMult;
    }

    public boolean subsumes(TypeEdge other) {
        if (this == other) {
            return true;
        }
        return this.isAbstract() && this.getGraph().isSubtype(other, this);
    }

    @Override
    public String text() {
        return ((TypeLabel)this.label()).text();
    }

    @Override
    public int compareTo(Label o) {
        int result;
        assert (o instanceof TypeElement);
        if (o instanceof TypeNode) {
            result = -o.compareTo(this);
        } else {
            TypeEdge edge = (TypeEdge)o;
            result = ((TypeNode)this.source()).compareTo((Label)edge.source());
            if (result == 0) {
                result = ((TypeLabel)this.label()).compareTo((Label)edge.label());
            }
        }
        return result;
    }

    @Override
    public TypeGraph getGraph() {
        return this.graph;
    }

    public Set<TypeEdge> getSubtypes() {
        return this.getGraph().getSubtypes(this);
    }

    public Set<TypeEdge> getSupertypes() {
        return this.getGraph().getSupertypes(this);
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.LABEL;
    }
}

