/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.grammar.rule.LabelVar;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.graph.Label;
import groove.util.Groove;
import groove.util.Property;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TypeGuard
extends Property<TypeElement> {
    private final LabelVar var;
    private List<String> textList;
    private Set<TypeLabel> labelSet;
    private boolean negated;
    public static final char OPEN = '[';
    public static final char CLOSE = ']';
    public static final char NEGATOR = '^';
    public static final char SEPARATOR = ',';

    public TypeGuard(LabelVar var) {
        this.var = var;
    }

    public LabelVar getVar() {
        return this.var;
    }

    public boolean isNamed() {
        return this.getVar().hasName();
    }

    public EdgeRole getKind() {
        return this.getVar().getKind();
    }

    public void setLabels(List<String> textList, boolean negated) {
        this.textList = textList;
        this.labelSet = new HashSet<TypeLabel>();
        for (String text : textList) {
            this.labelSet.add(TypeLabel.createLabel(this.getKind(), text));
        }
        this.negated = negated;
    }

    public TypeGuard relabel(Label oldLabel, Label newLabel) {
        TypeGuard result = this;
        if (this.labelSet != null && this.labelSet.contains(oldLabel)) {
            int index = this.textList.indexOf(oldLabel.text());
            ArrayList<String> newTextList = new ArrayList<String>(this.textList);
            if (newLabel.getRole() == this.getKind() && !this.labelSet.contains(newLabel)) {
                newTextList.set(index, newLabel.text());
            } else {
                newTextList.remove(index);
            }
            result = new TypeGuard(this.var);
            result.setLabels(newTextList, this.negated);
        }
        return result;
    }

    public Set<TypeLabel> getLabels() {
        return this.labelSet;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public boolean isSatisfied(TypeElement type) {
        if (this.getKind() != (type instanceof TypeNode ? EdgeRole.NODE_TYPE : ((TypeEdge)type).getRole())) {
            return false;
        }
        if (this.labelSet == null) {
            return true;
        }
        boolean valueFound = this.labelSet.contains(type.label());
        if (!valueFound) {
            for (TypeElement typeElement : type.getSupertypes()) {
                if (!this.labelSet.contains(typeElement.label())) continue;
                valueFound = true;
                break;
            }
        }
        return this.negated ^ valueFound;
    }

    public String toString() {
        String result = "";
        if (this.labelSet != null) {
            result = String.valueOf(result) + '[';
            if (this.negated) {
                result = String.valueOf(result) + '^';
            }
            result = Groove.toString(this.textList.toArray(), result, "]", ",");
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.labelSet == null ? 0 : this.labelSet.hashCode());
        result = 31 * result + (this.negated ? 1231 : 1237);
        result = 31 * result + (this.textList == null ? 0 : this.textList.hashCode());
        result = 31 * result + this.var.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeGuard)) {
            return false;
        }
        TypeGuard other = (TypeGuard)obj;
        if (this.labelSet == null ? other.labelSet != null : !this.labelSet.equals(other.labelSet)) {
            return false;
        }
        if (this.negated != other.negated) {
            return false;
        }
        if (this.textList == null ? other.textList != null : !this.textList.equals(other.textList)) {
            return false;
        }
        return this.var.equals(other.var);
    }
}

