/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.Label;
import groove.graph.Node;

public abstract class AEdge<N extends Node, L extends Label>
implements Edge {
    protected final N source;
    protected final N target;
    protected final L label;
    private int hashCode;
    private static final int SOURCE_SHIFT = 1;
    private static final int TARGET_SHIFT = 2;
    private static final int BIT_COUNT = 32;
    private static final int SOURCE_RIGHT_SHIFT = 31;
    private static final int TARGET_RIGHT_SHIFT = 30;

    protected AEdge(N source, L label, N target) {
        assert (source != null && label != null && target != null);
        this.source = source;
        this.label = label;
        this.target = target;
    }

    public N source() {
        return this.source;
    }

    public N target() {
        return this.target;
    }

    public L label() {
        return this.label;
    }

    @Override
    public boolean isLoop() {
        return this.source() == this.target();
    }

    public String toString() {
        return this.source() + "--" + this.getLabelText() + "-->" + this.target();
    }

    protected String getLabelText() {
        return this.label().text();
    }

    public AEdge<N, L> clone() {
        return this;
    }

    public final int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            result = this.computeHashCode();
            if (result == 0) {
                result = 1;
            }
            this.hashCode = result;
        }
        return result;
    }

    protected int computeHashCode() {
        int labelCode = this.label().hashCode();
        int sourceCode = 3 * this.source.hashCode();
        int targetCode = (labelCode + 2) * this.target.hashCode();
        return labelCode ^ (sourceCode << 1) + (sourceCode >>> 31) + ((targetCode << 2) + (targetCode >>> 30));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.isTypeEqual(obj) && this.isEndEqual((Edge)obj) && this.isLabelEqual((Edge)obj);
    }

    protected boolean isEndEqual(Edge other) {
        return this.source.equals(other.source()) && this.target.equals(other.target());
    }

    protected boolean isTypeEqual(Object obj) {
        return obj instanceof Edge;
    }

    protected boolean isLabelEqual(Edge other) {
        return this.label().equals(other.label());
    }

    @Override
    public EdgeRole getRole() {
        return this.label().getRole();
    }
}

