/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.AGraph;
import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.GGraph;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class NodeSetEdgeSetGraph<N extends Node, E extends Edge>
extends AGraph<N, E>
implements Cloneable {
    protected final Set<E> graphEdgeSet;
    protected final Set<N> graphNodeSet;

    public NodeSetEdgeSetGraph(String name) {
        super(name);
        this.graphNodeSet = this.createNodeSet();
        this.graphEdgeSet = this.createEdgeSet();
    }

    public NodeSetEdgeSetGraph(GGraph<N, E> graph) {
        super(graph.getName());
        this.graphNodeSet = this.createNodeSet(graph.nodeSet());
        this.graphEdgeSet = this.createEdgeSet(graph.edgeSet());
        GraphInfo.transfer(graph, this, null);
    }

    @Override
    public boolean addNode(N node) {
        assert (!this.isFixed()) : "Trying to add " + node + " to unmodifiable graph";
        boolean result = this.graphNodeSet.add(node);
        return result;
    }

    @Override
    public boolean removeNodeContext(N node) {
        assert (!this.isFixed()) : "Trying to remove " + node + " from unmodifiable graph";
        boolean removed = this.graphNodeSet.contains(node);
        if (removed) {
            Iterator<E> edgeIter = this.graphEdgeSet.iterator();
            while (edgeIter.hasNext()) {
                Edge edge = (Edge)edgeIter.next();
                if (!edge.source().equals(node) && !edge.target().equals(node)) continue;
                edgeIter.remove();
            }
            this.removeNode(node);
        }
        return removed;
    }

    @Override
    public boolean removeEdge(E edge) {
        assert (!this.isFixed()) : "Trying to remove " + edge + " from unmodifiable graph";
        return this.graphEdgeSet.remove(edge);
    }

    @Override
    public boolean removeNodeSetContext(Collection<? extends N> nodeSet) {
        Iterator<E> edgeIter = this.graphEdgeSet.iterator();
        while (edgeIter.hasNext()) {
            Edge other = (Edge)edgeIter.next();
            if (!nodeSet.contains(other.source()) && !nodeSet.contains(other.target())) continue;
            edgeIter.remove();
        }
        boolean result = this.removeNodeSet(nodeSet);
        return result;
    }

    @Override
    public boolean addEdge(E edge) {
        assert (this.isTypeCorrect((Edge)edge));
        boolean result = this.graphEdgeSet.add(edge);
        return result;
    }

    @Override
    public boolean removeNode(N node) {
        assert (this.isTypeCorrect((Node)node));
        boolean result = this.graphNodeSet.remove(node);
        return result;
    }

    @Override
    public boolean removeNodeSet(Collection<? extends N> nodeSet) {
        return this.graphNodeSet.removeAll(nodeSet);
    }

    @Override
    public NodeSetEdgeSetGraph<N, E> clone() {
        NodeSetEdgeSetGraph<N, E> result = new NodeSetEdgeSetGraph<N, E>(this);
        return result;
    }

    @Override
    public NodeSetEdgeSetGraph<N, E> newGraph(String name) {
        return new NodeSetEdgeSetGraph<N, E>(this.getName());
    }

    @Override
    public Set<? extends E> edgeSet() {
        return Collections.unmodifiableSet(this.graphEdgeSet);
    }

    @Override
    public Set<? extends N> nodeSet() {
        return Collections.unmodifiableSet(this.graphNodeSet);
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.NONE;
    }

    protected Set<N> createNodeSet() {
        return new NodeNotifySet();
    }

    protected Set<E> createEdgeSet() {
        return new EdgeNotifySet();
    }

    protected Set<N> createNodeSet(Set<? extends N> nodeSet) {
        return new NodeNotifySet(nodeSet);
    }

    protected Set<E> createEdgeSet(Set<? extends E> edgeSet) {
        return new EdgeNotifySet(edgeSet);
    }

    private class EdgeNotifySet
    extends NotifySet<E> {
        public EdgeNotifySet() {
        }

        public EdgeNotifySet(Set<? extends E> init) {
            super(init);
        }

        @Override
        protected final void fireAdd(E elem) {
            NodeSetEdgeSetGraph.this.fireAddEdge(elem);
        }

        @Override
        protected final void fireRemove(E elem) {
            NodeSetEdgeSetGraph.this.fireRemoveEdge(elem);
        }
    }

    private class NodeNotifySet
    extends NotifySet<N> {
        public NodeNotifySet() {
        }

        public NodeNotifySet(Set<? extends N> init) {
            super(init);
        }

        @Override
        protected final void fireAdd(N elem) {
            NodeSetEdgeSetGraph.this.fireAddNode(elem);
        }

        @Override
        protected final void fireRemove(N elem) {
            NodeSetEdgeSetGraph.this.fireRemoveNode(elem);
        }
    }

    private abstract class NotifySet<EL extends Element>
    extends LinkedHashSet<EL> {
        public NotifySet() {
        }

        public NotifySet(Set<? extends EL> init) {
            for (Element elem : init) {
                super.add(elem);
            }
        }

        @Override
        public Iterator<EL> iterator() {
            return new NotifySetIterator();
        }

        Iterator<EL> superIterator() {
            return super.iterator();
        }

        @Override
        public final boolean add(EL elem) {
            if (super.add(elem)) {
                if (elem instanceof Node) {
                    NodeSetEdgeSetGraph.this.fireAddNode((Node)elem);
                } else {
                    NodeSetEdgeSetGraph.this.fireAddEdge((Edge)elem);
                }
                return true;
            }
            return false;
        }

        @Override
        public final boolean addAll(Collection<? extends EL> elemSet) {
            boolean added = false;
            for (Element elem : elemSet) {
                added |= this.add((EL)elem);
            }
            return added;
        }

        @Override
        public final boolean remove(Object elem) {
            if (super.remove(elem)) {
                if (elem instanceof Node) {
                    NodeSetEdgeSetGraph.this.fireRemoveNode((Node)elem);
                } else {
                    NodeSetEdgeSetGraph.this.fireRemoveEdge((Edge)elem);
                }
                return true;
            }
            return false;
        }

        @Override
        public final boolean removeAll(Collection<?> elemSet) {
            boolean removed = false;
            for (Object elem : elemSet) {
                removed |= this.remove(elem);
            }
            return removed;
        }

        protected abstract void fireAdd(EL var1);

        protected abstract void fireRemove(EL var1);

        class NotifySetIterator
        implements Iterator<EL> {
            private final Iterator<EL> setIterator;
            EL latest;

            NotifySetIterator() {
                this.setIterator = NotifySet.this.superIterator();
            }

            @Override
            public boolean hasNext() {
                return this.setIterator.hasNext();
            }

            @Override
            public EL next() {
                this.latest = (Element)this.setIterator.next();
                return this.latest;
            }

            @Override
            public void remove() {
                this.setIterator.remove();
                if (this.latest instanceof Node) {
                    NodeSetEdgeSetGraph.this.fireRemoveNode((Node)this.latest);
                } else {
                    NodeSetEdgeSetGraph.this.fireRemoveEdge((Edge)this.latest);
                }
            }
        }
    }
}

