/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import groove.grammar.model.ResourceKind;
import groove.io.store.EditType;
import groove.util.Groove;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public final class Icons {
    public static final ImageIcon ARROW_OPEN_UP_ICON = Icons.createIcon("arrow-open-up.gif");
    public static final ImageIcon ARROW_OPEN_DOWN_ICON = Icons.createIcon("arrow-open-down.gif");
    public static final ImageIcon ARROW_SIMPLE_DOWN_ICON = Icons.createIcon("arrow-simple-down.gif");
    public static final ImageIcon ARROW_SIMPLE_LEFT_ICON = Icons.createIcon("arrow-wide-left.gif");
    public static final ImageIcon ARROW_SIMPLE_RIGHT_ICON = Icons.createIcon("arrow-wide-right.gif");
    public static final ImageIcon ARROW_SIMPLE_UP_ICON = Icons.createIcon("arrow-simple-up.gif");
    public static final ImageIcon CANCEL_ICON = Icons.createIcon("cancel.gif");
    public static final ImageIcon COMPASS_ICON = Icons.createIcon("compass.gif");
    public static final ImageIcon CONTROL_MODE_ICON = Icons.createIcon("control-mode.gif");
    public static final ImageIcon CONTROL_FRAME_ICON = Icons.createIcon("control-frame.gif");
    public static final ImageIcon CONTROL_FILE_ICON = Icons.createIcon("control-file.gif");
    public static final ImageIcon CONTROL_LIST_ICON = Icons.createIcon("control-file.gif");
    public static final ImageIcon COPY_ICON = Icons.createIcon("copy.gif");
    public static final ImageIcon CUT_ICON = Icons.createIcon("cut.gif");
    public static final ImageIcon DELETE_ICON = Icons.createIcon("delete.gif");
    public static final ImageIcon DISABLE_ICON = Icons.createIcon("disable.gif");
    public static final ImageIcon E_A_CHOICE_ICON = Icons.createIcon("e-a-choice.gif");
    public static final ImageIcon EMPTY_ICON = new ImageIcon();
    public static final ImageIcon COLLAPSE_ALL_ICON = Icons.createIcon("collapse-all.gif");
    public static final ImageIcon EDGE_ICON = Icons.createIcon("edge.gif");
    public static final ImageIcon EDIT_ICON = Icons.createIcon("edit.gif");
    public static final ImageIcon EDIT_CONTROL_ICON = Icons.createIcon("edit-C.gif");
    public static final ImageIcon EDIT_GRAPH_ICON = Icons.createIcon("edit-G.gif");
    public static final ImageIcon EDIT_RULE_ICON = Icons.createIcon("edit-R.gif");
    public static final ImageIcon EDIT_TYPE_ICON = Icons.createIcon("edit-T.gif");
    public static final ImageIcon EDIT_PROLOG_ICON = Icons.createIcon("edit-P.gif");
    public static final ImageIcon EDIT_STATE_ICON = Icons.createIcon("edit-S.gif");
    public static final ImageIcon ENABLE_ICON = Icons.createIcon("enable.gif");
    public static final ImageIcon ENABLE_UNIQUE_ICON = Icons.createIcon("enable_unique.gif");
    public static final ImageIcon ERROR_ICON = Icons.createIcon("error.png");
    public static final ImageIcon EXPORT_ICON = Icons.createIcon("export.gif");
    public static final ImageIcon GO_PREVIOUS_ICON = Icons.createIcon("go-previous.gif");
    public static final ImageIcon GO_FORWARD_ICON = Icons.createIcon("go-forward.gif");
    public static final ImageIcon GO_NEXT_ICON = Icons.createIcon("go-next.gif");
    public static final ImageIcon GO_START_ICON = Icons.createIcon("go-start.gif");
    public static final ImageIcon GO_STOP_ICON = Icons.createIcon("go-stop.gif");
    public static final ImageIcon GO_REWIND_ICON = Icons.createIcon("go-rewind.gif");
    public static final ImageIcon GPS_FOLDER_ICON = Icons.createIcon("gps.gif");
    public static final ImageIcon GPS_COMPRESSED_FOLDER_ICON = Icons.createIcon("gps-compressed.png");
    public static final ImageIcon GROOVE_ICON_16x16 = Icons.createIcon("groove-g-16x16.gif");
    public static final ImageIcon GRAPH_FILE_ICON = Icons.createIcon("graph-file.gif");
    public static final ImageIcon GRAPH_FRAME_ICON = Icons.createIcon("graph-frame.gif");
    public static final ImageIcon GRAPH_MATCH_ICON = Icons.createIcon("graph-match.gif");
    public static final ImageIcon GRAPH_LIST_ICON = Icons.createIcon("graph-small.gif");
    public static final ImageIcon GRAPH_MODE_ICON = Icons.createIcon("graph-mode.gif");
    public static final ImageIcon GRID_ICON = Icons.createIcon("grid.gif");
    public static final ImageIcon HAND_OPEN_CURSOR_ICON = Icons.createIcon("hand-open.gif");
    public static final ImageIcon HAND_OPEN_ICON = Icons.createIcon("hand-open-small.gif");
    public static final ImageIcon HAND_CLOSED_ICON = Icons.createIcon("hand-closed.gif");
    public static final ImageIcon HIDE_LTS_ICON = Icons.createIcon("hide-lts.png");
    public static final ImageIcon FILTER_LTS_ICON = Icons.createIcon("filter-lts.png");
    public static final ImageIcon IMPORT_ICON = Icons.createIcon("import.gif");
    public static final ImageIcon LAYOUT_ICON = Icons.createIcon("layout.gif");
    public static final ImageIcon LTS_FRAME_ICON = Icons.createIcon("lts-frame.gif");
    public static final ImageIcon LTS_MODE_ICON = Icons.createIcon("lts-mode.gif");
    public static final ImageIcon NEW_ICON = Icons.createIcon("new.gif");
    public static final ImageIcon NEW_GRAPH_ICON = Icons.createIcon("new-G.gif");
    public static final ImageIcon NEW_RULE_ICON = Icons.createIcon("new-R.gif");
    public static final ImageIcon NEW_TYPE_ICON = Icons.createIcon("new-T.gif");
    public static final ImageIcon NEW_CONTROL_ICON = Icons.createIcon("new-C.gif");
    public static final ImageIcon NEW_PROLOG_ICON = Icons.createIcon("new-P.gif");
    public static final ImageIcon OPEN_ICON = Icons.createIcon("open.gif");
    public static final ImageIcon PASTE_ICON = Icons.createIcon("paste.gif");
    public static final ImageIcon PIN_ICON = Icons.createIcon("pin.gif");
    public static final ImageIcon PREVIEW_ICON = Icons.createIcon("preview.gif");
    public static final ImageIcon PROLOG_FRAME_ICON = Icons.createIcon("prolog-frame.gif");
    public static final ImageIcon PROLOG_FILE_ICON = Icons.createIcon("prolog-file.gif");
    public static final ImageIcon PROLOG_LIST_ICON = Icons.createIcon("prolog-file.gif");
    public static final ImageIcon GROOVY_FRAME_ICON = Icons.createIcon("groovy-frame.gif");
    public static final ImageIcon GROOVY_FILE_ICON = Icons.createIcon("groovy-file.gif");
    public static final ImageIcon GROOVY_LIST_ICON = Icons.createIcon("groovy-file.gif");
    public static final ImageIcon PROPERTIES_FRAME_ICON = Icons.createIcon("properties-frame.gif");
    public static final ImageIcon REDO_ICON = Icons.createIcon("redo.gif");
    public static final ImageIcon RULE_LIST_ICON = Icons.createIcon("rule-small.gif");
    public static final ImageIcon RECIPE_LIST_ICON = Icons.createIcon("rule-small-multi.gif");
    public static final ImageIcon RULE_FILE_ICON = Icons.createIcon("rule-file.gif");
    public static final ImageIcon RULE_FRAME_ICON = Icons.createIcon("rule-frame.gif");
    public static final ImageIcon RULE_MODE_ICON = Icons.createIcon("rule-mode.gif");
    public static final ImageIcon SAVE_ICON = Icons.createIcon("save.gif");
    public static final ImageIcon SAVE_AS_ICON = Icons.createIcon("saveas.gif");
    public static final ImageIcon SELECT_ICON = Icons.createIcon("select.gif");
    public static final ImageIcon SEARCH_ICON = Icons.createIcon("search.gif");
    public static final ImageIcon RENAME_ICON = Icons.createIcon("rename.gif");
    public static final ImageIcon STATE_CLOSED_ICON = Icons.createIcon("state-closed.gif");
    public static final ImageIcon STATE_FINAL_ICON = Icons.createIcon("state-final.gif");
    public static final ImageIcon STATE_FRAME_ICON = Icons.createIcon("state-frame.gif");
    public static final ImageIcon STATE_MODE_ICON = Icons.createIcon("state-mode.gif");
    public static final ImageIcon STATE_OPEN_ICON = Icons.createIcon("state-open.gif");
    public static final ImageIcon STATE_RESULT_ICON = Icons.createIcon("state-result.gif");
    public static final ImageIcon STATE_START_ICON = Icons.createIcon("state-start.gif");
    public static final ImageIcon TYPE_FILE_ICON = Icons.createIcon("type-file.gif");
    public static final ImageIcon TYPE_FRAME_ICON = Icons.createIcon("type-frame.gif");
    public static final ImageIcon TYPE_LIST_ICON = Icons.createIcon("type-small.gif");
    public static final ImageIcon TYPE_MODE_ICON = Icons.createIcon("type-mode.gif");
    public static final ImageIcon UNDO_ICON = Icons.createIcon("undo.gif");
    public static final ImageIcon ZOOM_IN_ICON = Icons.createIcon("zoomin.gif");
    public static final ImageIcon ZOOM_OUT_ICON = Icons.createIcon("zoomout.gif");
    public static final Cursor HAND_OPEN_CURSOR = Icons.createCursor("Open Hand", HAND_OPEN_CURSOR_ICON);
    public static final Cursor HAND_CLOSED_CURSOR = Icons.createCursor("Closed Hand", HAND_CLOSED_ICON);

    public static ImageIcon getEditIcon(EditType edit, ResourceKind resource) {
        switch (edit) {
            case COPY: {
                return COPY_ICON;
            }
            case CREATE: {
                if (resource == null) {
                    return NEW_ICON;
                }
                switch (resource) {
                    case CONTROL: {
                        return NEW_CONTROL_ICON;
                    }
                    case HOST: {
                        return NEW_GRAPH_ICON;
                    }
                    case PROLOG: {
                        return NEW_PROLOG_ICON;
                    }
                    case GROOVY: {
                        return NEW_ICON;
                    }
                    case RULE: {
                        return NEW_RULE_ICON;
                    }
                    case TYPE: {
                        return NEW_TYPE_ICON;
                    }
                }
                assert (false);
                return null;
            }
            case DELETE: {
                return DELETE_ICON;
            }
            case MODIFY: {
                if (resource == null) {
                    return EDIT_ICON;
                }
                switch (resource) {
                    case CONTROL: {
                        return EDIT_CONTROL_ICON;
                    }
                    case HOST: {
                        return EDIT_GRAPH_ICON;
                    }
                    case PROLOG: {
                        return EDIT_PROLOG_ICON;
                    }
                    case GROOVY: {
                        return EDIT_ICON;
                    }
                    case PROPERTIES: {
                        return EDIT_ICON;
                    }
                    case RULE: {
                        return EDIT_RULE_ICON;
                    }
                    case TYPE: {
                        return EDIT_TYPE_ICON;
                    }
                }
                assert (false);
                return null;
            }
            case RENAME: {
                return RENAME_ICON;
            }
            case ENABLE: {
                return ENABLE_ICON;
            }
        }
        assert (false);
        return null;
    }

    public static ImageIcon getMainTabIcon(ResourceKind resource) {
        switch (resource) {
            case CONTROL: {
                return CONTROL_FILE_ICON;
            }
            case HOST: {
                return GRAPH_MODE_ICON;
            }
            case PROLOG: {
                return PROLOG_FILE_ICON;
            }
            case GROOVY: {
                return GROOVY_FILE_ICON;
            }
            case RULE: {
                return RULE_MODE_ICON;
            }
            case TYPE: {
                return TYPE_MODE_ICON;
            }
        }
        assert (false);
        return null;
    }

    public static ImageIcon getEditorTabIcon(ResourceKind resource) {
        switch (resource) {
            case CONTROL: {
                return EDIT_CONTROL_ICON;
            }
            case HOST: {
                return EDIT_GRAPH_ICON;
            }
            case PROLOG: {
                return EDIT_PROLOG_ICON;
            }
            case GROOVY: {
                return EDIT_ICON;
            }
            case RULE: {
                return EDIT_RULE_ICON;
            }
            case TYPE: {
                return EDIT_TYPE_ICON;
            }
        }
        assert (false);
        return null;
    }

    public static ImageIcon getListIcon(ResourceKind resource) {
        switch (resource) {
            case CONTROL: {
                return CONTROL_LIST_ICON;
            }
            case HOST: {
                return GRAPH_LIST_ICON;
            }
            case PROLOG: {
                return PROLOG_LIST_ICON;
            }
            case GROOVY: {
                return GROOVY_LIST_ICON;
            }
            case RULE: {
                return RULE_LIST_ICON;
            }
            case TYPE: {
                return TYPE_LIST_ICON;
            }
        }
        assert (false);
        return null;
    }

    private static ImageIcon createIcon(String filename) {
        return new ImageIcon(Groove.getResource(filename));
    }

    private static Cursor createCursor(String name, ImageIcon icon) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image cursorImage = icon.getImage();
        return tk.createCustomCursor(cursorImage, new Point(0, 0), name);
    }
}

