/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.util.History;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class StepHistory
implements SimulatorListener {
    private final Simulator simulator;
    private final SimulatorModel simulatorModel;
    protected final BackAction undoAction;
    protected final ForwardAction redoAction;
    protected final History<HistoryAction> history = new History();
    protected boolean ignoreSimulationUpdates;
    private static final boolean DEBUG = false;

    public StepHistory(Simulator simulator) {
        this.simulator = simulator;
        this.simulatorModel = simulator.getModel();
        this.undoAction = new BackAction();
        this.redoAction = new ForwardAction();
        this.simulatorModel.addListener(this, SimulatorModel.Change.GTS, SimulatorModel.Change.STATE, SimulatorModel.Change.MATCH);
    }

    public Action getForwardAction() {
        return this.redoAction;
    }

    public Action getBackAction() {
        return this.undoAction;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (changes.contains((Object)SimulatorModel.Change.GTS) && source.getGts() != oldModel.getGts()) {
            this.history.clear();
            this.refreshActions();
        }
        if (changes.contains((Object)SimulatorModel.Change.STATE) && source.hasState()) {
            this.setStateUpdate(source.getState());
        }
        if (changes.contains((Object)SimulatorModel.Change.MATCH) && source.hasTransition()) {
            this.setTransitionUpdate(source.getTransition());
        }
    }

    private synchronized void setStateUpdate(GraphState state) {
        if (!this.ignoreSimulationUpdates) {
            SetStateAction newAction = new SetStateAction(state);
            if (this.history.isEmpty() || !state.equals(this.history.current().getState())) {
                this.history.add(newAction);
            } else {
                this.history.replace(newAction);
            }
        }
        this.refreshActions();
    }

    private synchronized void setTransitionUpdate(GraphTransition transition) {
        if (!this.ignoreSimulationUpdates) {
            SetTransitionAction newAction = new SetTransitionAction(transition);
            if (this.history.isEmpty() || !transition.source().equals(this.history.current().getState())) {
                this.history.add(newAction);
            } else {
                this.history.replace(newAction);
            }
        }
        this.refreshActions();
    }

    protected void doHistoryAction(HistoryAction action) {
        if (action instanceof SetStateAction) {
            this.simulatorModel.setState(action.getState());
        } else {
            assert (action instanceof SetTransitionAction);
            this.simulatorModel.setTransition(action.getTransition());
        }
    }

    private void refreshActions() {
        this.undoAction.setEnabled(this.history.hasPrevious());
        this.redoAction.setEnabled(this.history.hasNext());
    }

    private class BackAction
    extends AbstractAction {
        BackAction() {
            super("Step Back", Icons.ARROW_SIMPLE_LEFT_ICON);
            this.putValue("AcceleratorKey", Options.BACK_KEY);
            this.putValue("ShortDescription", "Step Back");
            StepHistory.this.simulator.addAccelerator(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (StepHistory.this.history.hasPrevious()) {
                StepHistory.this.ignoreSimulationUpdates = true;
                HistoryAction previous = StepHistory.this.history.previous();
                StepHistory.this.doHistoryAction(previous);
                StepHistory.this.ignoreSimulationUpdates = false;
            }
        }
    }

    private class ForwardAction
    extends AbstractAction {
        ForwardAction() {
            super("Step Forward", Icons.ARROW_SIMPLE_RIGHT_ICON);
            this.putValue("AcceleratorKey", Options.FORWARD_KEY);
            this.putValue("ShortDescription", "Step Forward");
            StepHistory.this.simulator.addAccelerator(this);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (StepHistory.this.history.hasNext()) {
                StepHistory.this.ignoreSimulationUpdates = true;
                HistoryAction next = StepHistory.this.history.next();
                StepHistory.this.doHistoryAction(next);
                StepHistory.this.ignoreSimulationUpdates = false;
            }
        }
    }

    private static abstract class HistoryAction {
        private final GraphState state;
        private final GraphTransition transition;

        public HistoryAction(GraphState state, GraphTransition transition) {
            this.transition = transition;
            this.state = state == null ? transition.source() : state;
        }

        GraphState getState() {
            return this.state;
        }

        GraphTransition getTransition() {
            return this.transition;
        }

        public boolean equals(Object obj) {
            return obj instanceof HistoryAction && this.stateEquals((HistoryAction)obj) && this.transitionEquals((HistoryAction)obj);
        }

        protected boolean stateEquals(HistoryAction other) {
            if (this.state == null) {
                return other.state == null;
            }
            return this.state.equals(other.state);
        }

        protected boolean transitionEquals(HistoryAction other) {
            if (this.transition == null) {
                return other.transition == null;
            }
            return this.transition.equals(other.transition);
        }
    }

    private class SetStateAction
    extends HistoryAction {
        public SetStateAction(GraphState state) {
            super(state, null);
        }
    }

    private class SetTransitionAction
    extends HistoryAction {
        public SetTransitionAction(GraphTransition transition) {
            super(null, transition);
        }
    }
}

