/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.FormatException;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.dialog.StringDialog;
import groove.gui.display.DisplayKind;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.verify.DefaultMarker;
import groove.verify.Formula;
import groove.verify.FormulaParser;
import groove.verify.ParseException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class CheckCTLAction
extends SimulatorAction {
    private final boolean full;
    private StringDialog ctlFormulaDialog;

    public CheckCTLAction(Simulator simulator, boolean full) {
        super(simulator, full ? "Check CTL property (full state space)" : "Check CTL property (current state space)", null);
        this.full = full;
    }

    @Override
    public void execute() {
        block5: {
            String property = this.getCtlFormulaDialog().showDialog(this.getFrame());
            if (property != null) {
                boolean doCheck = true;
                GTS gts = this.getSimulatorModel().getGts();
                if (gts.hasOpenStates() && this.full && this.getSimulatorModel().setGts()) {
                    this.getActions().getExploreAction().explore(this.getSimulatorModel().getExploration(), true, false);
                    gts = this.getSimulatorModel().getGts();
                    boolean bl = doCheck = !gts.hasOpenStates();
                }
                if (doCheck) {
                    try {
                        this.doCheckProperty(gts, FormulaParser.parse(property).toCtlFormula());
                    }
                    catch (ParseException parseException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    private StringDialog getCtlFormulaDialog() {
        if (this.ctlFormulaDialog == null) {
            this.ctlFormulaDialog = new StringDialog("Enter the CTL Formula", FormulaParser.getDocMap(true)){

                @Override
                public String parse(String text) throws FormatException {
                    try {
                        FormulaParser.parse(text).toCtlFormula();
                    }
                    catch (ParseException efe) {
                        throw new FormatException(efe.getMessage(), new Object[0]);
                    }
                    return text;
                }
            };
        }
        return this.ctlFormulaDialog;
    }

    private void doCheckProperty(GTS gts, Formula formula) {
        String message;
        DefaultMarker modelChecker = new DefaultMarker(formula, gts);
        modelChecker.verify();
        int counterExampleCount = modelChecker.getCount(false);
        ArrayList<GraphState> counterExamples = new ArrayList<GraphState>(counterExampleCount);
        if (counterExampleCount == 0) {
            message = String.format("The property '%s' holds for all states", formula);
        } else {
            boolean allStates = this.confirmBehaviour("Check CTL on all states?", "Verify all states? Choosing 'No' will report only on the start state.");
            if (allStates) {
                for (GraphState state : modelChecker.getStates(false)) {
                    counterExamples.add(state);
                }
                message = String.format("The property '%s' fails to hold in the %d highlighted states", formula, counterExampleCount);
            } else if (modelChecker.hasValue(false)) {
                counterExamples.add(gts.startState());
                message = String.format("The property '%s' fails to hold in the initial state", formula);
            } else {
                message = String.format("The property '%s' holds in the initial state", formula);
            }
        }
        this.getLtsDisplay().emphasiseStates(counterExamples, false);
        this.getSimulatorModel().setDisplay(DisplayKind.LTS);
        JOptionPane.showMessageDialog(this.getFrame(), message);
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().getGts() != null);
    }
}

