/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.GrammarProperties;
import groove.gui.Icons;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.dialog.PropertiesDialog;
import java.io.IOException;

public class EditSystemPropertiesAction
extends SimulatorAction {
    public EditSystemPropertiesAction(Simulator simulator) {
        super(simulator, "Grammar Properties ...", Icons.EDIT_ICON);
    }

    @Override
    public void execute() {
        GrammarProperties systemProperties = this.getGrammarModel().getProperties();
        PropertiesDialog dialog = new PropertiesDialog(systemProperties, GrammarProperties.KEYS);
        if (dialog.showDialog(this.getFrame())) {
            GrammarProperties newProperties = new GrammarProperties();
            newProperties.putAll(dialog.getProperties());
            try {
                this.getSimulatorModel().doSetProperties(newProperties);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error while saving edited properties", new Object[0]);
            }
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getGrammarStore() != null && this.getGrammarStore().isModifiable());
    }
}

